/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http2;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.CoalescingBufferQueue;
import com.appoptics.ext.io.netty.handler.codec.http.HttpStatusClass;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Flags;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2LifecycleManager;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2SettingsReceivedConsumer;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public class DefaultHttp2ConnectionEncoder
implements Http2ConnectionEncoder,
Http2SettingsReceivedConsumer {
    private final Http2FrameWriter frameWriter;
    private final Http2Connection connection;
    private Http2LifecycleManager lifecycleManager;
    private final Queue<Http2Settings> outstandingLocalSettingsQueue = new ArrayDeque<Http2Settings>(4);
    private Queue<Http2Settings> outstandingRemoteSettingsQueue;

    public DefaultHttp2ConnectionEncoder(Http2Connection http2Connection, Http2FrameWriter http2FrameWriter) {
        this.connection = ObjectUtil.checkNotNull(http2Connection, "connection");
        this.frameWriter = ObjectUtil.checkNotNull(http2FrameWriter, "frameWriter");
        if (http2Connection.remote().flowController() == null) {
            http2Connection.remote().flowController(new DefaultHttp2RemoteFlowController(http2Connection));
        }
    }

    public void lifecycleManager(Http2LifecycleManager http2LifecycleManager) {
        this.lifecycleManager = ObjectUtil.checkNotNull(http2LifecycleManager, "lifecycleManager");
    }

    public Http2FrameWriter frameWriter() {
        return this.frameWriter;
    }

    public Http2Connection connection() {
        return this.connection;
    }

    public final Http2RemoteFlowController flowController() {
        return this.connection().remote().flowController();
    }

    public void remoteSettings(Http2Settings object) throws Http2Exception {
        Comparable<Boolean> comparable = ((Http2Settings)object).pushEnabled();
        Object object2 = this.configuration();
        Http2HeadersEncoder.Configuration configuration = object2.headersConfiguration();
        object2 = object2.frameSizePolicy();
        if (comparable != null) {
            if (!this.connection.isServer() && ((Boolean)comparable).booleanValue()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Client received a value of ENABLE_PUSH specified to other than 0", new Object[0]);
            }
            this.connection.remote().allowPushTo((Boolean)comparable);
        }
        if ((comparable = ((Http2Settings)object).maxConcurrentStreams()) != null) {
            this.connection.local().maxActiveStreams((int)Math.min((Long)comparable, Integer.MAX_VALUE));
        }
        if ((comparable = ((Http2Settings)object).headerTableSize()) != null) {
            configuration.maxHeaderTableSize((int)Math.min((Long)comparable, Integer.MAX_VALUE));
        }
        if ((comparable = ((Http2Settings)object).maxHeaderListSize()) != null) {
            configuration.maxHeaderListSize((Long)comparable);
        }
        if ((comparable = ((Http2Settings)object).maxFrameSize()) != null) {
            object2.maxFrameSize((Integer)comparable);
        }
        if ((object = ((Http2Settings)object).initialWindowSize()) != null) {
            this.flowController().initialWindowSize((Integer)object);
        }
    }

    public ChannelFuture writeData(ChannelHandlerContext object, int n2, ByteBuf byteBuf, int n3, boolean bl, ChannelPromise channelPromise) {
        try {
            object = this.requireStream(n2);
            switch (object.state()) {
                case OPEN: 
                case HALF_CLOSED_REMOTE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Stream " + object.id() + " in unexpected state " + (Object)((Object)object.state()));
                }
            }
        }
        catch (Throwable throwable) {
            byteBuf.release();
            return channelPromise.setFailure(throwable);
        }
        this.flowController().addFlowControlled((Http2Stream)object, new FlowControlledData((Http2Stream)object, byteBuf, n3, bl, channelPromise));
        return channelPromise;
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl, ChannelPromise channelPromise) {
        return this.writeHeaders0(channelHandlerContext, n2, http2Headers, false, 0, (short)0, false, n3, bl, channelPromise);
    }

    private static boolean validateHeadersSentState(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl, boolean bl2) {
        boolean bl3 = bl && HttpStatusClass.valueOf(http2Headers.status()) == HttpStatusClass.INFORMATIONAL;
        if ((bl3 || !bl2) && http2Stream.isHeadersSent() || http2Stream.isTrailersSent()) {
            throw new IllegalStateException("Stream " + http2Stream.id() + " sent too many headers EOS: " + bl2);
        }
        return bl3;
    }

    public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2, ChannelPromise channelPromise) {
        return this.writeHeaders0(channelHandlerContext, n2, http2Headers, true, n3, s2, bl, n4, bl2, channelPromise);
    }

    private static ChannelFuture sendHeaders(Http2FrameWriter http2FrameWriter, ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, boolean bl, int n3, short s2, boolean bl2, int n4, boolean bl3, ChannelPromise channelPromise) {
        if (bl) {
            return http2FrameWriter.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl2, n4, bl3, channelPromise);
        }
        return http2FrameWriter.writeHeaders(channelHandlerContext, n2, http2Headers, n4, bl3, channelPromise);
    }

    private ChannelFuture writeHeaders0(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers object, boolean bl, int n3, short s2, boolean bl2, int n4, boolean bl3, ChannelPromise channelPromise) {
        try {
            Http2Stream http2Stream = this.connection.stream(n2);
            if (http2Stream == null) {
                try {
                    http2Stream = this.connection.local().createStream(n2, false);
                }
                catch (Http2Exception http2Exception) {
                    if (this.connection.remote().mayHaveCreatedStream(n2)) {
                        channelPromise.tryFailure(new IllegalStateException("Stream no longer exists: " + n2, http2Exception));
                        return channelPromise;
                    }
                    throw http2Exception;
                }
            } else {
                switch (http2Stream.state()) {
                    case RESERVED_LOCAL: {
                        http2Stream.open(bl3);
                        break;
                    }
                    case OPEN: 
                    case HALF_CLOSED_REMOTE: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Stream " + http2Stream.id() + " in unexpected state " + (Object)((Object)http2Stream.state()));
                    }
                }
            }
            Http2RemoteFlowController http2RemoteFlowController = this.flowController();
            if (!bl3 || !http2RemoteFlowController.hasFlowControlled(http2Stream)) {
                channelPromise = channelPromise.unvoid();
                boolean bl4 = DefaultHttp2ConnectionEncoder.validateHeadersSentState(http2Stream, (Http2Headers)object, this.connection.isServer(), bl3);
                ChannelFuture channelFuture = DefaultHttp2ConnectionEncoder.sendHeaders(this.frameWriter, channelHandlerContext, n2, (Http2Headers)object, bl, n3, s2, bl2, n4, bl3, channelPromise);
                if ((object = channelFuture.cause()) == null) {
                    http2Stream.headersSent(bl4);
                    if (!channelFuture.isSuccess()) {
                        this.notifyLifecycleManagerOnError(channelFuture, channelHandlerContext);
                    }
                } else {
                    this.lifecycleManager.onError(channelHandlerContext, true, (Throwable)object);
                }
                if (bl3) {
                    this.lifecycleManager.closeStreamLocal(http2Stream, channelFuture);
                }
                return channelFuture;
            }
            http2RemoteFlowController.addFlowControlled(http2Stream, new FlowControlledHeaders(http2Stream, (Http2Headers)object, bl, n3, s2, bl2, n4, true, channelPromise));
            return channelPromise;
        }
        catch (Throwable throwable) {
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            channelPromise.tryFailure(throwable);
            return channelPromise;
        }
    }

    public ChannelFuture writeRstStream(ChannelHandlerContext channelHandlerContext, int n2, long l2, ChannelPromise channelPromise) {
        return this.lifecycleManager.resetStream(channelHandlerContext, n2, l2, channelPromise);
    }

    public ChannelFuture writeSettings(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings, ChannelPromise channelPromise) {
        this.outstandingLocalSettingsQueue.add(http2Settings);
        try {
            Boolean bl = http2Settings.pushEnabled();
            if (bl != null && this.connection.isServer()) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Server sending SETTINGS frame with ENABLE_PUSH specified", new Object[0]);
            }
        }
        catch (Throwable throwable) {
            return channelPromise.setFailure(throwable);
        }
        return this.frameWriter.writeSettings(channelHandlerContext, http2Settings, channelPromise);
    }

    public ChannelFuture writeSettingsAck(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.outstandingRemoteSettingsQueue == null) {
            return this.frameWriter.writeSettingsAck(channelHandlerContext, channelPromise);
        }
        Http2Settings http2Settings = this.outstandingRemoteSettingsQueue.poll();
        if (http2Settings == null) {
            return channelPromise.setFailure(new Http2Exception(Http2Error.INTERNAL_ERROR, "attempted to write a SETTINGS ACK with no  pending SETTINGS"));
        }
        channelPromise = new Http2CodecUtil.SimpleChannelPromiseAggregator(channelPromise, channelHandlerContext.channel(), channelHandlerContext.executor());
        this.frameWriter.writeSettingsAck(channelHandlerContext, ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise());
        ChannelPromise channelPromise2 = ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).newPromise();
        try {
            this.remoteSettings(http2Settings);
            channelPromise2.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise2.setFailure(throwable);
            this.lifecycleManager.onError(channelHandlerContext, true, throwable);
        }
        return ((Http2CodecUtil.SimpleChannelPromiseAggregator)channelPromise).doneAllocatingPromises();
    }

    public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l2, ChannelPromise channelPromise) {
        return this.frameWriter.writePing(channelHandlerContext, bl, l2, channelPromise);
    }

    public ChannelFuture writeGoAway(ChannelHandlerContext channelHandlerContext, int n2, long l2, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.lifecycleManager.goAway(channelHandlerContext, n2, l2, byteBuf, channelPromise);
    }

    public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
        return channelPromise.setFailure(new UnsupportedOperationException("Use the Http2[Inbound|Outbound]FlowController objects to control window sizes"));
    }

    public ChannelFuture writeFrame(ChannelHandlerContext channelHandlerContext, byte by, int n2, Http2Flags http2Flags, ByteBuf byteBuf, ChannelPromise channelPromise) {
        return this.frameWriter.writeFrame(channelHandlerContext, by, n2, http2Flags, byteBuf, channelPromise);
    }

    public void close() {
        this.frameWriter.close();
    }

    public Http2Settings pollSentSettings() {
        return this.outstandingLocalSettingsQueue.poll();
    }

    public Http2FrameWriter.Configuration configuration() {
        return this.frameWriter.configuration();
    }

    private Http2Stream requireStream(int n2) {
        Http2Stream http2Stream = this.connection.stream(n2);
        if (http2Stream == null) {
            String string = this.connection.streamMayHaveExisted(n2) ? "Stream no longer exists: " + n2 : "Stream does not exist: " + n2;
            throw new IllegalArgumentException(string);
        }
        return http2Stream;
    }

    public void consumeReceivedSettings(Http2Settings http2Settings) {
        if (this.outstandingRemoteSettingsQueue == null) {
            this.outstandingRemoteSettingsQueue = new ArrayDeque<Http2Settings>(2);
        }
        this.outstandingRemoteSettingsQueue.add(http2Settings);
    }

    private void notifyLifecycleManagerOnError(ChannelFuture channelFuture, final ChannelHandlerContext channelHandlerContext) {
        channelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture object) throws Exception {
                if ((object = object.cause()) != null) {
                    DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(channelHandlerContext, true, (Throwable)object);
                }
            }
        });
    }

    public abstract class FlowControlledBase
    implements ChannelFutureListener,
    Http2RemoteFlowController.FlowControlled {
        protected final Http2Stream stream;
        protected ChannelPromise promise;
        protected boolean endOfStream;
        protected int padding;

        FlowControlledBase(Http2Stream http2Stream, int n2, boolean bl, ChannelPromise channelPromise) {
            ObjectUtil.checkPositiveOrZero(n2, "padding");
            this.padding = n2;
            this.endOfStream = bl;
            this.stream = http2Stream;
            this.promise = channelPromise;
        }

        public void writeComplete() {
            if (this.endOfStream) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.closeStreamLocal(this.stream, this.promise);
            }
        }

        public void operationComplete(ChannelFuture channelFuture) throws Exception {
            if (!channelFuture.isSuccess()) {
                FlowControlledBase flowControlledBase = this;
                flowControlledBase.error(flowControlledBase.DefaultHttp2ConnectionEncoder.this.flowController().channelHandlerContext(), channelFuture.cause());
            }
        }
    }

    private final class FlowControlledHeaders
    extends FlowControlledBase {
        private final Http2Headers headers;
        private final boolean hasPriorty;
        private final int streamDependency;
        private final short weight;
        private final boolean exclusive;

        FlowControlledHeaders(Http2Stream http2Stream, Http2Headers http2Headers, boolean bl, int n2, short s2, boolean bl2, int n3, boolean bl3, ChannelPromise channelPromise) {
            super(http2Stream, n3, bl3, channelPromise.unvoid());
            this.headers = http2Headers;
            this.hasPriorty = bl;
            this.streamDependency = n2;
            this.weight = s2;
            this.exclusive = bl2;
        }

        public final int size() {
            return 0;
        }

        public final void error(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            if (channelHandlerContext != null) {
                DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(channelHandlerContext, true, throwable);
            }
            this.promise.tryFailure(throwable);
        }

        public final void write(ChannelHandlerContext object, int n2) {
            n2 = DefaultHttp2ConnectionEncoder.validateHeadersSentState(this.stream, this.headers, DefaultHttp2ConnectionEncoder.this.connection.isServer(), this.endOfStream) ? 1 : 0;
            this.promise.addListener(this);
            object = DefaultHttp2ConnectionEncoder.sendHeaders(DefaultHttp2ConnectionEncoder.this.frameWriter, (ChannelHandlerContext)object, this.stream.id(), this.headers, this.hasPriorty, this.streamDependency, this.weight, this.exclusive, this.padding, this.endOfStream, this.promise);
            object = object.cause();
            if (object == null) {
                this.stream.headersSent(n2 != 0);
            }
        }

        public final boolean merge(ChannelHandlerContext channelHandlerContext, Http2RemoteFlowController.FlowControlled flowControlled) {
            return false;
        }
    }

    private final class FlowControlledData
    extends FlowControlledBase {
        private final CoalescingBufferQueue queue;
        private int dataSize;

        FlowControlledData(Http2Stream http2Stream, ByteBuf byteBuf, int n2, boolean bl, ChannelPromise channelPromise) {
            super(http2Stream, n2, bl, channelPromise);
            this.queue = new CoalescingBufferQueue(channelPromise.channel());
            this.queue.add(byteBuf, channelPromise);
            this.dataSize = this.queue.readableBytes();
        }

        public final int size() {
            return this.dataSize + this.padding;
        }

        public final void error(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            this.queue.releaseAndFailAll(throwable);
            DefaultHttp2ConnectionEncoder.this.lifecycleManager.onError(channelHandlerContext, true, throwable);
        }

        public final void write(ChannelHandlerContext channelHandlerContext, int n2) {
            int n3 = this.queue.readableBytes();
            if (!this.endOfStream) {
                if (n3 == 0) {
                    if (this.queue.isEmpty()) {
                        FlowControlledData flowControlledData = this;
                        flowControlledData.dataSize = 0;
                        flowControlledData.padding = 0;
                        return;
                    }
                    ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener(this);
                    channelHandlerContext.write(this.queue.remove(0, channelPromise), channelPromise);
                    return;
                }
                if (n2 == 0) {
                    return;
                }
            }
            n3 = Math.min(n3, n2);
            ChannelPromise channelPromise = channelHandlerContext.newPromise().addListener(this);
            ByteBuf byteBuf = this.queue.remove(n3, channelPromise);
            this.dataSize = this.queue.readableBytes();
            n2 = Math.min(n2 - n3, this.padding);
            this.padding -= n2;
            DefaultHttp2ConnectionEncoder.this.frameWriter().writeData(channelHandlerContext, this.stream.id(), byteBuf, n2, this.endOfStream && this.size() == 0, channelPromise);
        }

        public final boolean merge(ChannelHandlerContext object, Http2RemoteFlowController.FlowControlled flowControlled) {
            if (FlowControlledData.class != flowControlled.getClass() || Integer.MAX_VALUE - ((FlowControlledData)(object = (FlowControlledData)flowControlled)).size() < this.size()) {
                return false;
            }
            ((FlowControlledData)object).queue.copyTo(this.queue);
            this.dataSize = this.queue.readableBytes();
            this.padding = Math.max(this.padding, ((FlowControlledData)object).padding);
            this.endOfStream = ((FlowControlledData)object).endOfStream;
            return true;
        }
    }
}

