/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderNames;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaderValues;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMethod;
import com.appoptics.ext.io.netty.handler.codec.http.HttpRequest;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class HttpUtil {
    private static final AsciiString CHARSET_EQUALS = AsciiString.of(HttpHeaderValues.CHARSET + "=");
    private static final AsciiString SEMICOLON = AsciiString.cached(";");

    public static boolean isOriginForm(URI uRI) {
        return uRI.getScheme() == null && uRI.getSchemeSpecificPart() == null && uRI.getHost() == null && uRI.getAuthority() == null;
    }

    public static boolean isAsteriskForm(URI uRI) {
        return "*".equals(uRI.getPath()) && uRI.getScheme() == null && uRI.getSchemeSpecificPart() == null && uRI.getHost() == null && uRI.getAuthority() == null && uRI.getQuery() == null && uRI.getFragment() == null;
    }

    public static boolean isKeepAlive(HttpMessage httpMessage) {
        return !httpMessage.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE, true) && (httpMessage.protocolVersion().isKeepAliveDefault() || httpMessage.headers().containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE, true));
    }

    public static long getContentLength(HttpMessage httpMessage, long l2) {
        String string = httpMessage.headers().get(HttpHeaderNames.CONTENT_LENGTH);
        if (string != null) {
            return Long.parseLong(string);
        }
        long l3 = HttpUtil.getWebSocketContentLength(httpMessage);
        if (l3 >= 0L) {
            return l3;
        }
        return l2;
    }

    private static int getWebSocketContentLength(HttpMessage httpMessage) {
        HttpHeaders httpHeaders = httpMessage.headers();
        if (httpMessage instanceof HttpRequest) {
            if (HttpMethod.GET.equals((httpMessage = (HttpRequest)httpMessage).method()) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY1) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_KEY2)) {
                return 8;
            }
        } else if (httpMessage instanceof HttpResponse && (httpMessage = (HttpResponse)httpMessage).status().code() == 101 && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN) && httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_LOCATION)) {
            return 16;
        }
        return -1;
    }

    public static boolean isContentLengthSet(HttpMessage httpMessage) {
        return httpMessage.headers().contains(HttpHeaderNames.CONTENT_LENGTH);
    }

    public static boolean is100ContinueExpected(HttpMessage httpMessage) {
        return HttpUtil.isExpectHeaderValid(httpMessage) && httpMessage.headers().contains(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE, true);
    }

    static boolean isUnsupportedExpectation(HttpMessage object) {
        if (!HttpUtil.isExpectHeaderValid((HttpMessage)object)) {
            return false;
        }
        return (object = object.headers().get(HttpHeaderNames.EXPECT)) != null && !HttpHeaderValues.CONTINUE.toString().equalsIgnoreCase((String)object);
    }

    private static boolean isExpectHeaderValid(HttpMessage httpMessage) {
        return httpMessage instanceof HttpRequest && httpMessage.protocolVersion().compareTo(HttpVersion.HTTP_1_1) >= 0;
    }

    public static boolean isTransferEncodingChunked(HttpMessage httpMessage) {
        return httpMessage.headers().containsValue(HttpHeaderNames.TRANSFER_ENCODING, HttpHeaderValues.CHUNKED, true);
    }

    public static void setTransferEncodingChunked(HttpMessage httpMessage, boolean bl) {
        if (bl) {
            httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            httpMessage.headers().remove(HttpHeaderNames.CONTENT_LENGTH);
            return;
        }
        List<String> list = httpMessage.headers().getAll(HttpHeaderNames.TRANSFER_ENCODING);
        if (list.isEmpty()) {
            return;
        }
        list = new ArrayList<String>(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CharSequence charSequence = (CharSequence)iterator.next();
            if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(charSequence)) continue;
            iterator.remove();
        }
        if (list.isEmpty()) {
            httpMessage.headers().remove(HttpHeaderNames.TRANSFER_ENCODING);
            return;
        }
        httpMessage.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, list);
    }

    public static String formatHostnameForHttp(InetSocketAddress inetSocketAddress) {
        String string = NetUtil.getHostname(inetSocketAddress);
        if (NetUtil.isValidIpV6Address(string)) {
            if (!inetSocketAddress.isUnresolved()) {
                string = NetUtil.toAddressString(inetSocketAddress.getAddress());
            }
            return "[" + string + ']';
        }
        return string;
    }
}

