/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.FileRegion;
import com.appoptics.ext.io.netty.handler.codec.MessageToMessageEncoder;
import com.appoptics.ext.io.netty.handler.codec.http.HttpContent;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeadersEncoder;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessage;
import com.appoptics.ext.io.netty.handler.codec.http.HttpObject;
import com.appoptics.ext.io.netty.handler.codec.http.HttpUtil;
import com.appoptics.ext.io.netty.handler.codec.http.LastHttpContent;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpObjectEncoder<H extends HttpMessage>
extends MessageToMessageEncoder<Object> {
    private static final byte[] ZERO_CRLF_CRLF = new byte[]{48, 13, 10, 13, 10};
    private static final ByteBuf CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(2).writeByte(13).writeByte(10));
    private static final ByteBuf ZERO_CRLF_CRLF_BUF = Unpooled.unreleasableBuffer(Unpooled.directBuffer(ZERO_CRLF_CRLF.length).writeBytes(ZERO_CRLF_CRLF));
    private int state = 0;
    private float headersEncodedSizeAccumulator = 256.0f;
    private float trailersEncodedSizeAccumulator = 256.0f;

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, Object object, List<Object> list) throws Exception {
        Object object2;
        ByteBuf byteBuf = null;
        if (object instanceof HttpMessage) {
            if (this.state != 0) {
                throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(object) + ", state: " + this.state);
            }
            object2 = (HttpMessage)object;
            byteBuf = channelHandlerContext.alloc().buffer((int)this.headersEncodedSizeAccumulator);
            this.encodeInitialLine(byteBuf, object2);
            this.state = this.isContentAlwaysEmpty(object2) ? 3 : (HttpUtil.isTransferEncodingChunked((HttpMessage)object2) ? 2 : 1);
            this.sanitizeHeadersBeforeEncode(object2, this.state == 3);
            this.encodeHeaders(object2.headers(), byteBuf);
            ByteBufUtil.writeShortBE(byteBuf, 3338);
            this.headersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf.readableBytes()) + 0.8f * this.headersEncodedSizeAccumulator;
        }
        if (object instanceof ByteBuf && !((ByteBuf)(object2 = (ByteBuf)object)).isReadable()) {
            list.add(((ByteBuf)object2).retain());
            return;
        }
        if (object instanceof HttpContent || object instanceof ByteBuf || object instanceof FileRegion) {
            switch (this.state) {
                case 0: {
                    throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(object));
                }
                case 1: {
                    long l2 = HttpObjectEncoder.contentLength(object);
                    if (l2 > 0L) {
                        if (byteBuf != null && (long)byteBuf.writableBytes() >= l2 && object instanceof HttpContent) {
                            byteBuf.writeBytes(((HttpContent)object).content());
                            list.add(byteBuf);
                        } else {
                            if (byteBuf != null) {
                                list.add(byteBuf);
                            }
                            list.add(HttpObjectEncoder.encodeAndRetain(object));
                        }
                        if (!(object instanceof LastHttpContent)) break;
                        this.state = 0;
                        break;
                    }
                }
                case 3: {
                    if (byteBuf != null) {
                        list.add(byteBuf);
                        break;
                    }
                    list.add(Unpooled.EMPTY_BUFFER);
                    break;
                }
                case 2: {
                    if (byteBuf != null) {
                        list.add(byteBuf);
                    }
                    Object object3 = object;
                    this.encodeChunkedContent(channelHandlerContext, object3, HttpObjectEncoder.contentLength(object3), list);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            if (object instanceof LastHttpContent) {
                this.state = 0;
                return;
            }
        } else if (byteBuf != null) {
            list.add(byteBuf);
        }
    }

    protected void encodeHeaders(HttpHeaders object, ByteBuf byteBuf) {
        object = ((HttpHeaders)object).iteratorCharSequence();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            HttpHeadersEncoder.encoderHeader((CharSequence)entry.getKey(), (CharSequence)entry.getValue(), byteBuf);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void encodeChunkedContent(ChannelHandlerContext channelHandlerContext, Object object, long l2, List<Object> list) {
        ByteBuf byteBuf;
        Object object2;
        if (l2 > 0L) {
            object2 = Long.toHexString(l2);
            byteBuf = channelHandlerContext.alloc().buffer(((String)object2).length() + 2);
            byteBuf.writeCharSequence((CharSequence)object2, CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE(byteBuf, 3338);
            list.add(byteBuf);
            list.add(HttpObjectEncoder.encodeAndRetain(object));
            list.add(CRLF_BUF.duplicate());
        }
        if (!(object instanceof LastHttpContent)) {
            if (l2 != 0L) return;
            list.add(HttpObjectEncoder.encodeAndRetain(object));
            return;
        }
        object2 = ((LastHttpContent)object).trailingHeaders();
        if (((HttpHeaders)object2).isEmpty()) {
            list.add(ZERO_CRLF_CRLF_BUF.duplicate());
            return;
        }
        byteBuf = channelHandlerContext.alloc().buffer((int)this.trailersEncodedSizeAccumulator);
        ByteBufUtil.writeMediumBE(byteBuf, 3149066);
        this.encodeHeaders((HttpHeaders)object2, byteBuf);
        ByteBufUtil.writeShortBE(byteBuf, 3338);
        this.trailersEncodedSizeAccumulator = 0.2f * (float)HttpObjectEncoder.padSizeForAccumulation(byteBuf.readableBytes()) + 0.8f * this.trailersEncodedSizeAccumulator;
        list.add(byteBuf);
    }

    protected void sanitizeHeadersBeforeEncode(H h2, boolean bl) {
    }

    protected boolean isContentAlwaysEmpty(H h2) {
        return false;
    }

    @Override
    public boolean acceptOutboundMessage(Object object) throws Exception {
        return object instanceof HttpObject || object instanceof ByteBuf || object instanceof FileRegion;
    }

    private static Object encodeAndRetain(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).retain();
        }
        if (object instanceof HttpContent) {
            return ((HttpContent)object).content().retain();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).retain();
        }
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(object));
    }

    private static long contentLength(Object object) {
        if (object instanceof HttpContent) {
            return ((HttpContent)object).content().readableBytes();
        }
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        throw new IllegalStateException("unexpected message type: " + StringUtil.simpleClassName(object));
    }

    private static int padSizeForAccumulation(int n2) {
        return (n2 << 2) / 3;
    }

    protected abstract void encodeInitialLine(ByteBuf var1, H var2) throws Exception;
}

