/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.handler.codec.CharSequenceValueConverter;
import com.appoptics.ext.io.netty.handler.codec.DateFormatter;
import com.appoptics.ext.io.netty.handler.codec.DefaultHeaders;
import com.appoptics.ext.io.netty.handler.codec.DefaultHeadersImpl;
import com.appoptics.ext.io.netty.handler.codec.HeadersUtils;
import com.appoptics.ext.io.netty.handler.codec.ValueConverter;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpHeaders
extends HttpHeaders {
    private static final ByteProcessor HEADER_NAME_VALIDATOR = new ByteProcessor(){

        public final boolean process(byte by) throws Exception {
            DefaultHttpHeaders.validateHeaderNameElement(by);
            return true;
        }
    };
    static final DefaultHeaders.NameValidator<CharSequence> HttpNameValidator = new DefaultHeaders.NameValidator<CharSequence>(){

        @Override
        public final void validateName(CharSequence charSequence) {
            if (charSequence == null || charSequence.length() == 0) {
                throw new IllegalArgumentException("empty headers are not allowed [" + charSequence + "]");
            }
            if (charSequence instanceof AsciiString) {
                try {
                    ((AsciiString)charSequence).forEachByte(HEADER_NAME_VALIDATOR);
                    return;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    PlatformDependent.throwException(exception);
                    return;
                }
            }
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                DefaultHttpHeaders.validateHeaderNameElement(charSequence.charAt(i2));
            }
        }
    };
    private final DefaultHeaders<CharSequence, CharSequence, ?> headers;

    public DefaultHttpHeaders() {
        this(true);
    }

    public DefaultHttpHeaders(boolean bl) {
        boolean bl2 = bl;
        this(bl2, DefaultHttpHeaders.nameValidator(bl2));
    }

    protected DefaultHttpHeaders(boolean bl, DefaultHeaders.NameValidator<CharSequence> nameValidator) {
        this(new DefaultHeadersImpl<CharSequence, CharSequence>(AsciiString.CASE_INSENSITIVE_HASHER, DefaultHttpHeaders.valueConverter(bl), nameValidator));
    }

    protected DefaultHttpHeaders(DefaultHeaders<CharSequence, CharSequence, ?> defaultHeaders) {
        this.headers = defaultHeaders;
    }

    @Override
    public HttpHeaders add(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.add(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.add(httpHeaders);
    }

    @Override
    public HttpHeaders set(HttpHeaders httpHeaders) {
        if (httpHeaders instanceof DefaultHttpHeaders) {
            this.headers.set(((DefaultHttpHeaders)httpHeaders).headers);
            return this;
        }
        return super.set(httpHeaders);
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        this.headers.addObject(string, object);
        return this;
    }

    @Override
    public HttpHeaders add(CharSequence charSequence, Object object) {
        this.headers.addObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders remove(String string) {
        this.headers.remove(string);
        return this;
    }

    @Override
    public HttpHeaders remove(CharSequence charSequence) {
        this.headers.remove(charSequence);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        this.headers.setObject((CharSequence)string, object);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Object object) {
        this.headers.setObject(charSequence, object);
        return this;
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        this.headers.setObject((CharSequence)string, iterable);
        return this;
    }

    @Override
    public HttpHeaders set(CharSequence charSequence, Iterable<?> iterable) {
        this.headers.setObject(charSequence, iterable);
        return this;
    }

    @Override
    public HttpHeaders setInt(CharSequence charSequence, int n2) {
        this.headers.setInt(charSequence, n2);
        return this;
    }

    @Override
    public HttpHeaders clear() {
        this.headers.clear();
        return this;
    }

    @Override
    public String get(String string) {
        return this.get((CharSequence)string);
    }

    @Override
    public String get(CharSequence charSequence) {
        return HeadersUtils.getAsString(this.headers, charSequence);
    }

    @Override
    public int getInt(CharSequence charSequence, int n2) {
        return this.headers.getInt(charSequence, n2);
    }

    @Override
    public List<String> getAll(String string) {
        return this.getAll((CharSequence)string);
    }

    @Override
    public List<String> getAll(CharSequence charSequence) {
        return HeadersUtils.getAllAsString(this.headers, charSequence);
    }

    @Override
    @Deprecated
    public Iterator<Map.Entry<String, String>> iterator() {
        return HeadersUtils.iteratorAsString(this.headers);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return this.headers.iterator();
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence object) {
        object = this.valueCharSequenceIterator((CharSequence)object);
        return new Iterator<String>((Iterator)object){
            final /* synthetic */ Iterator val$itr;
            {
                this.val$itr = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$itr.hasNext();
            }

            @Override
            public String next() {
                return ((CharSequence)this.val$itr.next()).toString();
            }

            @Override
            public void remove() {
                this.val$itr.remove();
            }
        };
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return this.headers.valueIterator(charSequence);
    }

    @Override
    public boolean contains(String string) {
        return this.contains((CharSequence)string);
    }

    @Override
    public boolean contains(CharSequence charSequence) {
        return this.headers.contains(charSequence);
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean contains(String string, String string2, boolean bl) {
        return this.contains((CharSequence)string, (CharSequence)string2, bl);
    }

    @Override
    public boolean contains(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return this.headers.contains(charSequence, charSequence2, bl ? AsciiString.CASE_INSENSITIVE_HASHER : AsciiString.CASE_SENSITIVE_HASHER);
    }

    public boolean equals(Object object) {
        return object instanceof DefaultHttpHeaders && this.headers.equals(((DefaultHttpHeaders)object).headers, AsciiString.CASE_SENSITIVE_HASHER);
    }

    public int hashCode() {
        return this.headers.hashCode(AsciiString.CASE_SENSITIVE_HASHER);
    }

    @Override
    public HttpHeaders copy() {
        return new DefaultHttpHeaders(this.headers.copy());
    }

    private static void validateHeaderNameElement(byte by) {
        switch (by) {
            case 0: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 32: 
            case 44: 
            case 58: 
            case 59: 
            case 61: {
                throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + by);
            }
        }
        if (by < 0) {
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + by);
        }
    }

    private static void validateHeaderNameElement(char c2) {
        switch (c2) {
            case '\u0000': 
            case '\t': 
            case '\n': 
            case '\u000b': 
            case '\f': 
            case '\r': 
            case ' ': 
            case ',': 
            case ':': 
            case ';': 
            case '=': {
                throw new IllegalArgumentException("a header name cannot contain the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + c2);
            }
        }
        if (c2 > '\u007f') {
            throw new IllegalArgumentException("a header name cannot contain non-ASCII character: " + c2);
        }
    }

    static ValueConverter<CharSequence> valueConverter(boolean bl) {
        if (bl) {
            return HeaderValueConverterAndValidator.INSTANCE;
        }
        return HeaderValueConverter.INSTANCE;
    }

    static DefaultHeaders.NameValidator<CharSequence> nameValidator(boolean bl) {
        if (bl) {
            return HttpNameValidator;
        }
        return DefaultHeaders.NameValidator.NOT_NULL;
    }

    private static final class HeaderValueConverterAndValidator
    extends HeaderValueConverter {
        static final HeaderValueConverterAndValidator INSTANCE = new HeaderValueConverterAndValidator();

        private HeaderValueConverterAndValidator() {
        }

        public final CharSequence convertObject(Object object) {
            object = super.convertObject(object);
            int n2 = 0;
            for (int i2 = 0; i2 < object.length(); ++i2) {
                n2 = HeaderValueConverterAndValidator.validateValueChar((CharSequence)object, n2, object.charAt(i2));
            }
            if (n2 != 0) {
                throw new IllegalArgumentException("a header value must not end with '\\r' or '\\n':" + object);
            }
            return object;
        }

        private static int validateValueChar(CharSequence charSequence, int n2, char c2) {
            if ((c2 & 0xFFFFFFF0) == 0) {
                switch (c2) {
                    case '\u0000': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\u0000': " + charSequence);
                    }
                    case '\u000b': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\\v': " + charSequence);
                    }
                    case '\f': {
                        throw new IllegalArgumentException("a header value contains a prohibited character '\\f': " + charSequence);
                    }
                }
            }
            switch (n2) {
                case 0: {
                    switch (c2) {
                        case '\r': {
                            return 1;
                        }
                        case '\n': {
                            return 2;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c2) {
                        case '\n': {
                            return 2;
                        }
                    }
                    throw new IllegalArgumentException("only '\\n' is allowed after '\\r': " + charSequence);
                }
                case 2: {
                    switch (c2) {
                        case '\t': 
                        case ' ': {
                            return 0;
                        }
                    }
                    throw new IllegalArgumentException("only ' ' and '\\t' are allowed after '\\n': " + charSequence);
                }
            }
            return n2;
        }
    }

    private static class HeaderValueConverter
    extends CharSequenceValueConverter {
        static final HeaderValueConverter INSTANCE = new HeaderValueConverter();

        private HeaderValueConverter() {
        }

        public CharSequence convertObject(Object object) {
            if (object instanceof CharSequence) {
                return (CharSequence)object;
            }
            if (object instanceof Date) {
                return DateFormatter.format((Date)object);
            }
            if (object instanceof Calendar) {
                return DateFormatter.format(((Calendar)object).getTime());
            }
            return object.toString();
        }
    }
}

