/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec.http;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.handler.codec.http.CombinedHttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.DefaultHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.FullHttpResponse;
import com.appoptics.ext.io.netty.handler.codec.http.HttpHeaders;
import com.appoptics.ext.io.netty.handler.codec.http.HttpMessageUtil;
import com.appoptics.ext.io.netty.handler.codec.http.HttpResponseStatus;
import com.appoptics.ext.io.netty.handler.codec.http.HttpVersion;
import com.appoptics.ext.io.netty.util.IllegalReferenceCountException;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpResponse
extends DefaultHttpResponse
implements FullHttpResponse {
    private final ByteBuf content;
    private final HttpHeaders trailingHeaders;
    private int hash;

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf) {
        this(httpVersion, httpResponseStatus, byteBuf, true);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, boolean bl) {
        this(httpVersion, httpResponseStatus, Unpooled.buffer(0), bl, false);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, boolean bl) {
        this(httpVersion, httpResponseStatus, byteBuf, bl, false);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, boolean bl, boolean bl2) {
        super(httpVersion, httpResponseStatus, bl, bl2);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeaders = bl2 ? new CombinedHttpHeaders(bl) : new DefaultHttpHeaders(bl);
    }

    public DefaultFullHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2) {
        super(httpVersion, httpResponseStatus, httpHeaders);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeaders = ObjectUtil.checkNotNull(httpHeaders2, "trailingHeaders");
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public FullHttpResponse retain() {
        this.content.retain();
        return this;
    }

    public FullHttpResponse touch() {
        this.content.touch();
        return this;
    }

    public FullHttpResponse touch(Object object) {
        this.content.touch(object);
        return this;
    }

    public boolean release() {
        return this.content.release();
    }

    public FullHttpResponse retainedDuplicate() {
        DefaultFullHttpResponse defaultFullHttpResponse = this;
        return defaultFullHttpResponse.replace(defaultFullHttpResponse.content().retainedDuplicate());
    }

    public FullHttpResponse replace(ByteBuf referenceCounted) {
        referenceCounted = new DefaultFullHttpResponse(this.protocolVersion(), this.status(), (ByteBuf)referenceCounted, this.headers().copy(), this.trailingHeaders().copy());
        referenceCounted.setDecoderResult(this.decoderResult());
        return referenceCounted;
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            if (this.content().refCnt() != 0) {
                try {
                    n2 = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {}
            }
            n2 = 31;
            n2 = n2 * 31 + this.trailingHeaders().hashCode();
            this.hash = n2 = n2 * 31 + super.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpResponse)) {
            return false;
        }
        return super.equals(object = (DefaultFullHttpResponse)object) && this.content().equals(((DefaultFullHttpResponse)object).content()) && this.trailingHeaders().equals(((DefaultFullHttpResponse)object).trailingHeaders());
    }

    public String toString() {
        return HttpMessageUtil.appendFullResponse(new StringBuilder(256), this).toString();
    }
}

