/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.handler.codec;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufHolder;
import com.appoptics.ext.io.netty.buffer.CompositeByteBuf;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.handler.codec.DecoderResult;
import com.appoptics.ext.io.netty.handler.codec.DecoderResultProvider;
import com.appoptics.ext.io.netty.handler.codec.MessageAggregationException;
import com.appoptics.ext.io.netty.handler.codec.MessageToMessageDecoder;
import com.appoptics.ext.io.netty.handler.codec.TooLongFrameException;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.concurrent.Future;
import com.appoptics.ext.io.netty.util.concurrent.GenericFutureListener;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;
    private boolean aggregating;

    protected MessageAggregator(int n2) {
        MessageAggregator.validateMaxContentLength(n2);
        this.maxContentLength = n2;
    }

    private static void validateMaxContentLength(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "maxContentLength");
    }

    @Override
    public boolean acceptInboundMessage(Object object) throws Exception {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        if (this.isAggregated(object)) {
            return false;
        }
        if (this.isStartMessage(object)) {
            this.aggregating = true;
            return true;
        }
        return this.aggregating && this.isContentMessage(object);
    }

    protected abstract boolean isStartMessage(I var1) throws Exception;

    protected abstract boolean isContentMessage(I var1) throws Exception;

    protected abstract boolean isLastContentMessage(C var1) throws Exception;

    protected abstract boolean isAggregated(I var1) throws Exception;

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    @Override
    protected void decode(final ChannelHandlerContext channelHandlerContext, I object, List<Object> list) throws Exception {
        assert (this.aggregating);
        if (this.isStartMessage(object)) {
            Object object2;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            Object object3 = object;
            if ((object = this.newContinueResponse(object3, this.maxContentLength, channelHandlerContext.pipeline())) != null) {
                object2 = this.continueResponseWriteListener;
                if (object2 == null) {
                    object2 = new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (!channelFuture.isSuccess()) {
                                channelHandlerContext.fireExceptionCaught(channelFuture.cause());
                            }
                        }
                    };
                    this.continueResponseWriteListener = object2;
                }
                boolean bl = this.closeAfterContinueResponse(object);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(object);
                object = channelHandlerContext.writeAndFlush(object).addListener((GenericFutureListener<? extends Future<? super Void>>)object2);
                if (bl) {
                    object.addListener(ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(object3, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(channelHandlerContext, object3);
                return;
            }
            if (object3 instanceof DecoderResultProvider && !((DecoderResultProvider)object3).decoderResult().isSuccess()) {
                if (object3 instanceof ByteBufHolder) {
                    I i2 = object3;
                    object2 = this.beginAggregation(i2, ((ByteBufHolder)i2).content().retain());
                } else {
                    object2 = this.beginAggregation(object3, Unpooled.EMPTY_BUFFER);
                }
                this.finishAggregation0(object2);
                list.add(object2);
                return;
            }
            object2 = channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (object3 instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent((CompositeByteBuf)object2, ((ByteBufHolder)object3).content());
            }
            this.currentMessage = this.beginAggregation(object3, (ByteBuf)object2);
            return;
        }
        if (this.isContentMessage(object)) {
            boolean bl;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.currentMessage.content();
            object = (ByteBufHolder)object;
            if (compositeByteBuf.readableBytes() > this.maxContentLength - object.content().readableBytes()) {
                O o2 = this.currentMessage;
                this.invokeHandleOversizedMessage(channelHandlerContext, o2);
                return;
            }
            MessageAggregator.appendPartialContent(compositeByteBuf, object.content());
            MessageAggregator messageAggregator = this;
            messageAggregator.aggregate(messageAggregator.currentMessage, object);
            if (object instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)object).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    bl = true;
                } else {
                    bl = this.isLastContentMessage(object);
                }
            } else {
                bl = this.isLastContentMessage(object);
            }
            if (bl) {
                MessageAggregator messageAggregator2 = this;
                messageAggregator2.finishAggregation0(messageAggregator2.currentMessage);
                list.add(this.currentMessage);
                this.currentMessage = null;
            }
            return;
        }
        throw new MessageAggregationException();
    }

    private static void appendPartialContent(CompositeByteBuf compositeByteBuf, ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            compositeByteBuf.addComponent(true, byteBuf.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2) throws Exception;

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3) throws Exception;

    protected abstract boolean closeAfterContinueResponse(Object var1) throws Exception;

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1) throws Exception;

    protected abstract O beginAggregation(S var1, ByteBuf var2) throws Exception;

    protected void aggregate(O o2, C c2) throws Exception {
    }

    private void finishAggregation0(O o2) throws Exception {
        this.aggregating = false;
        this.finishAggregation(o2);
    }

    protected void finishAggregation(O o2) throws Exception {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s2) throws Exception {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        try {
            this.handleOversizedMessage(channelHandlerContext, s2);
            return;
        }
        finally {
            ReferenceCountUtil.release(s2);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s2) throws Exception {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.currentMessage != null && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            super.channelInactive(channelHandlerContext);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            super.handlerRemoved(channelHandlerContext);
            return;
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
            this.aggregating = false;
        }
    }
}

