/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel.nio;

import com.appoptics.ext.io.netty.channel.ChannelException;
import com.appoptics.ext.io.netty.channel.EventLoopGroup;
import com.appoptics.ext.io.netty.channel.EventLoopTaskQueueFactory;
import com.appoptics.ext.io.netty.channel.SelectStrategy;
import com.appoptics.ext.io.netty.channel.SingleThreadEventLoop;
import com.appoptics.ext.io.netty.channel.nio.AbstractNioChannel;
import com.appoptics.ext.io.netty.channel.nio.NioEventLoopGroup;
import com.appoptics.ext.io.netty.channel.nio.NioTask;
import com.appoptics.ext.io.netty.channel.nio.SelectedSelectionKeySet;
import com.appoptics.ext.io.netty.channel.nio.SelectedSelectionKeySetSelector;
import com.appoptics.ext.io.netty.util.IntSupplier;
import com.appoptics.ext.io.netty.util.concurrent.RejectedExecutionHandler;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.ReflectionUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final boolean DISABLE_KEY_SET_OPTIMIZATION;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        public int get() throws Exception {
            return NioEventLoop.this.selectNow();
        }
    };
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private final AtomicLong nextWakeupNanos = new AtomicLong(-1L);
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    NioEventLoop(NioEventLoopGroup object, Executor executor, SelectorProvider selectorProvider, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        super((EventLoopGroup)object, executor, false, NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory), NioEventLoop.newTaskQueue(eventLoopTaskQueueFactory), rejectedExecutionHandler);
        this.provider = ObjectUtil.checkNotNull(selectorProvider, "selectorProvider");
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "selectStrategy");
        object = this.openSelector();
        this.selector = ((SelectorTuple)object).selector;
        this.unwrappedSelector = ((SelectorTuple)object).unwrappedSelector;
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory eventLoopTaskQueueFactory) {
        if (eventLoopTaskQueueFactory == null) {
            return NioEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return eventLoopTaskQueueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    private SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEY_SET_OPTIMIZATION) {
            return new SelectorTuple(abstractSelector);
        }
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return Class.forName("sun.nio.ch.SelectorImpl", false, PlatformDependent.getSystemClassLoader());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    return throwable;
                }
            }
        });
        if (!(object instanceof Class) || !((Class)object).isAssignableFrom(abstractSelector.getClass())) {
            if (object instanceof Throwable) {
                object = (Throwable)object;
                logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, object);
            }
            return new SelectorTuple(abstractSelector);
        }
        object = (Class)object;
        SelectedSelectionKeySet selectedSelectionKeySet = new SelectedSelectionKeySet();
        if ((object = AccessController.doPrivileged(new PrivilegedAction<Object>((Class)object, (Selector)abstractSelector, selectedSelectionKeySet){
            final /* synthetic */ Class val$selectorImplClass;
            final /* synthetic */ Selector val$unwrappedSelector;
            final /* synthetic */ SelectedSelectionKeySet val$selectedKeySet;
            {
                this.val$selectorImplClass = clazz;
                this.val$unwrappedSelector = selector;
                this.val$selectedKeySet = selectedSelectionKeySet;
            }

            @Override
            public Object run() {
                try {
                    Throwable throwable;
                    Field field = this.val$selectorImplClass.getDeclaredField("selectedKeys");
                    Field field2 = this.val$selectorImplClass.getDeclaredField("publicSelectedKeys");
                    if (PlatformDependent.javaVersion() >= 9 && PlatformDependent.hasUnsafe()) {
                        long l2 = PlatformDependent.objectFieldOffset(field);
                        long l3 = PlatformDependent.objectFieldOffset(field2);
                        if (l2 != -1L && l3 != -1L) {
                            PlatformDependent.putObject(this.val$unwrappedSelector, l2, this.val$selectedKeySet);
                            PlatformDependent.putObject(this.val$unwrappedSelector, l3, this.val$selectedKeySet);
                            return null;
                        }
                    }
                    if ((throwable = ReflectionUtil.trySetAccessible(field, true)) != null) {
                        return throwable;
                    }
                    throwable = ReflectionUtil.trySetAccessible(field2, true);
                    if (throwable != null) {
                        return throwable;
                    }
                    field.set(this.val$unwrappedSelector, this.val$selectedKeySet);
                    field2.set(this.val$unwrappedSelector, this.val$selectedKeySet);
                    return null;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
                    return noSuchFieldException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    IllegalAccessException illegalAccessException2 = illegalAccessException;
                    return illegalAccessException;
                }
            }
        })) instanceof Exception) {
            this.selectedKeys = null;
            object = (Exception)object;
            logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, object);
            return new SelectorTuple(abstractSelector);
        }
        this.selectedKeys = selectedSelectionKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", (Object)abstractSelector);
        return new SelectorTuple(abstractSelector, new SelectedSelectionKeySetSelector(abstractSelector, selectedSelectionKeySet));
    }

    private static Queue<Runnable> newTaskQueue0(int n2) {
        if (n2 == Integer.MAX_VALUE) {
            return PlatformDependent.newMpscQueue();
        }
        return PlatformDependent.newMpscQueue(n2);
    }

    public final void rebuildSelector() {
        if (!this.inEventLoop()) {
            this.execute(new Runnable(){

                public void run() {
                    NioEventLoop.this.rebuildSelector0();
                }
            });
            return;
        }
        this.rebuildSelector0();
    }

    private void rebuildSelector0() {
        int n2;
        block11: {
            SelectorTuple selectorTuple;
            Selector selector = this.selector;
            if (selector == null) {
                return;
            }
            try {
                selectorTuple = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n2 = 0;
            for (SelectionKey selectionKey : selector.keys()) {
                Object object;
                Object object2 = selectionKey.attachment();
                try {
                    if (!selectionKey.isValid() || selectionKey.channel().keyFor(selectorTuple.unwrappedSelector) != null) continue;
                    int n3 = selectionKey.interestOps();
                    selectionKey.cancel();
                    object = selectionKey.channel().register(selectorTuple.unwrappedSelector, n3, object2);
                    if (object2 instanceof AbstractNioChannel) {
                        ((AbstractNioChannel)object2).selectionKey = object;
                    }
                    ++n2;
                }
                catch (Exception exception) {
                    logger.warn("Failed to re-register a Channel to the new Selector.", exception);
                    if (object2 instanceof AbstractNioChannel) {
                        object = (AbstractNioChannel)object2;
                        ((AbstractNioChannel)object).unsafe().close(((AbstractNioChannel)object).unsafe().voidPromise());
                        continue;
                    }
                    object = (NioTask)object2;
                    NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object, selectionKey, exception);
                }
            }
            this.selector = selectorTuple.selector;
            this.unwrappedSelector = selectorTuple.unwrappedSelector;
            try {
                selector.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Migrated " + n2 + " channel(s) to the new Selector.");
        }
    }

    @Override
    protected final void run() {
        int n2 = 0;
        while (true) {
            try {
                boolean bl;
                int n3;
                block29: {
                    block30: {
                        int n4;
                        block28: {
                            block27: {
                                block19: while (true) {
                                    try {
                                        block20: while (true) {
                                            n3 = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                                            switch (n3) {
                                                case -2: {
                                                    continue block20;
                                                }
                                                case -3: 
                                                case -1: {
                                                    long l2 = this.nextScheduledTaskDeadlineNanos();
                                                    if (l2 == -1L) {
                                                        l2 = Long.MAX_VALUE;
                                                    }
                                                    this.nextWakeupNanos.set(l2);
                                                    try {
                                                        if (this.hasTasks()) break block19;
                                                        n3 = this.select(l2);
                                                        break block19;
                                                    }
                                                    finally {
                                                        this.nextWakeupNanos.lazySet(-1L);
                                                    }
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    catch (IOException iOException) {
                                        this.rebuildSelector0();
                                        n2 = 0;
                                        NioEventLoop.handleLoopException(iOException);
                                        continue;
                                    }
                                    break;
                                }
                                ++n2;
                                this.cancelledKeys = 0;
                                this.needsToSelectAgain = false;
                                n4 = this.ioRatio;
                                if (n4 != 100) break block28;
                                try {
                                    if (n3 <= 0) break block27;
                                    this.processSelectedKeys();
                                }
                                catch (Throwable throwable) {
                                    this.runAllTasks();
                                    throw throwable;
                                }
                            }
                            bl = this.runAllTasks();
                            break block29;
                        }
                        if (n3 <= 0) break block30;
                        long l3 = System.nanoTime();
                        try {
                            this.processSelectedKeys();
                        }
                        catch (Throwable throwable) {
                            long l4 = System.nanoTime() - l3;
                            this.runAllTasks(l4 * (long)(100 - n4) / (long)n4);
                            throw throwable;
                        }
                        long l5 = System.nanoTime() - l3;
                        bl = this.runAllTasks(l5 * (long)(100 - n4) / (long)n4);
                        break block29;
                    }
                    bl = this.runAllTasks(0L);
                }
                if (bl || n3 > 0) {
                    if (n2 > 3 && logger.isDebugEnabled()) {
                        logger.debug("Selector.select() returned prematurely {} times in a row for Selector {}.", (Object)(n2 - 1), (Object)this.selector);
                    }
                    n2 = 0;
                } else if (this.unexpectedSelectorWakeup(n2)) {
                    n2 = 0;
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (logger.isDebugEnabled()) {
                    logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector {} - JDK bug?", (Object)this.selector, (Object)cancelledKeyException);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                NioEventLoop.handleLoopException(throwable);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable3 = throwable;
                NioEventLoop.handleLoopException(throwable);
                continue;
            }
            break;
        }
    }

    private boolean unexpectedSelectorWakeup(int n2) {
        if (Thread.interrupted()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
            }
            return true;
        }
        if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n2 >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
            logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n2, (Object)this.selector);
            this.rebuildSelector();
            return true;
        }
        return false;
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            this.processSelectedKeysOptimized();
            return;
        }
        NioEventLoop nioEventLoop = this;
        nioEventLoop.processSelectedKeysPlain(nioEventLoop.selector.selectedKeys());
    }

    @Override
    protected final void cleanup() {
        try {
            this.selector.close();
            return;
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
            return;
        }
    }

    final void cancel(SelectionKey selectionKey) {
        selectionKey.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    private void processSelectedKeysPlain(Set<SelectionKey> object) {
        if (object.isEmpty()) {
            return;
        }
        object = object.iterator();
        while (true) {
            SelectionKey selectionKey = (SelectionKey)object.next();
            Object object2 = selectionKey.attachment();
            object.remove();
            if (object2 instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object2);
            } else {
                object2 = (NioTask)object2;
                NioEventLoop.processSelectedKey(selectionKey, (NioTask<SelectableChannel>)object2);
            }
            if (!object.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            object = this.selector.selectedKeys();
            if (object.isEmpty()) break;
            object = object.iterator();
        }
    }

    private void processSelectedKeysOptimized() {
        for (int i2 = 0; i2 < this.selectedKeys.size; ++i2) {
            SelectionKey selectionKey = this.selectedKeys.keys[i2];
            this.selectedKeys.keys[i2] = null;
            Object object = selectionKey.attachment();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                object = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, (NioTask<SelectableChannel>)object);
            }
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i2 + 1);
            this.selectAgain();
            i2 = -1;
        }
    }

    private void processSelectedKey(SelectionKey selectionKey, AbstractNioChannel abstractNioChannel) {
        AbstractNioChannel.NioUnsafe nioUnsafe = abstractNioChannel.unsafe();
        if (!selectionKey.isValid()) {
            NioEventLoop nioEventLoop;
            try {
                nioEventLoop = abstractNioChannel.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (nioEventLoop == this) {
                AbstractNioChannel.NioUnsafe nioUnsafe2 = nioUnsafe;
                nioUnsafe2.close(nioUnsafe2.voidPromise());
            }
            return;
        }
        try {
            int n2 = selectionKey.readyOps();
            if ((n2 & 8) != 0) {
                int n3 = selectionKey.interestOps();
                selectionKey.interestOps(n3 &= 0xFFFFFFF7);
                nioUnsafe.finishConnect();
            }
            if ((n2 & 4) != 0) {
                abstractNioChannel.unsafe().forceFlush();
            }
            if ((n2 & 0x11) != 0 || n2 == 0) {
                nioUnsafe.read();
            }
            return;
        }
        catch (CancelledKeyException cancelledKeyException) {
            AbstractNioChannel.NioUnsafe nioUnsafe3 = nioUnsafe;
            nioUnsafe3.close(nioUnsafe3.voidPromise());
            return;
        }
    }

    private static void processSelectedKey(SelectionKey selectionKey, NioTask<SelectableChannel> nioTask) {
        block4: {
            try {
                nioTask.channelReady(selectionKey.channel(), selectionKey);
                if (selectionKey.isValid()) break block4;
            }
            catch (Exception exception) {
                try {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, exception);
                    return;
                }
                catch (Throwable throwable) {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                    throw throwable;
                }
            }
            NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
        }
        return;
    }

    private void closeAll() {
        this.selectAgain();
        Iterator iterator = this.selector.keys();
        ArrayList<AbstractNioChannel> arrayList = new ArrayList<AbstractNioChannel>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            SelectionKey object = (SelectionKey)iterator.next();
            Object object2 = object.attachment();
            if (object2 instanceof AbstractNioChannel) {
                arrayList.add((AbstractNioChannel)object2);
                continue;
            }
            object.cancel();
            object2 = (NioTask)object2;
            NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object2, object, null);
        }
        for (AbstractNioChannel abstractNioChannel : arrayList) {
            abstractNioChannel.unsafe().close(abstractNioChannel.unsafe().voidPromise());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> nioTask, SelectionKey selectionKey, Throwable throwable) {
        try {
            nioTask.channelUnregistered(selectionKey.channel(), throwable);
            return;
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", exception);
            return;
        }
    }

    @Override
    protected final void wakeup(boolean bl) {
        if (!bl && this.nextWakeupNanos.getAndSet(-1L) != -1L) {
            this.selector.wakeup();
        }
    }

    @Override
    protected final boolean beforeScheduledTaskSubmitted(long l2) {
        return l2 < this.nextWakeupNanos.get();
    }

    @Override
    protected final boolean afterScheduledTaskSubmitted(long l2) {
        return l2 < this.nextWakeupNanos.get();
    }

    final Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    final int selectNow() throws IOException {
        return this.selector.selectNow();
    }

    private int select(long l2) throws IOException {
        if (l2 == Long.MAX_VALUE) {
            return this.selector.select();
        }
        long l3 = NioEventLoop.deadlineToDelayNanos(l2 + 995000L) / 1000000L;
        if (l3 <= 0L) {
            return this.selector.selectNow();
        }
        return this.selector.select(l3);
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
            return;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
            return;
        }
    }

    static {
        int n2;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEY_SET_OPTIMIZATION = SystemPropertyUtil.getBoolean("com.appoptics.ext.io.netty.noKeySetOptimization", false);
        String string = SystemPropertyUtil.get("sun.nio.ch.bugLevel");
        if (string == null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public final Void run() {
                        System.setProperty("sun.nio.ch.bugLevel", "");
                        return null;
                    }
                });
            }
            catch (SecurityException securityException) {
                logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", securityException);
            }
        }
        if ((n2 = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.selectorAutoRebuildThreshold", 512)) < 3) {
            n2 = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n2;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEY_SET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }

    private static final class SelectorTuple {
        final Selector unwrappedSelector;
        final Selector selector;

        SelectorTuple(Selector selector) {
            this.unwrappedSelector = selector;
            this.selector = selector;
        }

        SelectorTuple(Selector selector, Selector selector2) {
            this.unwrappedSelector = selector;
            this.selector = selector2;
        }
    }
}

