/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.PendingBytesTracker;
import com.appoptics.ext.io.netty.channel.VoidChannelPromise;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.concurrent.PromiseCombiner;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelHandlerContext ctx;
    private final PendingBytesTracker tracker;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        this.tracker = PendingBytesTracker.newTracker(channelHandlerContext.channel());
        this.ctx = channelHandlerContext;
    }

    public final boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    private int size(Object object) {
        int n2 = this.tracker.size(object);
        if (n2 < 0) {
            n2 = 0;
        }
        return n2 + PENDING_WRITE_OVERHEAD;
    }

    public final void add(Object object, ChannelPromise object2) {
        assert (this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull(object, "msg");
        ObjectUtil.checkNotNull(object2, "promise");
        int n2 = this.size(object);
        object = PendingWrite.newInstance(object, n2, (ChannelPromise)object2);
        object2 = this.tail;
        if (object2 == null) {
            PendingWriteQueue pendingWriteQueue = this;
            pendingWriteQueue.tail = pendingWriteQueue.head = object;
        } else {
            ((PendingWrite)object2).next = (PendingWrite)object;
            this.tail = object;
        }
        ++this.size;
        this.bytes += (long)n2;
        this.tracker.incrementPendingOutboundBytes(((PendingWrite)object).size);
    }

    public final ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise channelPromise = this.ctx.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner(this.ctx.executor());
        try {
            PendingWrite pendingWrite = this.head;
            while (pendingWrite != null) {
                PendingWriteQueue pendingWriteQueue = this;
                pendingWriteQueue.tail = null;
                pendingWriteQueue.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (pendingWrite != null) {
                    PendingWrite pendingWrite2 = pendingWrite.next;
                    Object object = pendingWrite.msg;
                    ChannelPromise channelPromise2 = pendingWrite.promise;
                    this.recycle(pendingWrite, false);
                    if (!(channelPromise2 instanceof VoidChannelPromise)) {
                        promiseCombiner.add(channelPromise2);
                    }
                    this.ctx.write(object, channelPromise2);
                    pendingWrite = pendingWrite2;
                }
                pendingWrite = this.head;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        this.assertEmpty();
        return channelPromise;
    }

    public final void removeAndFailAll(Throwable throwable) {
        assert (this.ctx.executor().inEventLoop());
        ObjectUtil.checkNotNull(throwable, "cause");
        PendingWrite pendingWrite = this.head;
        while (pendingWrite != null) {
            PendingWriteQueue pendingWriteQueue = this;
            pendingWriteQueue.tail = null;
            pendingWriteQueue.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWrite != null) {
                PendingWrite pendingWrite2 = pendingWrite.next;
                ReferenceCountUtil.safeRelease(pendingWrite.msg);
                ChannelPromise channelPromise = pendingWrite.promise;
                this.recycle(pendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWrite = pendingWrite2;
            }
            pendingWrite = this.head;
        }
        this.assertEmpty();
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    private void recycle(PendingWrite pendingWrite, boolean bl) {
        PendingWrite pendingWrite2 = pendingWrite.next;
        long l2 = pendingWrite.size;
        if (bl) {
            if (pendingWrite2 == null) {
                PendingWriteQueue pendingWriteQueue = this;
                pendingWriteQueue.tail = null;
                pendingWriteQueue.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWrite2;
                --this.size;
                this.bytes -= l2;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        pendingWrite.recycle();
        this.tracker.decrementPendingOutboundBytes(l2);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PendingWrite {
        private static final ObjectPool<PendingWrite> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PendingWrite>(){

            @Override
            public final PendingWrite newObject(ObjectPool.Handle<PendingWrite> handle) {
                return new PendingWrite(handle);
            }
        });
        private final ObjectPool.Handle<PendingWrite> handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(ObjectPool.Handle<PendingWrite> handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object object, int n2, ChannelPromise channelPromise) {
            PendingWrite pendingWrite = RECYCLER.get();
            RECYCLER.get().size = n2;
            pendingWrite.msg = object;
            pendingWrite.promise = channelPromise;
            return pendingWrite;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            this.handle.recycle(this);
        }
    }
}

