/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.DefaultChannelPipeline;
import com.appoptics.ext.io.netty.channel.MessageSizeEstimator;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

abstract class PendingBytesTracker
implements MessageSizeEstimator.Handle {
    private final MessageSizeEstimator.Handle estimatorHandle;

    private PendingBytesTracker(MessageSizeEstimator.Handle handle) {
        this.estimatorHandle = ObjectUtil.checkNotNull(handle, "estimatorHandle");
    }

    public final int size(Object object) {
        return this.estimatorHandle.size(object);
    }

    public abstract void incrementPendingOutboundBytes(long var1);

    public abstract void decrementPendingOutboundBytes(long var1);

    static PendingBytesTracker newTracker(Channel object) {
        if (object.pipeline() instanceof DefaultChannelPipeline) {
            return new DefaultChannelPipelinePendingBytesTracker((DefaultChannelPipeline)object.pipeline());
        }
        ChannelOutboundBuffer channelOutboundBuffer = object.unsafe().outboundBuffer();
        object = object.config().getMessageSizeEstimator().newHandle();
        if (channelOutboundBuffer == null) {
            return new NoopPendingBytesTracker((MessageSizeEstimator.Handle)object);
        }
        return new ChannelOutboundBufferPendingBytesTracker(channelOutboundBuffer, (MessageSizeEstimator.Handle)object);
    }

    private static final class NoopPendingBytesTracker
    extends PendingBytesTracker {
        NoopPendingBytesTracker(MessageSizeEstimator.Handle handle) {
            super(handle);
        }

        public final void incrementPendingOutboundBytes(long l2) {
        }

        public final void decrementPendingOutboundBytes(long l2) {
        }
    }

    private static final class ChannelOutboundBufferPendingBytesTracker
    extends PendingBytesTracker {
        private final ChannelOutboundBuffer buffer;

        ChannelOutboundBufferPendingBytesTracker(ChannelOutboundBuffer channelOutboundBuffer, MessageSizeEstimator.Handle handle) {
            super(handle);
            this.buffer = channelOutboundBuffer;
        }

        public final void incrementPendingOutboundBytes(long l2) {
            this.buffer.incrementPendingOutboundBytes(l2);
        }

        public final void decrementPendingOutboundBytes(long l2) {
            this.buffer.decrementPendingOutboundBytes(l2);
        }
    }

    private static final class DefaultChannelPipelinePendingBytesTracker
    extends PendingBytesTracker {
        private final DefaultChannelPipeline pipeline;

        DefaultChannelPipelinePendingBytesTracker(DefaultChannelPipeline defaultChannelPipeline) {
            super(defaultChannelPipeline.estimatorHandle());
            this.pipeline = defaultChannelPipeline;
        }

        public final void incrementPendingOutboundBytes(long l2) {
            this.pipeline.incrementPendingOutboundBytes(l2);
        }

        public final void decrementPendingOutboundBytes(long l2) {
            this.pipeline.decrementPendingOutboundBytes(l2);
        }
    }
}

