/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufHolder;
import com.appoptics.ext.io.netty.channel.FileRegion;
import com.appoptics.ext.io.netty.channel.MessageSizeEstimator;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;

public final class DefaultMessageSizeEstimator
implements MessageSizeEstimator {
    public static final MessageSizeEstimator DEFAULT = new DefaultMessageSizeEstimator(8);
    private final MessageSizeEstimator.Handle handle;

    public DefaultMessageSizeEstimator(int n2) {
        ObjectUtil.checkPositiveOrZero(n2, "unknownSize");
        this.handle = new HandleImpl(n2);
    }

    public final MessageSizeEstimator.Handle newHandle() {
        return this.handle;
    }

    private static final class HandleImpl
    implements MessageSizeEstimator.Handle {
        private final int unknownSize;

        private HandleImpl(int n2) {
            this.unknownSize = n2;
        }

        public final int size(Object object) {
            if (object instanceof ByteBuf) {
                return ((ByteBuf)object).readableBytes();
            }
            if (object instanceof ByteBufHolder) {
                return ((ByteBufHolder)object).content().readableBytes();
            }
            if (object instanceof FileRegion) {
                return 0;
            }
            return this.unknownSize;
        }
    }
}

