/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.channel;

import com.appoptics.ext.io.netty.channel.AbstractChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerAdapter;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelInboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.ChannelOutboundBuffer;
import com.appoptics.ext.io.netty.channel.ChannelOutboundHandler;
import com.appoptics.ext.io.netty.channel.ChannelPipeline;
import com.appoptics.ext.io.netty.channel.ChannelPipelineException;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.channel.DefaultChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.DefaultChannelPromise;
import com.appoptics.ext.io.netty.channel.FailedChannelFuture;
import com.appoptics.ext.io.netty.channel.MessageSizeEstimator;
import com.appoptics.ext.io.netty.channel.SucceededChannelFuture;
import com.appoptics.ext.io.netty.channel.VoidChannelPromise;
import com.appoptics.ext.io.netty.util.ReferenceCountUtil;
import com.appoptics.ext.io.netty.util.ResourceLeakDetector;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutor;
import com.appoptics.ext.io.netty.util.concurrent.EventExecutorGroup;
import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChannelPipeline
implements ChannelPipeline {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelPipeline.class);
    private static final String HEAD_NAME = DefaultChannelPipeline.generateName0(HeadContext.class);
    private static final String TAIL_NAME = DefaultChannelPipeline.generateName0(TailContext.class);
    private static final FastThreadLocal<Map<Class<?>, String>> nameCaches = new FastThreadLocal<Map<Class<?>, String>>(){

        @Override
        protected final Map<Class<?>, String> initialValue() {
            return new WeakHashMap();
        }
    };
    private static final AtomicReferenceFieldUpdater<DefaultChannelPipeline, MessageSizeEstimator.Handle> ESTIMATOR = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelPipeline.class, MessageSizeEstimator.Handle.class, "estimatorHandle");
    final AbstractChannelHandlerContext head;
    final AbstractChannelHandlerContext tail;
    private final Channel channel;
    private final ChannelFuture succeededFuture;
    private final VoidChannelPromise voidPromise;
    private final boolean touch = ResourceLeakDetector.isEnabled();
    private Map<EventExecutorGroup, EventExecutor> childExecutors;
    private volatile MessageSizeEstimator.Handle estimatorHandle;
    private boolean firstRegistration = true;
    private PendingHandlerCallback pendingHandlerCallbackHead;
    private boolean registered;

    protected DefaultChannelPipeline(Channel channel) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
        this.succeededFuture = new SucceededChannelFuture(channel, null);
        this.voidPromise = new VoidChannelPromise(channel, true);
        DefaultChannelPipeline defaultChannelPipeline = this;
        this.tail = defaultChannelPipeline.new TailContext(defaultChannelPipeline);
        DefaultChannelPipeline defaultChannelPipeline2 = this;
        this.head = defaultChannelPipeline2.new HeadContext(defaultChannelPipeline2);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    final MessageSizeEstimator.Handle estimatorHandle() {
        MessageSizeEstimator.Handle handle = this.estimatorHandle;
        if (handle == null && !ESTIMATOR.compareAndSet(this, null, handle = this.channel.config().getMessageSizeEstimator().newHandle())) {
            handle = this.estimatorHandle;
        }
        return handle;
    }

    final Object touch(Object object, AbstractChannelHandlerContext abstractChannelHandlerContext) {
        if (this.touch) {
            return ReferenceCountUtil.touch(object, abstractChannelHandlerContext);
        }
        return object;
    }

    private AbstractChannelHandlerContext newContext(EventExecutorGroup eventExecutorGroup, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return new DefaultChannelHandlerContext(defaultChannelPipeline, defaultChannelPipeline.childExecutor(eventExecutorGroup), string, channelHandler);
    }

    private EventExecutor childExecutor(EventExecutorGroup eventExecutorGroup) {
        EventExecutor eventExecutor;
        if (eventExecutorGroup == null) {
            return null;
        }
        Object object = this.channel.config().getOption(ChannelOption.SINGLE_EVENTEXECUTOR_PER_GROUP);
        if (object != null && !((Boolean)object).booleanValue()) {
            return eventExecutorGroup.next();
        }
        object = this.childExecutors;
        if (object == null) {
            this.childExecutors = new IdentityHashMap<EventExecutorGroup, EventExecutor>(4);
            object = this.childExecutors;
        }
        if ((eventExecutor = (EventExecutor)object.get(eventExecutorGroup)) == null) {
            eventExecutor = eventExecutorGroup.next();
            object.put((EventExecutorGroup)eventExecutorGroup, (EventExecutor)eventExecutor);
        }
        return eventExecutor;
    }

    public final Channel channel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ChannelPipeline addLast(EventExecutorGroup object, String object2, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            object = this.newContext((EventExecutorGroup)object, this.filterName((String)object2, channelHandler), channelHandler);
            this.addLast0((AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                this.callHandlerAddedInEventLoop((AbstractChannelHandlerContext)object, (EventExecutor)object2);
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private void addLast0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2 = this.tail.prev;
        abstractChannelHandlerContext.next = this.tail;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext;
        this.tail.prev = abstractChannelHandlerContext;
    }

    @Override
    public final ChannelPipeline addBefore(String string, String string2, ChannelHandler channelHandler) {
        return this.addBefore(null, string, string2, channelHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ChannelPipeline addBefore(EventExecutorGroup object, String object2, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            string = this.filterName(string, channelHandler);
            object2 = this.getContextOrDie((String)object2);
            object = this.newContext((EventExecutorGroup)object, string, channelHandler);
            DefaultChannelPipeline.addBefore0((AbstractChannelHandlerContext)object2, (AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                this.callHandlerAddedInEventLoop((AbstractChannelHandlerContext)object, (EventExecutor)object2);
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private static void addBefore0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext.prev;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext;
        abstractChannelHandlerContext.prev.next = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
    }

    private String filterName(String string, ChannelHandler channelHandler) {
        if (string == null) {
            return this.generateName(channelHandler);
        }
        this.checkDuplicateName(string);
        return string;
    }

    @Override
    public final ChannelPipeline addAfter(String string, String string2, ChannelHandler channelHandler) {
        return this.addAfter(null, string, string2, channelHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ChannelPipeline addAfter(EventExecutorGroup object, String object2, String string, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            string = this.filterName(string, channelHandler);
            object2 = this.getContextOrDie((String)object2);
            object = this.newContext((EventExecutorGroup)object, string, channelHandler);
            DefaultChannelPipeline.addAfter0((AbstractChannelHandlerContext)object2, (AbstractChannelHandlerContext)object);
            if (!this.registered) {
                ((AbstractChannelHandlerContext)object).setAddPending();
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                return this;
            }
            object2 = ((AbstractChannelHandlerContext)object).executor();
            if (!object2.inEventLoop()) {
                this.callHandlerAddedInEventLoop((AbstractChannelHandlerContext)object, (EventExecutor)object2);
                return this;
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        return this;
    }

    private static void addAfter0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext.next.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
    }

    @Override
    public final ChannelPipeline addLast(ChannelHandler ... channelHandlerArray) {
        return this.addLast((EventExecutorGroup)null, channelHandlerArray);
    }

    public final ChannelPipeline addLast(EventExecutorGroup eventExecutorGroup, ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        for (ChannelHandler channelHandler : channelHandlerArray) {
            if (channelHandler == null) break;
            this.addLast(eventExecutorGroup, (String)null, channelHandler);
        }
        return this;
    }

    private String generateName(ChannelHandler object) {
        Map<Class<?>, String> map = nameCaches.get();
        String string = map.get(object = object.getClass());
        if (string == null) {
            string = DefaultChannelPipeline.generateName0(object);
            map.put((Class<?>)object, string);
        }
        if (this.context0(string) != null) {
            object = string.substring(0, string.length() - 1);
            int n2 = 1;
            while (this.context0(string = (String)object + n2) != null) {
                ++n2;
            }
        }
        return string;
    }

    private static String generateName0(Class<?> clazz) {
        return StringUtil.simpleClassName(clazz) + "#0";
    }

    @Override
    public final ChannelPipeline remove(ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie(channelHandler));
        return this;
    }

    @Override
    public final ChannelHandler remove(String string) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.remove(defaultChannelPipeline.getContextOrDie(string)).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractChannelHandlerContext remove(final AbstractChannelHandlerContext abstractChannelHandlerContext) {
        assert (abstractChannelHandlerContext != this.head && abstractChannelHandlerContext != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            this.atomicRemoveFromHandlerList(abstractChannelHandlerContext);
            if (!this.registered) {
                this.callHandlerCallbackLater(abstractChannelHandlerContext, false);
                return abstractChannelHandlerContext;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!eventExecutor.inEventLoop()) {
                eventExecutor.execute(new Runnable(){

                    public void run() {
                        DefaultChannelPipeline.this.callHandlerRemoved0(abstractChannelHandlerContext);
                    }
                });
                return abstractChannelHandlerContext;
            }
        }
        this.callHandlerRemoved0(abstractChannelHandlerContext);
        return abstractChannelHandlerContext;
    }

    private synchronized void atomicRemoveFromHandlerList(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = abstractChannelHandlerContext.prev;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
    }

    @Override
    public final ChannelHandler replace(String string, String string2, ChannelHandler channelHandler) {
        DefaultChannelPipeline defaultChannelPipeline = this;
        return defaultChannelPipeline.replace(defaultChannelPipeline.getContextOrDie(string), string2, channelHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelHandler replace(AbstractChannelHandlerContext abstractChannelHandlerContext, String object, ChannelHandler channelHandler) {
        assert (abstractChannelHandlerContext != this.head && abstractChannelHandlerContext != this.tail);
        DefaultChannelPipeline defaultChannelPipeline = this;
        synchronized (defaultChannelPipeline) {
            DefaultChannelPipeline.checkMultiplicity(channelHandler);
            if (object == null) {
                object = this.generateName(channelHandler);
            } else {
                boolean bl = abstractChannelHandlerContext.name().equals(object);
                if (!bl) {
                    this.checkDuplicateName((String)object);
                }
            }
            object = this.newContext(abstractChannelHandlerContext.executor, (String)object, channelHandler);
            DefaultChannelPipeline.replace0(abstractChannelHandlerContext, (AbstractChannelHandlerContext)object);
            if (!this.registered) {
                this.callHandlerCallbackLater((AbstractChannelHandlerContext)object, true);
                this.callHandlerCallbackLater(abstractChannelHandlerContext, false);
                return abstractChannelHandlerContext.handler();
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!eventExecutor.inEventLoop()) {
                eventExecutor.execute(new Runnable((AbstractChannelHandlerContext)object, abstractChannelHandlerContext){
                    final /* synthetic */ AbstractChannelHandlerContext val$newCtx;
                    final /* synthetic */ AbstractChannelHandlerContext val$ctx;
                    {
                        this.val$newCtx = abstractChannelHandlerContext;
                        this.val$ctx = abstractChannelHandlerContext2;
                    }

                    public void run() {
                        DefaultChannelPipeline.this.callHandlerAdded0(this.val$newCtx);
                        DefaultChannelPipeline.this.callHandlerRemoved0(this.val$ctx);
                    }
                });
                return abstractChannelHandlerContext.handler();
            }
        }
        this.callHandlerAdded0((AbstractChannelHandlerContext)object);
        this.callHandlerRemoved0(abstractChannelHandlerContext);
        return abstractChannelHandlerContext.handler();
    }

    private static void replace0(AbstractChannelHandlerContext abstractChannelHandlerContext, AbstractChannelHandlerContext abstractChannelHandlerContext2) {
        AbstractChannelHandlerContext abstractChannelHandlerContext3 = abstractChannelHandlerContext.prev;
        AbstractChannelHandlerContext abstractChannelHandlerContext4 = abstractChannelHandlerContext.next;
        abstractChannelHandlerContext2.prev = abstractChannelHandlerContext3;
        abstractChannelHandlerContext2.next = abstractChannelHandlerContext4;
        abstractChannelHandlerContext3.next = abstractChannelHandlerContext2;
        abstractChannelHandlerContext4.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.prev = abstractChannelHandlerContext2;
        abstractChannelHandlerContext.next = abstractChannelHandlerContext2;
    }

    private static void checkMultiplicity(ChannelHandler channelHandler) {
        if (channelHandler instanceof ChannelHandlerAdapter) {
            if (!((ChannelHandlerAdapter)(channelHandler = (ChannelHandlerAdapter)channelHandler)).isSharable() && ((ChannelHandlerAdapter)channelHandler).added) {
                throw new ChannelPipelineException(channelHandler.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            ((ChannelHandlerAdapter)channelHandler).added = true;
        }
    }

    private void callHandlerAdded0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        try {
            abstractChannelHandlerContext.callHandlerAdded();
            return;
        }
        catch (Throwable throwable) {
            boolean bl;
            block5: {
                bl = false;
                try {
                    this.atomicRemoveFromHandlerList(abstractChannelHandlerContext);
                    abstractChannelHandlerContext.callHandlerRemoved();
                    bl = true;
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Failed to remove a handler: " + abstractChannelHandlerContext.name(), throwable2);
                }
            }
            if (bl) {
                this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerAdded() has thrown an exception; removed.", throwable));
                return;
            }
            this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerAdded() has thrown an exception; also failed to remove.", throwable));
            return;
        }
    }

    private void callHandlerRemoved0(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        try {
            abstractChannelHandlerContext.callHandlerRemoved();
            return;
        }
        catch (Throwable throwable) {
            this.fireExceptionCaught(new ChannelPipelineException(abstractChannelHandlerContext.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", throwable));
            return;
        }
    }

    final void invokeHandlerAddedIfNeeded() {
        assert (this.channel.eventLoop().inEventLoop());
        if (this.firstRegistration) {
            this.firstRegistration = false;
            this.callHandlerAddedForAllHandlers();
        }
    }

    @Override
    public final <T extends ChannelHandler> T get(Class<T> object) {
        if ((object = this.context((Class<? extends ChannelHandler>)object)) == null) {
            return null;
        }
        return (T)object.handler();
    }

    public final ChannelHandlerContext context(String string) {
        return this.context0(ObjectUtil.checkNotNull(string, "name"));
    }

    @Override
    public final ChannelHandlerContext context(ChannelHandler channelHandler) {
        ObjectUtil.checkNotNull(channelHandler, "handler");
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            if (abstractChannelHandlerContext.handler() == channelHandler) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    @Override
    public final ChannelHandlerContext context(Class<? extends ChannelHandler> clazz) {
        ObjectUtil.checkNotNull(clazz, "handlerType");
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            if (clazz.isAssignableFrom(abstractChannelHandlerContext.handler().getClass())) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    @Override
    public final List<String> names() {
        ArrayList<String> arrayList = new ArrayList<String>();
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != null) {
            arrayList.add(abstractChannelHandlerContext.name());
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return arrayList;
    }

    public final Map<String, ChannelHandler> toMap() {
        LinkedHashMap<String, ChannelHandler> linkedHashMap = new LinkedHashMap<String, ChannelHandler>();
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            linkedHashMap.put(abstractChannelHandlerContext.name(), abstractChannelHandlerContext.handler());
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return linkedHashMap;
    }

    @Override
    public final Iterator<Map.Entry<String, ChannelHandler>> iterator() {
        return this.toMap().entrySet().iterator();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(StringUtil.simpleClassName(this)).append('{');
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            stringBuilder.append('(').append(abstractChannelHandlerContext.name()).append(" = ").append(abstractChannelHandlerContext.handler().getClass().getName()).append(')');
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            if (abstractChannelHandlerContext == this.tail) break;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public final ChannelPipeline fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.head);
        return this;
    }

    private synchronized void destroy() {
        DefaultChannelPipeline defaultChannelPipeline = this;
        defaultChannelPipeline.destroyUp(defaultChannelPipeline.head.next, false);
    }

    private void destroyUp(final AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl) {
        Thread thread = Thread.currentThread();
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = this.tail;
        while (true) {
            if (abstractChannelHandlerContext == abstractChannelHandlerContext2) {
                this.destroyDown(thread, abstractChannelHandlerContext2.prev, bl);
                return;
            }
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!bl && !eventExecutor.inEventLoop(thread)) {
                eventExecutor.execute(new Runnable(){

                    public void run() {
                        DefaultChannelPipeline.this.destroyUp(abstractChannelHandlerContext, true);
                    }
                });
                return;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
            bl = false;
        }
    }

    private void destroyDown(Thread object, AbstractChannelHandlerContext abstractChannelHandlerContext, boolean bl) {
        AbstractChannelHandlerContext abstractChannelHandlerContext2 = this.head;
        while (abstractChannelHandlerContext != abstractChannelHandlerContext2) {
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (!bl && !eventExecutor.inEventLoop((Thread)object)) {
                object = abstractChannelHandlerContext;
                eventExecutor.execute(new Runnable((AbstractChannelHandlerContext)object){
                    final /* synthetic */ AbstractChannelHandlerContext val$finalCtx;
                    {
                        this.val$finalCtx = abstractChannelHandlerContext;
                    }

                    public void run() {
                        DefaultChannelPipeline.this.destroyDown(Thread.currentThread(), this.val$finalCtx, true);
                    }
                });
                return;
            }
            this.atomicRemoveFromHandlerList(abstractChannelHandlerContext);
            this.callHandlerRemoved0(abstractChannelHandlerContext);
            abstractChannelHandlerContext = abstractChannelHandlerContext.prev;
            bl = false;
        }
    }

    @Override
    public final ChannelPipeline fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.head, throwable);
        return this;
    }

    @Override
    public final ChannelPipeline fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.head, object);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.head, object);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.head);
        return this;
    }

    @Override
    public final ChannelPipeline fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.head);
        return this;
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress) {
        return this.tail.connect(socketAddress);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.tail.connect(socketAddress, socketAddress2);
    }

    @Override
    public final ChannelFuture close() {
        return this.tail.close();
    }

    @Override
    public final ChannelPipeline flush() {
        this.tail.flush();
        return this;
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.tail.connect(socketAddress, channelPromise);
    }

    @Override
    public final ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.tail.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.tail.disconnect(channelPromise);
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        return this.tail.close(channelPromise);
    }

    @Override
    public final ChannelPipeline read() {
        this.tail.read();
        return this;
    }

    @Override
    public final ChannelFuture write(Object object) {
        return this.tail.write(object);
    }

    @Override
    public final ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.tail.write(object, channelPromise);
    }

    @Override
    public final ChannelFuture writeAndFlush(Object object) {
        return this.tail.writeAndFlush(object);
    }

    @Override
    public final ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel);
    }

    @Override
    public final ChannelFuture newSucceededFuture() {
        return this.succeededFuture;
    }

    @Override
    public final ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel, null, throwable);
    }

    @Override
    public final ChannelPromise voidPromise() {
        return this.voidPromise;
    }

    private void checkDuplicateName(String string) {
        if (this.context0(string) != null) {
            throw new IllegalArgumentException("Duplicate handler name: " + string);
        }
    }

    private AbstractChannelHandlerContext context0(String string) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.head.next;
        while (abstractChannelHandlerContext != this.tail) {
            if (abstractChannelHandlerContext.name().equals(string)) {
                return abstractChannelHandlerContext;
            }
            abstractChannelHandlerContext = abstractChannelHandlerContext.next;
        }
        return null;
    }

    private AbstractChannelHandlerContext getContextOrDie(String string) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(string);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(string);
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext getContextOrDie(ChannelHandler channelHandler) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = (AbstractChannelHandlerContext)this.context(channelHandler);
        if (abstractChannelHandlerContext == null) {
            throw new NoSuchElementException(channelHandler.getClass().getName());
        }
        return abstractChannelHandlerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callHandlerAddedForAllHandlers() {
        PendingHandlerCallback pendingHandlerCallback;
        Object object = this;
        synchronized (object) {
            assert (!this.registered);
            this.registered = true;
            pendingHandlerCallback = this.pendingHandlerCallbackHead;
            this.pendingHandlerCallbackHead = null;
        }
        object = pendingHandlerCallback;
        while (object != null) {
            ((PendingHandlerCallback)object).execute();
            object = ((PendingHandlerCallback)object).next;
        }
    }

    private void callHandlerCallbackLater(AbstractChannelHandlerContext object, boolean bl) {
        assert (!this.registered);
        object = bl ? new PendingHandlerAddedTask((AbstractChannelHandlerContext)object) : new PendingHandlerRemovedTask((AbstractChannelHandlerContext)object);
        PendingHandlerCallback pendingHandlerCallback = this.pendingHandlerCallbackHead;
        if (pendingHandlerCallback == null) {
            this.pendingHandlerCallbackHead = object;
            return;
        }
        while (pendingHandlerCallback.next != null) {
            pendingHandlerCallback = pendingHandlerCallback.next;
        }
        pendingHandlerCallback.next = object;
    }

    private void callHandlerAddedInEventLoop(final AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor) {
        abstractChannelHandlerContext.setAddPending();
        eventExecutor.execute(new Runnable(){

            public void run() {
                DefaultChannelPipeline.this.callHandlerAdded0(abstractChannelHandlerContext);
            }
        });
    }

    protected void onUnhandledInboundException(Throwable throwable) {
        try {
            logger.warn("An exceptionCaught() event was fired, and it reached at the tail of the pipeline. It usually means the last handler in the pipeline did not handle the exception.", throwable);
            return;
        }
        finally {
            ReferenceCountUtil.release(throwable);
        }
    }

    protected void onUnhandledInboundChannelActive() {
    }

    protected void onUnhandledInboundChannelInactive() {
    }

    protected void onUnhandledInboundMessage(Object object) {
        try {
            logger.debug("Discarded inbound message {} that reached at the tail of the pipeline. Please check your pipeline configuration.", object);
            return;
        }
        finally {
            ReferenceCountUtil.release(object);
        }
    }

    protected void onUnhandledInboundMessage(ChannelHandlerContext channelHandlerContext, Object object) {
        this.onUnhandledInboundMessage(object);
        if (logger.isDebugEnabled()) {
            logger.debug("Discarded message pipeline : {}. Channel : {}.", (Object)channelHandlerContext.pipeline().names(), (Object)channelHandlerContext.channel());
        }
    }

    protected void onUnhandledInboundChannelReadComplete() {
    }

    protected void onUnhandledInboundUserEventTriggered(Object object) {
        ReferenceCountUtil.release(object);
    }

    protected void onUnhandledChannelWritabilityChanged() {
    }

    protected void incrementPendingOutboundBytes(long l2) {
        ChannelOutboundBuffer channelOutboundBuffer = this.channel.unsafe().outboundBuffer();
        if (channelOutboundBuffer != null) {
            channelOutboundBuffer.incrementPendingOutboundBytes(l2);
        }
    }

    protected void decrementPendingOutboundBytes(long l2) {
        ChannelOutboundBuffer channelOutboundBuffer = this.channel.unsafe().outboundBuffer();
        if (channelOutboundBuffer != null) {
            channelOutboundBuffer.decrementPendingOutboundBytes(l2);
        }
    }

    private final class PendingHandlerRemovedTask
    extends PendingHandlerCallback {
        PendingHandlerRemovedTask(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            super(abstractChannelHandlerContext);
        }

        public final void run() {
            DefaultChannelPipeline.this.callHandlerRemoved0(this.ctx);
        }

        final void execute() {
            EventExecutor eventExecutor = this.ctx.executor();
            if (eventExecutor.inEventLoop()) {
                DefaultChannelPipeline.this.callHandlerRemoved0(this.ctx);
                return;
            }
            try {
                eventExecutor.execute(this);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Can't invoke handlerRemoved() as the EventExecutor {} rejected it, removing handler {}.", eventExecutor, this.ctx.name(), rejectedExecutionException);
                }
                this.ctx.setRemoved();
                return;
            }
        }
    }

    private final class PendingHandlerAddedTask
    extends PendingHandlerCallback {
        PendingHandlerAddedTask(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            super(abstractChannelHandlerContext);
        }

        public final void run() {
            DefaultChannelPipeline.this.callHandlerAdded0(this.ctx);
        }

        final void execute() {
            EventExecutor eventExecutor = this.ctx.executor();
            if (eventExecutor.inEventLoop()) {
                DefaultChannelPipeline.this.callHandlerAdded0(this.ctx);
                return;
            }
            try {
                eventExecutor.execute(this);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Can't invoke handlerAdded() as the EventExecutor {} rejected it, removing handler {}.", eventExecutor, this.ctx.name(), rejectedExecutionException);
                }
                DefaultChannelPipeline.this.atomicRemoveFromHandlerList(this.ctx);
                this.ctx.setRemoved();
                return;
            }
        }
    }

    private static abstract class PendingHandlerCallback
    implements Runnable {
        final AbstractChannelHandlerContext ctx;
        PendingHandlerCallback next;

        PendingHandlerCallback(AbstractChannelHandlerContext abstractChannelHandlerContext) {
            this.ctx = abstractChannelHandlerContext;
        }

        abstract void execute();
    }

    final class HeadContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler,
    ChannelOutboundHandler {
        private final Channel.Unsafe unsafe;

        HeadContext(DefaultChannelPipeline defaultChannelPipeline2) {
            super(defaultChannelPipeline2, null, HEAD_NAME, HeadContext.class);
            this.unsafe = defaultChannelPipeline2.channel().unsafe();
            this.setAddComplete();
        }

        public final ChannelHandler handler() {
            return this;
        }

        public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        }

        public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        }

        public final void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
            this.unsafe.connect(socketAddress, socketAddress2, channelPromise);
        }

        public final void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.unsafe.disconnect(channelPromise);
        }

        public final void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
            this.unsafe.close(channelPromise);
        }

        public final void read(ChannelHandlerContext channelHandlerContext) {
            this.unsafe.beginRead();
        }

        public final void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
            this.unsafe.write(object, channelPromise);
        }

        public final void flush(ChannelHandlerContext channelHandlerContext) {
            this.unsafe.flush();
        }

        public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            channelHandlerContext.fireExceptionCaught(throwable);
        }

        public final void channelRegistered(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.invokeHandlerAddedIfNeeded();
            channelHandlerContext.fireChannelRegistered();
        }

        public final void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelUnregistered();
            if (!DefaultChannelPipeline.this.channel.isOpen()) {
                DefaultChannelPipeline.this.destroy();
            }
        }

        public final void channelActive(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelActive();
            this.readIfIsAutoRead();
        }

        public final void channelInactive(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelInactive();
        }

        public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            channelHandlerContext.fireChannelRead(object);
        }

        public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelReadComplete();
            this.readIfIsAutoRead();
        }

        private void readIfIsAutoRead() {
            if (DefaultChannelPipeline.this.channel.config().isAutoRead()) {
                DefaultChannelPipeline.this.channel.read();
            }
        }

        public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
            channelHandlerContext.fireUserEventTriggered(object);
        }

        public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
            channelHandlerContext.fireChannelWritabilityChanged();
        }
    }

    final class TailContext
    extends AbstractChannelHandlerContext
    implements ChannelInboundHandler {
        TailContext(DefaultChannelPipeline defaultChannelPipeline2) {
            super(defaultChannelPipeline2, null, TAIL_NAME, TailContext.class);
            this.setAddComplete();
        }

        public final ChannelHandler handler() {
            return this;
        }

        public final void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        }

        public final void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
        }

        public final void channelActive(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelActive();
        }

        public final void channelInactive(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelInactive();
        }

        public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledChannelWritabilityChanged();
        }

        public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        }

        public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        }

        public final void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
            DefaultChannelPipeline.this.onUnhandledInboundUserEventTriggered(object);
        }

        public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
            DefaultChannelPipeline.this.onUnhandledInboundException(throwable);
        }

        public final void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
            DefaultChannelPipeline.this.onUnhandledInboundMessage(channelHandlerContext, object);
        }

        public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
            DefaultChannelPipeline.this.onUnhandledInboundChannelReadComplete();
        }
    }
}

