/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledUnsafeNoCleanerDirectByteBuf;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

final class UnsafeByteBufUtil {
    private static final boolean UNALIGNED = PlatformDependent.isUnaligned();

    static byte getByte(long l2) {
        return PlatformDependent.getByte(l2);
    }

    static short getShort(long l2) {
        if (UNALIGNED) {
            short s2 = PlatformDependent.getShort(l2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return s2;
            }
            return Short.reverseBytes(s2);
        }
        return (short)(PlatformDependent.getByte(l2) << 8 | PlatformDependent.getByte(l2 + 1L) & 0xFF);
    }

    static short getShortLE(long l2) {
        if (UNALIGNED) {
            short s2 = PlatformDependent.getShort(l2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Short.reverseBytes(s2);
            }
            return s2;
        }
        return (short)(PlatformDependent.getByte(l2) & 0xFF | PlatformDependent.getByte(l2 + 1L) << 8);
    }

    static int getUnsignedMedium(long l2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(l2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(l2 + 1L) : Short.reverseBytes(PlatformDependent.getShort(l2 + 1L))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(l2) & 0xFF) << 16 | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 8 | PlatformDependent.getByte(l2 + 2L) & 0xFF;
    }

    static int getInt(long l2) {
        if (UNALIGNED) {
            int n2 = PlatformDependent.getInt(l2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return n2;
            }
            return Integer.reverseBytes(n2);
        }
        return PlatformDependent.getByte(l2) << 24 | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 16 | (PlatformDependent.getByte(l2 + 2L) & 0xFF) << 8 | PlatformDependent.getByte(l2 + 3L) & 0xFF;
    }

    static int getIntLE(long l2) {
        if (UNALIGNED) {
            int n2 = PlatformDependent.getInt(l2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Integer.reverseBytes(n2);
            }
            return n2;
        }
        return PlatformDependent.getByte(l2) & 0xFF | (PlatformDependent.getByte(l2 + 1L) & 0xFF) << 8 | (PlatformDependent.getByte(l2 + 2L) & 0xFF) << 16 | PlatformDependent.getByte(l2 + 3L) << 24;
    }

    static long getLong(long l2) {
        if (UNALIGNED) {
            long l3 = PlatformDependent.getLong(l2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return l3;
            }
            return Long.reverseBytes(l3);
        }
        return (long)PlatformDependent.getByte(l2) << 56 | ((long)PlatformDependent.getByte(l2 + 1L) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(l2 + 2L) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(l2 + 3L) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(l2 + 4L) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(l2 + 5L) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(l2 + 6L) & 0xFFL) << 8 | (long)PlatformDependent.getByte(l2 + 7L) & 0xFFL;
    }

    static void setByte(long l2, int n2) {
        PlatformDependent.putByte(l2, (byte)n2);
    }

    static void setShort(long l2, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n2 : Short.reverseBytes((short)n2));
            return;
        }
        PlatformDependent.putByte(l2, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 1L, (byte)n2);
    }

    static void setShortLE(long l2, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putShort(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)n2) : (short)n2);
            return;
        }
        PlatformDependent.putByte(l2, (byte)n2);
        PlatformDependent.putByte(l2 + 1L, (byte)(n2 >>> 8));
    }

    static void setMedium(long l2, int n2) {
        PlatformDependent.putByte(l2, (byte)(n2 >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(l2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n2 : Short.reverseBytes((short)n2));
            return;
        }
        PlatformDependent.putByte(l2 + 1L, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 2L, (byte)n2);
    }

    static void setMediumLE(long l2, int n2) {
        PlatformDependent.putByte(l2, (byte)n2);
        if (UNALIGNED) {
            PlatformDependent.putShort(l2 + 1L, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(n2 >>> 8)) : (short)(n2 >>> 8));
            return;
        }
        PlatformDependent.putByte(l2 + 1L, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 2L, (byte)(n2 >>> 16));
    }

    static void setInt(long l2, int n2) {
        if (UNALIGNED) {
            PlatformDependent.putInt(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n2 : Integer.reverseBytes(n2));
            return;
        }
        PlatformDependent.putByte(l2, (byte)(n2 >>> 24));
        PlatformDependent.putByte(l2 + 1L, (byte)(n2 >>> 16));
        PlatformDependent.putByte(l2 + 2L, (byte)(n2 >>> 8));
        PlatformDependent.putByte(l2 + 3L, (byte)n2);
    }

    static void setLong(long l2, long l3) {
        if (UNALIGNED) {
            PlatformDependent.putLong(l2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l3 : Long.reverseBytes(l3));
            return;
        }
        PlatformDependent.putByte(l2, (byte)(l3 >>> 56));
        PlatformDependent.putByte(l2 + 1L, (byte)(l3 >>> 48));
        PlatformDependent.putByte(l2 + 2L, (byte)(l3 >>> 40));
        PlatformDependent.putByte(l2 + 3L, (byte)(l3 >>> 32));
        PlatformDependent.putByte(l2 + 4L, (byte)(l3 >>> 24));
        PlatformDependent.putByte(l2 + 5L, (byte)(l3 >>> 16));
        PlatformDependent.putByte(l2 + 6L, (byte)(l3 >>> 8));
        PlatformDependent.putByte(l2 + 7L, (byte)l3);
    }

    static byte getByte(byte[] byArray, int n2) {
        return PlatformDependent.getByte(byArray, n2);
    }

    static short getShort(byte[] byArray, int n2) {
        if (UNALIGNED) {
            short s2 = PlatformDependent.getShort(byArray, n2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return s2;
            }
            return Short.reverseBytes(s2);
        }
        return (short)(PlatformDependent.getByte(byArray, n2) << 8 | PlatformDependent.getByte(byArray, n2 + 1) & 0xFF);
    }

    static short getShortLE(byte[] byArray, int n2) {
        if (UNALIGNED) {
            short s2 = PlatformDependent.getShort(byArray, n2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Short.reverseBytes(s2);
            }
            return s2;
        }
        return (short)(PlatformDependent.getByte(byArray, n2) & 0xFF | PlatformDependent.getByte(byArray, n2 + 1) << 8);
    }

    static int getUnsignedMedium(byte[] byArray, int n2) {
        if (UNALIGNED) {
            return (PlatformDependent.getByte(byArray, n2) & 0xFF) << 16 | (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? PlatformDependent.getShort(byArray, n2 + 1) : Short.reverseBytes(PlatformDependent.getShort(byArray, n2 + 1))) & 0xFFFF;
        }
        return (PlatformDependent.getByte(byArray, n2) & 0xFF) << 16 | (PlatformDependent.getByte(byArray, n2 + 1) & 0xFF) << 8 | PlatformDependent.getByte(byArray, n2 + 2) & 0xFF;
    }

    static int getInt(byte[] byArray, int n2) {
        if (UNALIGNED) {
            int n3 = PlatformDependent.getInt(byArray, n2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return n3;
            }
            return Integer.reverseBytes(n3);
        }
        return PlatformDependent.getByte(byArray, n2) << 24 | (PlatformDependent.getByte(byArray, n2 + 1) & 0xFF) << 16 | (PlatformDependent.getByte(byArray, n2 + 2) & 0xFF) << 8 | PlatformDependent.getByte(byArray, n2 + 3) & 0xFF;
    }

    static int getIntLE(byte[] byArray, int n2) {
        if (UNALIGNED) {
            int n3 = PlatformDependent.getInt(byArray, n2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return Integer.reverseBytes(n3);
            }
            return n3;
        }
        return PlatformDependent.getByte(byArray, n2) & 0xFF | (PlatformDependent.getByte(byArray, n2 + 1) & 0xFF) << 8 | (PlatformDependent.getByte(byArray, n2 + 2) & 0xFF) << 16 | PlatformDependent.getByte(byArray, n2 + 3) << 24;
    }

    static long getLong(byte[] byArray, int n2) {
        if (UNALIGNED) {
            long l2 = PlatformDependent.getLong(byArray, n2);
            if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
                return l2;
            }
            return Long.reverseBytes(l2);
        }
        return (long)PlatformDependent.getByte(byArray, n2) << 56 | ((long)PlatformDependent.getByte(byArray, n2 + 1) & 0xFFL) << 48 | ((long)PlatformDependent.getByte(byArray, n2 + 2) & 0xFFL) << 40 | ((long)PlatformDependent.getByte(byArray, n2 + 3) & 0xFFL) << 32 | ((long)PlatformDependent.getByte(byArray, n2 + 4) & 0xFFL) << 24 | ((long)PlatformDependent.getByte(byArray, n2 + 5) & 0xFFL) << 16 | ((long)PlatformDependent.getByte(byArray, n2 + 6) & 0xFFL) << 8 | (long)PlatformDependent.getByte(byArray, n2 + 7) & 0xFFL;
    }

    static void setByte(byte[] byArray, int n2, int n3) {
        PlatformDependent.putByte(byArray, n2, (byte)n3);
    }

    static void setShort(byte[] byArray, int n2, int n3) {
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n3 : Short.reverseBytes((short)n3));
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)n3);
    }

    static void setShortLE(byte[] byArray, int n2, int n3) {
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)n3) : (short)n3);
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)n3);
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(n3 >>> 8));
    }

    static void setMedium(byte[] byArray, int n2, int n3) {
        PlatformDependent.putByte(byArray, n2, (byte)(n3 >>> 16));
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n2 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)n3 : Short.reverseBytes((short)n3));
            return;
        }
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)n3);
    }

    static void setMediumLE(byte[] byArray, int n2, int n3) {
        PlatformDependent.putByte(byArray, n2, (byte)n3);
        if (UNALIGNED) {
            PlatformDependent.putShort(byArray, n2 + 1, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? Short.reverseBytes((short)(n3 >>> 8)) : (short)(n3 >>> 8));
            return;
        }
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)(n3 >>> 16));
    }

    static void setInt(byte[] byArray, int n2, int n3) {
        if (UNALIGNED) {
            PlatformDependent.putInt(byArray, n2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? n3 : Integer.reverseBytes(n3));
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(n3 >>> 24));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(n3 >>> 16));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)(n3 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 3, (byte)n3);
    }

    static void setLong(byte[] byArray, int n2, long l2) {
        if (UNALIGNED) {
            PlatformDependent.putLong(byArray, n2, PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? l2 : Long.reverseBytes(l2));
            return;
        }
        PlatformDependent.putByte(byArray, n2, (byte)(l2 >>> 56));
        PlatformDependent.putByte(byArray, n2 + 1, (byte)(l2 >>> 48));
        PlatformDependent.putByte(byArray, n2 + 2, (byte)(l2 >>> 40));
        PlatformDependent.putByte(byArray, n2 + 3, (byte)(l2 >>> 32));
        PlatformDependent.putByte(byArray, n2 + 4, (byte)(l2 >>> 24));
        PlatformDependent.putByte(byArray, n2 + 5, (byte)(l2 >>> 16));
        PlatformDependent.putByte(byArray, n2 + 6, (byte)(l2 >>> 8));
        PlatformDependent.putByte(byArray, n2 + 7, (byte)l2);
    }

    static void setZero(byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        PlatformDependent.setMemory(byArray, n2, n3, (byte)0);
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuf byteBuf, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byteBuf, "dst");
        if (MathUtil.isOutOfBounds(n3, n4, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + n3);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory(l2, byteBuf.memoryAddress() + (long)n3, n4);
            return;
        }
        if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory(l2, byteBuf.array(), byteBuf.arrayOffset() + n3, (long)n4);
            return;
        }
        byteBuf.setBytes(n3, abstractByteBuf, n2, n4);
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, byte[] byArray, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byArray, "dst");
        if (MathUtil.isOutOfBounds(n3, n4, byArray.length)) {
            throw new IndexOutOfBoundsException("dstIndex: " + n3);
        }
        if (n4 != 0) {
            PlatformDependent.copyMemory(l2, byArray, n3, (long)n4);
        }
    }

    static void getBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuffer byteBuffer) {
        abstractByteBuf.checkIndex(n2, byteBuffer.remaining());
        if (byteBuffer.remaining() == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            if (byteBuffer.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            long l3 = PlatformDependent.directBufferAddress(byteBuffer);
            PlatformDependent.copyMemory(l2, l3 + (long)byteBuffer.position(), byteBuffer.remaining());
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.position() + byteBuffer.remaining());
            return;
        }
        if (byteBuffer.hasArray()) {
            PlatformDependent.copyMemory(l2, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), (long)byteBuffer.remaining());
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.position() + byteBuffer.remaining());
            return;
        }
        byteBuffer.put(abstractByteBuf.nioBuffer());
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuf byteBuf, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        ObjectUtil.checkNotNull(byteBuf, "src");
        if (MathUtil.isOutOfBounds(n3, n4, byteBuf.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + n3);
        }
        if (n4 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(byteBuf.memoryAddress() + (long)n3, l2, n4);
                return;
            }
            if (byteBuf.hasArray()) {
                PlatformDependent.copyMemory(byteBuf.array(), byteBuf.arrayOffset() + n3, l2, (long)n4);
                return;
            }
            byteBuf.getBytes(n3, abstractByteBuf, n2, n4);
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, byte[] byArray, int n3, int n4) {
        abstractByteBuf.checkIndex(n2, n4);
        if (n4 != 0) {
            PlatformDependent.copyMemory(byArray, n3, l2, (long)n4);
        }
    }

    static void setBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuffer byteBuffer) {
        int n3 = byteBuffer.remaining();
        if (n3 == 0) {
            return;
        }
        if (byteBuffer.isDirect()) {
            abstractByteBuf.checkIndex(n2, n3);
            long l3 = PlatformDependent.directBufferAddress(byteBuffer);
            PlatformDependent.copyMemory(l3 + (long)byteBuffer.position(), l2, n3);
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.position() + n3);
            return;
        }
        if (byteBuffer.hasArray()) {
            abstractByteBuf.checkIndex(n2, n3);
            PlatformDependent.copyMemory(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), l2, (long)n3);
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.position(byteBuffer3.position() + n3);
            return;
        }
        if (n3 < 8) {
            UnsafeByteBufUtil.setSingleBytes(abstractByteBuf, l2, n2, byteBuffer, n3);
            return;
        }
        assert (abstractByteBuf.nioBufferCount() == 1);
        ByteBuffer byteBuffer4 = abstractByteBuf.internalNioBuffer(n2, n3);
        byteBuffer4.put(byteBuffer);
    }

    private static void setSingleBytes(AbstractByteBuf abstractByteBuf, long l2, int n2, ByteBuffer byteBuffer, int n3) {
        abstractByteBuf.checkIndex(n2, n3);
        int n4 = byteBuffer.position();
        n2 = byteBuffer.limit();
        long l3 = l2;
        while (n4 < n2) {
            byte by = byteBuffer.get(n4);
            PlatformDependent.putByte(l3, by);
            ++l3;
            ++n4;
        }
        byteBuffer.position(n2);
    }

    static void setZero(long l2, int n2) {
        if (n2 == 0) {
            return;
        }
        PlatformDependent.setMemory(l2, n2, (byte)0);
    }

    static UnpooledUnsafeDirectByteBuf newUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            return new UnpooledUnsafeNoCleanerDirectByteBuf(byteBufAllocator, n2, n3);
        }
        return new UnpooledUnsafeDirectByteBuf(byteBufAllocator, n2, n3);
    }

    private UnsafeByteBufUtil() {
    }
}

