/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractReferenceCountedByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class UnpooledDirectByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ByteBufAllocator alloc;
    ByteBuffer buffer;
    private ByteBuffer tmpNioBuf;
    private int capacity;
    private boolean doNotFree;

    public UnpooledDirectByteBuf(ByteBufAllocator byteBufAllocator, int n2, int n3) {
        super(n3);
        ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        ObjectUtil.checkPositiveOrZero(n2, "initialCapacity");
        ObjectUtil.checkPositiveOrZero(n3, "maxCapacity");
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity(%d) > maxCapacity(%d)", n2, n3));
        }
        this.alloc = byteBufAllocator;
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        unpooledDirectByteBuf.setByteBuffer(unpooledDirectByteBuf.allocateDirect(n2), false);
    }

    protected ByteBuffer allocateDirect(int n2) {
        return ByteBuffer.allocateDirect(n2);
    }

    protected void freeDirect(ByteBuffer byteBuffer) {
        PlatformDependent.freeDirectBuffer(byteBuffer);
    }

    void setByteBuffer(ByteBuffer byteBuffer, boolean bl) {
        ByteBuffer byteBuffer2;
        if (bl && (byteBuffer2 = this.buffer) != null) {
            if (this.doNotFree) {
                this.doNotFree = false;
            } else {
                this.freeDirect(byteBuffer2);
            }
        }
        this.buffer = byteBuffer;
        this.tmpNioBuf = null;
        this.capacity = byteBuffer.remaining();
    }

    public boolean isDirect() {
        return true;
    }

    public int capacity() {
        return this.capacity;
    }

    public ByteBuf capacity(int n2) {
        this.checkNewCapacity(n2);
        int n3 = this.capacity;
        if (n2 == n3) {
            return this;
        }
        if (n2 <= n3) {
            this.trimIndicesToCapacity(n2);
            n3 = n2;
        }
        ByteBuffer byteBuffer = this.buffer;
        ByteBuffer byteBuffer2 = this.allocateDirect(n2);
        byteBuffer.position(0).limit(n3);
        byteBuffer2.position(0).limit(n3);
        byteBuffer2.put(byteBuffer).clear();
        this.setByteBuffer(byteBuffer2, true);
        return this;
    }

    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException("direct buffer");
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException("direct buffer");
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public byte getByte(int n2) {
        this.ensureAccessible();
        return this._getByte(n2);
    }

    protected byte _getByte(int n2) {
        return this.buffer.get(n2);
    }

    public short getShort(int n2) {
        this.ensureAccessible();
        return this._getShort(n2);
    }

    protected short _getShort(int n2) {
        return this.buffer.getShort(n2);
    }

    protected short _getShortLE(int n2) {
        return ByteBufUtil.swapShort(this.buffer.getShort(n2));
    }

    public int getUnsignedMedium(int n2) {
        this.ensureAccessible();
        return this._getUnsignedMedium(n2);
    }

    protected int _getUnsignedMedium(int n2) {
        return (this.getByte(n2) & 0xFF) << 16 | (this.getByte(n2 + 1) & 0xFF) << 8 | this.getByte(n2 + 2) & 0xFF;
    }

    public int getInt(int n2) {
        this.ensureAccessible();
        return this._getInt(n2);
    }

    protected int _getInt(int n2) {
        return this.buffer.getInt(n2);
    }

    protected int _getIntLE(int n2) {
        return ByteBufUtil.swapInt(this.buffer.getInt(n2));
    }

    public long getLong(int n2) {
        this.ensureAccessible();
        return this._getLong(n2);
    }

    protected long _getLong(int n2) {
        return this.buffer.getLong(n2);
    }

    public ByteBuf getBytes(int n2, ByteBuf byteBufferArray, int n3, int n4) {
        this.checkDstIndex(n2, n4, n3, byteBufferArray.capacity());
        if (byteBufferArray.hasArray()) {
            this.getBytes(n2, byteBufferArray.array(), byteBufferArray.arrayOffset() + n3, n4);
        } else if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.getBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBufferArray.setBytes(n3, this, n2, n4);
        }
        return this;
    }

    public ByteBuf getBytes(int n2, byte[] byArray, int n3, int n4) {
        this.getBytes(n2, byArray, n3, n4, false);
        return this;
    }

    void getBytes(int n2, byte[] byArray, int n3, int n4, boolean bl) {
        this.checkDstIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.get(byArray, n3, n4);
    }

    public ByteBuf readBytes(byte[] byArray, int n2, int n3) {
        this.checkReadableBytes(n3);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, byArray, n2, n3, true);
        this.readerIndex += n3;
        return this;
    }

    public ByteBuf getBytes(int n2, ByteBuffer byteBuffer) {
        this.getBytes(n2, byteBuffer, false);
        return this;
    }

    void getBytes(int n2, ByteBuffer byteBuffer, boolean bl) {
        this.checkIndex(n2, byteBuffer.remaining());
        ByteBuffer byteBuffer2 = bl ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer.put(byteBuffer2);
    }

    public ByteBuf setByte(int n2, int n3) {
        this.ensureAccessible();
        this._setByte(n2, n3);
        return this;
    }

    protected void _setByte(int n2, int n3) {
        this.buffer.put(n2, (byte)n3);
    }

    public ByteBuf setShort(int n2, int n3) {
        this.ensureAccessible();
        this._setShort(n2, n3);
        return this;
    }

    protected void _setShort(int n2, int n3) {
        this.buffer.putShort(n2, (short)n3);
    }

    protected void _setShortLE(int n2, int n3) {
        this.buffer.putShort(n2, ByteBufUtil.swapShort((short)n3));
    }

    public ByteBuf setMedium(int n2, int n3) {
        this.ensureAccessible();
        this._setMedium(n2, n3);
        return this;
    }

    protected void _setMedium(int n2, int n3) {
        this.setByte(n2, (byte)(n3 >>> 16));
        this.setByte(n2 + 1, (byte)(n3 >>> 8));
        this.setByte(n2 + 2, (byte)n3);
    }

    protected void _setMediumLE(int n2, int n3) {
        this.setByte(n2, (byte)n3);
        this.setByte(n2 + 1, (byte)(n3 >>> 8));
        this.setByte(n2 + 2, (byte)(n3 >>> 16));
    }

    public ByteBuf setInt(int n2, int n3) {
        this.ensureAccessible();
        this._setInt(n2, n3);
        return this;
    }

    protected void _setInt(int n2, int n3) {
        this.buffer.putInt(n2, n3);
    }

    public ByteBuf setLong(int n2, long l2) {
        this.ensureAccessible();
        this._setLong(n2, l2);
        return this;
    }

    protected void _setLong(int n2, long l2) {
        this.buffer.putLong(n2, l2);
    }

    public ByteBuf setBytes(int n2, ByteBuf byteBufferArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byteBufferArray.capacity());
        if (byteBufferArray.nioBufferCount() > 0) {
            for (ByteBuffer byteBuffer : byteBufferArray.nioBuffers(n3, n4)) {
                int n5 = byteBuffer.remaining();
                this.setBytes(n2, byteBuffer);
                n2 += n5;
            }
        } else {
            byteBufferArray.getBytes(n3, this, n2, n4);
        }
        return this;
    }

    public ByteBuf setBytes(int n2, byte[] byArray, int n3, int n4) {
        this.checkSrcIndex(n2, n4, n3, byArray.length);
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n4);
        byteBuffer.put(byArray, n3, n4);
        return this;
    }

    public ByteBuf setBytes(int n2, ByteBuffer byteBuffer) {
        this.ensureAccessible();
        ByteBuffer byteBuffer2 = this.internalNioBuffer();
        if (byteBuffer == byteBuffer2) {
            byteBuffer = byteBuffer.duplicate();
        }
        byteBuffer2.clear().position(n2).limit(n2 + byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        return this;
    }

    public int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3) throws IOException {
        return this.getBytes(n2, gatheringByteChannel, n3, false);
    }

    private int getBytes(int n2, GatheringByteChannel gatheringByteChannel, int n3, boolean bl) throws IOException {
        this.ensureAccessible();
        if (n3 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = bl ? this.internalNioBuffer() : this.buffer.duplicate();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        return gatheringByteChannel.write(byteBuffer);
    }

    public int readBytes(GatheringByteChannel gatheringByteChannel, int n2) throws IOException {
        this.checkReadableBytes(n2);
        UnpooledDirectByteBuf unpooledDirectByteBuf = this;
        int n3 = unpooledDirectByteBuf.getBytes(unpooledDirectByteBuf.readerIndex, gatheringByteChannel, n2, true);
        this.readerIndex += n3;
        return n3;
    }

    public int setBytes(int n2, ScatteringByteChannel scatteringByteChannel, int n3) throws IOException {
        this.ensureAccessible();
        ByteBuffer byteBuffer = this.internalNioBuffer();
        byteBuffer.clear().position(n2).limit(n2 + n3);
        try {
            return scatteringByteChannel.read(byteBuffer);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    public int nioBufferCount() {
        return 1;
    }

    public ByteBuffer[] nioBuffers(int n2, int n3) {
        return new ByteBuffer[]{this.nioBuffer(n2, n3)};
    }

    public final boolean isContiguous() {
        return true;
    }

    public ByteBuffer internalNioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return (ByteBuffer)this.internalNioBuffer().clear().position(n2).limit(n2 + n3);
    }

    private ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.buffer.duplicate();
        }
        return byteBuffer;
    }

    public ByteBuffer nioBuffer(int n2, int n3) {
        this.checkIndex(n2, n3);
        return ((ByteBuffer)this.buffer.duplicate().position(n2).limit(n2 + n3)).slice();
    }

    protected void deallocate() {
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            return;
        }
        this.buffer = null;
        if (!this.doNotFree) {
            this.freeDirect(byteBuffer);
        }
    }

    public ByteBuf unwrap() {
        return null;
    }
}

