/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.CompositeByteBuf;
import com.appoptics.ext.io.netty.buffer.SimpleLeakAwareByteBuf;
import com.appoptics.ext.io.netty.buffer.WrappedCompositeByteBuf;
import com.appoptics.ext.io.netty.util.ResourceLeakTracker;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleLeakAwareCompositeByteBuf
extends WrappedCompositeByteBuf {
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareCompositeByteBuf(CompositeByteBuf compositeByteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(compositeByteBuf);
        this.leak = ObjectUtil.checkNotNull(resourceLeakTracker, "leak");
    }

    @Override
    public boolean release() {
        ByteBuf byteBuf = this.unwrap();
        if (super.release()) {
            this.closeLeak(byteBuf);
            return true;
        }
        return false;
    }

    private void closeLeak(ByteBuf byteBuf) {
        boolean bl = this.leak.close(byteBuf);
        assert (bl);
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (this.order() == byteOrder) {
            return this;
        }
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.order(byteOrder));
    }

    @Override
    public ByteBuf slice() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.retainedSlice());
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.slice(n2, n3));
    }

    @Override
    public ByteBuf retainedSlice(int n2, int n3) {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.retainedSlice(n2, n3));
    }

    @Override
    public ByteBuf duplicate() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.retainedDuplicate());
    }

    @Override
    public ByteBuf readSlice(int n2) {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.readSlice(n2));
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.readRetainedSlice(n2));
    }

    @Override
    public ByteBuf asReadOnly() {
        SimpleLeakAwareCompositeByteBuf simpleLeakAwareCompositeByteBuf = this;
        return simpleLeakAwareCompositeByteBuf.newLeakAwareByteBuf(super.asReadOnly());
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf) {
        return this.newLeakAwareByteBuf(byteBuf, this.unwrap(), this.leak);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return new SimpleLeakAwareByteBuf(byteBuf, byteBuf2, resourceLeakTracker);
    }
}

