/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.PooledHeapByteBuf;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.buffer.UnsafeByteBufUtil;
import com.appoptics.ext.io.netty.buffer.UnsafeHeapSwappedByteBuf;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final ObjectPool<PooledUnsafeHeapByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledUnsafeHeapByteBuf>(){

        @Override
        public final PooledUnsafeHeapByteBuf newObject(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle) {
            return new PooledUnsafeHeapByteBuf(handle, 0);
        }
    });

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int n2) {
        PooledUnsafeHeapByteBuf pooledUnsafeHeapByteBuf = RECYCLER.get();
        pooledUnsafeHeapByteBuf.reuse(n2);
        return pooledUnsafeHeapByteBuf;
    }

    private PooledUnsafeHeapByteBuf(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle, int n2) {
        super((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle, n2);
    }

    @Override
    protected final byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected final void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected final void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected final void _setShortLE(int n2, int n3) {
        UnsafeByteBufUtil.setShortLE((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected final void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected final void _setMediumLE(int n2, int n3) {
        UnsafeByteBufUtil.setMediumLE((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected final void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected final void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(n2), l2);
    }

    @Override
    public final ByteBuf setZero(int n2, int n3) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(n2, n3);
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n2), n3);
            return this;
        }
        return super.setZero(n2, n3);
    }

    @Override
    public final ByteBuf writeZero(int n2) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.ensureWritable(n2);
            int n3 = this.writerIndex;
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n3), n2);
            this.writerIndex = n3 + n2;
            return this;
        }
        return super.writeZero(n2);
    }

    @Override
    @Deprecated
    protected final SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

