/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.AbstractByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.PooledByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.UnpooledByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.UnpooledDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import com.appoptics.ext.io.netty.buffer.WrappedByteBuf;
import com.appoptics.ext.io.netty.buffer.WrappedCompositeByteBuf;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.ByteProcessor;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.concurrent.FastThreadLocal;
import com.appoptics.ext.io.netty.util.internal.MathUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectPool;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import com.appoptics.ext.io.netty.util.internal.StringUtil;
import com.appoptics.ext.io.netty.util.internal.SystemPropertyUtil;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLogger;
import com.appoptics.ext.io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.Locale;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int n2) {
        if (n2 <= 1024) {
            return BYTE_ARRAYS.get();
        }
        return PlatformDependent.allocateUninitializedArray(n2);
    }

    public static String hexDump(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.hexDump(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n2, int n3) {
        return HexUtil.hexDump(byteBuf, n2, n3);
    }

    public static String hexDump(byte[] byArray, int n2, int n3) {
        return HexUtil.hexDump(byArray, n2, n3);
    }

    public static boolean ensureWritableSuccess(int n2) {
        return n2 == 0 || n2 == 2;
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        int n3 = n2 >>> 2;
        n2 &= 3;
        int n4 = 1;
        int n5 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            while (n3 > 0) {
                n4 = n4 * 31 + byteBuf.getInt(n5);
                n5 += 4;
                --n3;
            }
        } else {
            while (n3 > 0) {
                n4 = n4 * 31 + ByteBufUtil.swapInt(byteBuf.getInt(n5));
                n5 += 4;
                --n3;
            }
        }
        for (n3 = n2; n3 > 0; --n3) {
            n4 = n4 * 31 + byteBuf.getByte(n5++);
        }
        if (n4 == 0) {
            n4 = 1;
        }
        return n4;
    }

    public static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf2.readableBytes() - byteBuf.readableBytes() + 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteBuf byteBuf3 = byteBuf;
            ByteBuf byteBuf4 = byteBuf2;
            if (!ByteBufUtil.equals(byteBuf3, byteBuf3.readerIndex(), byteBuf4, byteBuf4.readerIndex() + i2, byteBuf.readableBytes())) continue;
            return byteBuf2.readerIndex() + i2;
        }
        return -1;
    }

    public static boolean equals(ByteBuf byteBuf, int n2, ByteBuf byteBuf2, int n3, int n4) {
        if (n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("All indexes and lengths must be non-negative");
        }
        if (byteBuf.writerIndex() - n4 < n2 || byteBuf2.writerIndex() - n4 < n3) {
            return false;
        }
        int n5 = n4 >>> 3;
        n4 &= 7;
        if (byteBuf.order() == byteBuf2.order()) {
            while (n5 > 0) {
                if (byteBuf.getLong(n2) != byteBuf2.getLong(n3)) {
                    return false;
                }
                n2 += 8;
                n3 += 8;
                --n5;
            }
        } else {
            while (n5 > 0) {
                if (byteBuf.getLong(n2) != ByteBufUtil.swapLong(byteBuf2.getLong(n3))) {
                    return false;
                }
                n2 += 8;
                n3 += 8;
                --n5;
            }
        }
        for (n5 = n4; n5 > 0; --n5) {
            if (byteBuf.getByte(n2) != byteBuf2.getByte(n3)) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2 = byteBuf.readableBytes();
        if (n2 != byteBuf2.readableBytes()) {
            return false;
        }
        ByteBuf byteBuf3 = byteBuf;
        ByteBuf byteBuf4 = byteBuf2;
        return ByteBufUtil.equals(byteBuf3, byteBuf3.readerIndex(), byteBuf4, byteBuf4.readerIndex(), n2);
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n2;
        int n3 = byteBuf.readableBytes();
        int n4 = byteBuf2.readableBytes();
        int n5 = Math.min(n3, n4);
        int n6 = n5 >>> 2;
        n5 &= 3;
        int n7 = byteBuf.readerIndex();
        int n8 = byteBuf2.readerIndex();
        if (n6 > 0) {
            long l2;
            n2 = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            n6 <<= 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n7, n8, n6) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n7, n8, n6);
            } else {
                long l3 = l2 = n2 != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n7, n8, n6) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n7, n8, n6);
            }
            if (l2 != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, l2));
            }
            n7 += n6;
            n8 += n6;
        }
        n2 = n7 + n5;
        while (n7 < n2) {
            int n9 = byteBuf.getUnsignedByte(n7) - byteBuf2.getUnsignedByte(n8);
            if (n9 != 0) {
                return n9;
            }
            ++n7;
            ++n8;
        }
        return n3 - n4;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = byteBuf.getUnsignedInt(n2) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = byteBuf.getUnsignedIntLE(n2) - byteBuf2.getUnsignedIntLE(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = byteBuf.getUnsignedInt(n2) - byteBuf2.getUnsignedIntLE(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n2, int n3, int n4) {
        n4 = n2 + n4;
        while (n2 < n4) {
            long l2 = byteBuf.getUnsignedIntLE(n2) - byteBuf2.getUnsignedInt(n3);
            if (l2 != 0L) {
                return l2;
            }
            n2 += 4;
            n3 += 4;
        }
        return 0L;
    }

    public static short swapShort(short s2) {
        return Short.reverseBytes(s2);
    }

    public static int swapMedium(int n2) {
        if (((n2 = n2 << 16 & 0xFF0000 | n2 & 0xFF00 | n2 >>> 16 & 0xFF) & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    public static int swapInt(int n2) {
        return Integer.reverseBytes(n2);
    }

    public static long swapLong(long l2) {
        return Long.reverseBytes(l2);
    }

    public static ByteBuf writeShortBE(ByteBuf byteBuf, int n2) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.writeShort(n2);
        }
        return byteBuf.writeShortLE(n2);
    }

    public static ByteBuf setShortBE(ByteBuf byteBuf, int n2, int n3) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.setShort(n2, n3);
        }
        return byteBuf.setShortLE(n2, n3);
    }

    public static ByteBuf writeMediumBE(ByteBuf byteBuf, int n2) {
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            return byteBuf.writeMedium(n2);
        }
        return byteBuf.writeMediumLE(n2);
    }

    public static ByteBuf writeUtf8(ByteBufAllocator object, CharSequence charSequence) {
        object = object.buffer(ByteBufUtil.utf8MaxBytes(charSequence));
        ByteBufUtil.writeUtf8((ByteBuf)object, charSequence);
        return object;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence) {
        int n2;
        int n3 = n2 = charSequence.length();
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, n3, ByteBufUtil.utf8MaxBytes(n3));
    }

    private static int reserveAndWriteUtf8Seq(ByteBuf byteBuf, CharSequence charSequence, int n2, int n3, int n4) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n4);
                AbstractByteBuf abstractByteBuf2 = abstractByteBuf;
                int n5 = ByteBufUtil.writeUtf8(abstractByteBuf2, abstractByteBuf2.writerIndex, charSequence, n2, n3);
                abstractByteBuf.writerIndex += n5;
                return n5;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.subSequence(n2, n3).toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3) {
        return ByteBufUtil.writeUtf8(abstractByteBuf, n2, charSequence, 0, n3);
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3, int n4) {
        int n5 = n2;
        while (n3 < n4) {
            char c2 = charSequence.charAt(n3);
            if (c2 < '\u0080') {
                abstractByteBuf._setByte(n2++, (byte)c2);
            } else if (c2 < '\u0800') {
                abstractByteBuf._setByte(n2++, (byte)(0xC0 | c2 >> 6));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
            } else if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    abstractByteBuf._setByte(n2++, 63);
                } else {
                    if (++n3 == n4) {
                        abstractByteBuf._setByte(n2++, 63);
                        break;
                    }
                    n2 = ByteBufUtil.writeUtf8Surrogate(abstractByteBuf, n2, c2, charSequence.charAt(n3));
                }
            } else {
                abstractByteBuf._setByte(n2++, (byte)(0xE0 | c2 >> 12));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 >> 6 & 0x3F));
                abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
            }
            ++n3;
        }
        return n2 - n5;
    }

    private static int writeUtf8Surrogate(AbstractByteBuf abstractByteBuf, int n2, char c2, char c3) {
        if (!Character.isLowSurrogate(c3)) {
            abstractByteBuf._setByte(n2++, 63);
            abstractByteBuf._setByte(n2++, Character.isHighSurrogate(c3) ? 63 : (int)c3);
            return n2;
        }
        c2 = (char)Character.toCodePoint(c2, c3);
        abstractByteBuf._setByte(n2++, (byte)(0xF0 | c2 >> 18));
        abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 >> 12 & 0x3F));
        abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 >> 6 & 0x3F));
        abstractByteBuf._setByte(n2++, (byte)(0x80 | c2 & 0x3F));
        return n2;
    }

    public static int utf8MaxBytes(int n2) {
        return n2 * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence charSequence) {
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence) {
        return ByteBufUtil.utf8ByteCount(charSequence, 0, charSequence.length());
    }

    private static int utf8ByteCount(CharSequence charSequence, int n2, int n3) {
        int n4;
        if (charSequence instanceof AsciiString) {
            return n3 - n2;
        }
        for (n4 = n2; n4 < n3 && charSequence.charAt(n4) < '\u0080'; ++n4) {
        }
        if (n4 < n3) {
            return n4 - n2 + ByteBufUtil.utf8BytesNonAscii(charSequence, n4, n3);
        }
        return n4 - n2;
    }

    private static int utf8BytesNonAscii(CharSequence charSequence, int n2, int n3) {
        int n4 = 0;
        while (n2 < n3) {
            char c2 = charSequence.charAt(n2);
            if (c2 < '\u0800') {
                n4 += (127 - c2 >>> 31) + 1;
            } else if (StringUtil.isSurrogate(c2)) {
                if (!Character.isHighSurrogate(c2)) {
                    ++n4;
                } else {
                    if (++n2 == n3) {
                        ++n4;
                        break;
                    }
                    n4 = !Character.isLowSurrogate(charSequence.charAt(n2)) ? (n4 += 2) : (n4 += 4);
                }
            } else {
                n4 += 3;
            }
            ++n2;
        }
        return n4;
    }

    public static ByteBuf writeAscii(ByteBufAllocator object, CharSequence charSequence) {
        object = object.buffer(charSequence.length());
        ByteBufUtil.writeAscii((ByteBuf)object, charSequence);
        return object;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        int n2 = charSequence.length();
        if (!(charSequence instanceof AsciiString)) {
            while (true) {
                if (byteBuf instanceof WrappedCompositeByteBuf) {
                    byteBuf = byteBuf.unwrap();
                    continue;
                }
                if (byteBuf instanceof AbstractByteBuf) {
                    AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                    abstractByteBuf.ensureWritable0(n2);
                    AbstractByteBuf abstractByteBuf2 = abstractByteBuf;
                    int n3 = ByteBufUtil.writeAscii(abstractByteBuf2, abstractByteBuf2.writerIndex, charSequence, n2);
                    abstractByteBuf.writerIndex += n3;
                    return n3;
                }
                if (!(byteBuf instanceof WrappedByteBuf)) break;
                byteBuf = byteBuf.unwrap();
            }
            byte[] byArray = charSequence.toString().getBytes(CharsetUtil.US_ASCII);
            byteBuf.writeBytes(byArray);
            return byArray.length;
        }
        AsciiString asciiString = (AsciiString)charSequence;
        byteBuf.writeBytes(asciiString.array(), asciiString.arrayOffset(), n2);
        return n2;
    }

    static int writeAscii(AbstractByteBuf abstractByteBuf, int n2, CharSequence charSequence, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            abstractByteBuf._setByte(n2++, AsciiString.c2b(charSequence.charAt(i2)));
        }
        return n3;
    }

    static ByteBuf encodeString0(ByteBufAllocator object, boolean bl, CharBuffer object2, Charset object3, int n2) {
        object3 = CharsetUtil.encoder((Charset)object3);
        n2 = (int)((double)((Buffer)object2).remaining() * (double)((CharsetEncoder)object3).maxBytesPerChar()) + n2;
        boolean bl2 = true;
        object = bl ? object.heapBuffer(n2) : object.buffer(n2);
        try {
            Object object4 = object;
            Object object5 = ((ByteBuf)object4).internalNioBuffer(((ByteBuf)object4).readerIndex(), n2);
            n2 = ((Buffer)object5).position();
            object2 = ((CharsetEncoder)object3).encode((CharBuffer)object2, (ByteBuffer)object5, true);
            if (!((CoderResult)object2).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            if (!((CoderResult)(object2 = ((CharsetEncoder)object3).flush((ByteBuffer)object5))).isUnderflow()) {
                ((CoderResult)object2).throwException();
            }
            Object object6 = object;
            ((ByteBuf)object6).writerIndex(((ByteBuf)object6).writerIndex() + ((Buffer)object5).position() - n2);
            bl2 = false;
            object5 = object;
            return object5;
        }
        catch (CharacterCodingException characterCodingException) {
            try {
                throw new IllegalStateException(characterCodingException);
            }
            catch (Throwable throwable) {
                if (bl2) {
                    object.release();
                }
                throw throwable;
            }
        }
    }

    static String decodeString(ByteBuf byteBuf, int n2, int n3, Charset charset) {
        int n4;
        byte[] byArray;
        if (n3 == 0) {
            return "";
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n4 = byteBuf.arrayOffset() + n2;
        } else {
            byArray = ByteBufUtil.threadLocalTempArray(n3);
            n4 = 0;
            byteBuf.getBytes(n2, byArray, 0, n3);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(byArray, 0, n4, n3);
        }
        return new String(byArray, n4, n3, charset);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return ByteBufUtil.getBytes(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n2, int n3) {
        return ByteBufUtil.getBytes(byteBuf, n2, n3, true);
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n2, int n3, boolean bl) {
        int n4 = byteBuf.capacity();
        if (MathUtil.isOutOfBounds(n2, n3, n4)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n2 + ") <= start + length(" + n3 + ") <= buf.capacity(" + n4 + ')');
        }
        if (byteBuf.hasArray()) {
            if (bl || n2 != 0 || n3 != n4) {
                int byArray;
                int n5 = byArray = byteBuf.arrayOffset() + n2;
                return Arrays.copyOfRange(byteBuf.array(), n5, n5 + n3);
            }
            return byteBuf.array();
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n3);
        byteBuf.getBytes(n2, byArray);
        return byArray;
    }

    public static void copy(AsciiString asciiString, ByteBuf byteBuf) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, asciiString.length());
    }

    public static void copy(AsciiString asciiString, int n2, ByteBuf byteBuf, int n3, int n4) {
        if (MathUtil.isOutOfBounds(n2, n4, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n4 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").setBytes(n3, asciiString.array(), n2 + asciiString.arrayOffset(), n4);
    }

    public static void copy(AsciiString asciiString, int n2, ByteBuf byteBuf, int n3) {
        if (MathUtil.isOutOfBounds(n2, n3, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n2 + ") <= srcIdx + length(" + n3 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").writeBytes(asciiString.array(), n2 + asciiString.arrayOffset(), n3);
    }

    private ByteBufUtil() {
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new FastThreadLocal<byte[]>(){

            @Override
            protected final byte[] initialValue() throws Exception {
                return PlatformDependent.allocateUninitializedArray(1024);
            }
        };
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get("com.appoptics.ext.io.netty.allocator.type", PlatformDependent.isAndroid() ? "unpooled" : "pooled");
        if ("unpooled".equals(string = string.toLowerCase(Locale.US).trim())) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.threadLocalDirectBufferSize", 0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("com.appoptics.ext.io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteProcessor(){

            public final boolean process(byte by) {
                return by >= 0;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ThreadLocalDirectByteBuf
    extends UnpooledDirectByteBuf {
        private static final ObjectPool<ThreadLocalDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<ThreadLocalDirectByteBuf>(){

            @Override
            public final ThreadLocalDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
                return new ThreadLocalDirectByteBuf(handle);
            }
        });
        private final ObjectPool.Handle<ThreadLocalDirectByteBuf> handle;

        static ThreadLocalDirectByteBuf newInstance() {
            ThreadLocalDirectByteBuf threadLocalDirectByteBuf = RECYCLER.get();
            threadLocalDirectByteBuf.resetRefCnt();
            return threadLocalDirectByteBuf;
        }

        private ThreadLocalDirectByteBuf(ObjectPool.Handle<ThreadLocalDirectByteBuf> handle) {
            super(UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = handle;
        }

        @Override
        protected final void deallocate() {
            if (this.capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
                return;
            }
            this.clear();
            this.handle.recycle(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ThreadLocalUnsafeDirectByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        private static final ObjectPool<ThreadLocalUnsafeDirectByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<ThreadLocalUnsafeDirectByteBuf>(){

            @Override
            public final ThreadLocalUnsafeDirectByteBuf newObject(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
                return new ThreadLocalUnsafeDirectByteBuf(handle);
            }
        });
        private final ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle;

        static ThreadLocalUnsafeDirectByteBuf newInstance() {
            ThreadLocalUnsafeDirectByteBuf threadLocalUnsafeDirectByteBuf = RECYCLER.get();
            threadLocalUnsafeDirectByteBuf.resetRefCnt();
            return threadLocalUnsafeDirectByteBuf;
        }

        private ThreadLocalUnsafeDirectByteBuf(ObjectPool.Handle<ThreadLocalUnsafeDirectByteBuf> handle) {
            super(UnpooledByteBufAllocator.DEFAULT, 256, Integer.MAX_VALUE);
            this.handle = handle;
        }

        @Override
        protected final void deallocate() {
            if (this.capacity() > THREAD_LOCAL_BUFFER_SIZE) {
                super.deallocate();
                return;
            }
            this.clear();
            this.handle.recycle(this);
        }
    }

    private static final class HexUtil {
        private static final char[] BYTE2CHAR;
        private static final char[] HEXDUMP_TABLE;
        private static final String[] HEXPADDING;
        private static final String[] HEXDUMP_ROWPREFIXES;
        private static final String[] BYTE2HEX;
        private static final String[] BYTEPADDING;

        private static String hexDump(ByteBuf byteBuf, int n2, int n3) {
            ObjectUtil.checkPositiveOrZero(n3, "length");
            if (n3 == 0) {
                return "";
            }
            int n4 = n2 + n3;
            char[] cArray = new char[n3 << 1];
            int n5 = 0;
            while (n2 < n4) {
                System.arraycopy(HEXDUMP_TABLE, byteBuf.getUnsignedByte(n2) << 1, cArray, n5, 2);
                ++n2;
                n5 += 2;
            }
            return new String(cArray);
        }

        private static String hexDump(byte[] byArray, int n2, int n3) {
            ObjectUtil.checkPositiveOrZero(n3, "length");
            if (n3 == 0) {
                return "";
            }
            int n4 = n2 + n3;
            char[] cArray = new char[n3 << 1];
            int n5 = 0;
            while (n2 < n4) {
                System.arraycopy(HEXDUMP_TABLE, (byArray[n2] & 0xFF) << 1, cArray, n5, 2);
                ++n2;
                n5 += 2;
            }
            return new String(cArray);
        }

        static {
            int n2;
            StringBuilder stringBuilder;
            int n3;
            BYTE2CHAR = new char[256];
            HEXDUMP_TABLE = new char[1024];
            HEXPADDING = new String[16];
            HEXDUMP_ROWPREFIXES = new String[4096];
            BYTE2HEX = new String[256];
            BYTEPADDING = new String[16];
            Object object = "0123456789abcdef".toCharArray();
            for (n3 = 0; n3 < 256; ++n3) {
                HexUtil.HEXDUMP_TABLE[n3 << 1] = object[n3 >>> 4 & 0xF];
                HexUtil.HEXDUMP_TABLE[(n3 << 1) + 1] = object[n3 & 0xF];
            }
            for (n3 = 0; n3 < HEXPADDING.length; ++n3) {
                int n4 = HEXPADDING.length - n3;
                stringBuilder = new StringBuilder(n4 * 3);
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuilder.append("   ");
                }
                HexUtil.HEXPADDING[n3] = stringBuilder.toString();
            }
            for (n3 = 0; n3 < HEXDUMP_ROWPREFIXES.length; ++n3) {
                StringBuilder stringBuilder2 = new StringBuilder(12);
                object = stringBuilder2;
                stringBuilder2.append(StringUtil.NEWLINE);
                ((StringBuilder)object).append(Long.toHexString((long)(n3 << 4) & 0xFFFFFFFFL | 0x100000000L));
                Object object2 = object;
                ((StringBuilder)object2).setCharAt(((StringBuilder)object2).length() - 9, '|');
                ((StringBuilder)object).append('|');
                HexUtil.HEXDUMP_ROWPREFIXES[n3] = ((StringBuilder)object).toString();
            }
            for (n3 = 0; n3 < BYTE2HEX.length; ++n3) {
                HexUtil.BYTE2HEX[n3] = " " + StringUtil.byteToHexStringPadded(n3);
            }
            for (n3 = 0; n3 < BYTEPADDING.length; ++n3) {
                int n5 = BYTEPADDING.length - n3;
                stringBuilder = new StringBuilder(n5);
                for (n2 = 0; n2 < n5; ++n2) {
                    stringBuilder.append(' ');
                }
                HexUtil.BYTEPADDING[n3] = stringBuilder.toString();
            }
            for (n3 = 0; n3 < BYTE2CHAR.length; ++n3) {
                if (n3 <= 31 || n3 >= 127) {
                    HexUtil.BYTE2CHAR[n3] = 46;
                    continue;
                }
                int n6 = n3;
                HexUtil.BYTE2CHAR[n6] = (char)n6;
            }
        }
    }
}

