/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ByteBufInputStream
extends InputStream
implements DataInput {
    private final ByteBuf buffer;
    private final int startIndex;
    private final int endIndex;
    private boolean closed;
    private final boolean releaseOnClose;
    private StringBuilder lineBuf;

    public ByteBufInputStream(ByteBuf byteBuf, boolean bl) {
        ByteBuf byteBuf2 = byteBuf;
        this(byteBuf2, byteBuf2.readableBytes(), bl);
    }

    public ByteBufInputStream(ByteBuf byteBuf, int n2, boolean bl) {
        ObjectUtil.checkNotNull(byteBuf, "buffer");
        if (n2 < 0) {
            if (bl) {
                byteBuf.release();
            }
            throw new IllegalArgumentException("length: " + n2);
        }
        if (n2 > byteBuf.readableBytes()) {
            if (bl) {
                byteBuf.release();
            }
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + n2 + ", maximum is " + byteBuf.readableBytes());
        }
        this.releaseOnClose = bl;
        this.buffer = byteBuf;
        this.startIndex = byteBuf.readerIndex();
        this.endIndex = this.startIndex + n2;
        byteBuf.markReaderIndex();
    }

    public void close() throws IOException {
        block3: {
            try {
                super.close();
                if (!this.releaseOnClose || this.closed) break block3;
                this.closed = true;
            }
            catch (Throwable throwable) {
                if (this.releaseOnClose && !this.closed) {
                    this.closed = true;
                    this.buffer.release();
                }
                throw throwable;
            }
            this.buffer.release();
            return;
        }
    }

    public int available() throws IOException {
        return this.endIndex - this.buffer.readerIndex();
    }

    public void mark(int n2) {
        this.buffer.markReaderIndex();
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        int n2 = this.available();
        if (n2 == 0) {
            return -1;
        }
        return this.buffer.readByte() & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.available();
        if (n4 == 0) {
            return -1;
        }
        n3 = Math.min(n4, n3);
        this.buffer.readBytes(byArray, n2, n3);
        return n3;
    }

    public void reset() throws IOException {
        this.buffer.resetReaderIndex();
    }

    public long skip(long l2) throws IOException {
        if (l2 > Integer.MAX_VALUE) {
            return this.skipBytes(Integer.MAX_VALUE);
        }
        return this.skipBytes((int)l2);
    }

    public boolean readBoolean() throws IOException {
        this.checkAvailable(1);
        return this.read() != 0;
    }

    public byte readByte() throws IOException {
        int n2 = this.available();
        if (n2 == 0) {
            throw new EOFException();
        }
        return this.buffer.readByte();
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        this.checkAvailable(n3);
        this.buffer.readBytes(byArray, n2, n3);
    }

    public int readInt() throws IOException {
        this.checkAvailable(4);
        return this.buffer.readInt();
    }

    public String readLine() throws IOException {
        int n2 = this.available();
        if (n2 == 0) {
            return null;
        }
        if (this.lineBuf != null) {
            this.lineBuf.setLength(0);
        }
        block4: while (true) {
            short s2 = this.buffer.readUnsignedByte();
            --n2;
            switch (s2) {
                case 10: {
                    break block4;
                }
                case 13: {
                    if (n2 <= 0 || (char)this.buffer.getUnsignedByte(this.buffer.readerIndex()) != '\n') break block4;
                    this.buffer.skipBytes(1);
                    break block4;
                }
                default: {
                    if (this.lineBuf == null) {
                        this.lineBuf = new StringBuilder();
                    }
                    this.lineBuf.append((char)s2);
                    if (n2 > 0) continue block4;
                }
            }
            break;
        }
        if (this.lineBuf != null && this.lineBuf.length() > 0) {
            return this.lineBuf.toString();
        }
        return "";
    }

    public long readLong() throws IOException {
        this.checkAvailable(8);
        return this.buffer.readLong();
    }

    public short readShort() throws IOException {
        this.checkAvailable(2);
        return this.buffer.readShort();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public int skipBytes(int n2) throws IOException {
        n2 = Math.min(this.available(), n2);
        this.buffer.skipBytes(n2);
        return n2;
    }

    private void checkAvailable(int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("fieldSize cannot be a negative number");
        }
        if (n2 > this.available()) {
            throw new EOFException("fieldSize is too long! Length is " + n2 + ", but maximum is " + this.available());
        }
    }
}

