/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.netty.buffer;

import com.appoptics.ext.io.netty.buffer.AbstractByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.SwappedByteBuf;
import com.appoptics.ext.io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;

abstract class AbstractUnsafeSwappedByteBuf
extends SwappedByteBuf {
    private final boolean nativeByteOrder;
    private final AbstractByteBuf wrapped;

    AbstractUnsafeSwappedByteBuf(AbstractByteBuf abstractByteBuf) {
        super(abstractByteBuf);
        assert (PlatformDependent.isUnaligned());
        this.wrapped = abstractByteBuf;
        this.nativeByteOrder = PlatformDependent.BIG_ENDIAN_NATIVE_ORDER == (this.order() == ByteOrder.BIG_ENDIAN);
    }

    public final long getLong(int n2) {
        this.wrapped.checkIndex(n2, 8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        long l2 = abstractUnsafeSwappedByteBuf._getLong(abstractUnsafeSwappedByteBuf.wrapped, n2);
        if (this.nativeByteOrder) {
            return l2;
        }
        return Long.reverseBytes(l2);
    }

    public final long getUnsignedInt(int n2) {
        return (long)this.getInt(n2) & 0xFFFFFFFFL;
    }

    public final int getInt(int n2) {
        this.wrapped.checkIndex(n2, 4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        n2 = abstractUnsafeSwappedByteBuf._getInt(abstractUnsafeSwappedByteBuf.wrapped, n2);
        if (this.nativeByteOrder) {
            return n2;
        }
        return Integer.reverseBytes(n2);
    }

    public final int getUnsignedShort(int n2) {
        return this.getShort(n2) & 0xFFFF;
    }

    public final short getShort(int n2) {
        this.wrapped.checkIndex(n2, 2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        n2 = abstractUnsafeSwappedByteBuf._getShort(abstractUnsafeSwappedByteBuf.wrapped, n2);
        if (this.nativeByteOrder) {
            return (short)n2;
        }
        return Short.reverseBytes((short)n2);
    }

    public final ByteBuf setShort(int n2, int n3) {
        this.wrapped.checkIndex(n2, 2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setShort(abstractUnsafeSwappedByteBuf.wrapped, n2, this.nativeByteOrder ? (short)n3 : Short.reverseBytes((short)n3));
        return this;
    }

    public final ByteBuf setInt(int n2, int n3) {
        this.wrapped.checkIndex(n2, 4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setInt(abstractUnsafeSwappedByteBuf.wrapped, n2, this.nativeByteOrder ? n3 : Integer.reverseBytes(n3));
        return this;
    }

    public final ByteBuf setLong(int n2, long l2) {
        this.wrapped.checkIndex(n2, 8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setLong(abstractUnsafeSwappedByteBuf.wrapped, n2, this.nativeByteOrder ? l2 : Long.reverseBytes(l2));
        return this;
    }

    public final ByteBuf writeShort(int n2) {
        this.wrapped.ensureWritable0(2);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setShort(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? (short)n2 : Short.reverseBytes((short)n2));
        this.wrapped.writerIndex += 2;
        return this;
    }

    public final ByteBuf writeInt(int n2) {
        this.wrapped.ensureWritable0(4);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setInt(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? n2 : Integer.reverseBytes(n2));
        this.wrapped.writerIndex += 4;
        return this;
    }

    public final ByteBuf writeLong(long l2) {
        this.wrapped.ensureWritable0(8);
        AbstractUnsafeSwappedByteBuf abstractUnsafeSwappedByteBuf = this;
        abstractUnsafeSwappedByteBuf._setLong(abstractUnsafeSwappedByteBuf.wrapped, this.wrapped.writerIndex, this.nativeByteOrder ? l2 : Long.reverseBytes(l2));
        this.wrapped.writerIndex += 8;
        return this;
    }

    public final ByteBuf writeChar(int n2) {
        this.writeShort(n2);
        return this;
    }

    protected abstract short _getShort(AbstractByteBuf var1, int var2);

    protected abstract int _getInt(AbstractByteBuf var1, int var2);

    protected abstract long _getLong(AbstractByteBuf var1, int var2);

    protected abstract void _setShort(AbstractByteBuf var1, int var2, short var3);

    protected abstract void _setInt(AbstractByteBuf var1, int var2, int var3);

    protected abstract void _setLong(AbstractByteBuf var1, int var2, long var3);
}

