/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.a.c;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

class WriteQueue {
    private final Runnable later = new Runnable(){

        public void run() {
            WriteQueue.this.flush();
        }
    };
    private final Channel channel;
    private final Queue<QueuedCommand> queue;
    private final AtomicBoolean scheduled = new AtomicBoolean();

    public WriteQueue(Channel channel) {
        this.channel = b.a(channel, (Object)"channel");
        this.queue = new ConcurrentLinkedQueue<QueuedCommand>();
    }

    void scheduleFlush() {
        if (this.scheduled.compareAndSet(false, true)) {
            this.channel.eventLoop().execute(this.later);
        }
    }

    ChannelFuture enqueue(QueuedCommand queuedCommand, boolean bl) {
        b.a(queuedCommand.promise() == null, (Object)"promise must not be set on command");
        ChannelPromise channelPromise = this.channel.newPromise();
        queuedCommand.promise(channelPromise);
        this.queue.add(queuedCommand);
        if (bl) {
            this.scheduleFlush();
        }
        return channelPromise;
    }

    void enqueue(Runnable runnable, boolean bl) {
        this.queue.add(new RunnableCommand(runnable));
        if (bl) {
            this.scheduleFlush();
        }
    }

    void drainNow() {
        b.b(this.channel.eventLoop().inEventLoop(), "must be on the event loop");
        if (this.queue.peek() == null) {
            return;
        }
        this.flush();
    }

    private void flush() {
        block12: {
            c.a("WriteQueue.periodicFlush");
            try {
                QueuedCommand queuedCommand;
                int n2 = 0;
                boolean bl = false;
                while ((queuedCommand = this.queue.poll()) != null) {
                    queuedCommand.run(this.channel);
                    if (++n2 != 128) continue;
                    n2 = 0;
                    c.a("WriteQueue.flush0");
                    try {
                        this.channel.flush();
                    }
                    finally {
                        c.b("WriteQueue.flush0");
                    }
                    bl = true;
                }
                if (n2 == 0 && bl) break block12;
                c.a("WriteQueue.flush1");
                try {
                    this.channel.flush();
                }
                finally {
                    c.b("WriteQueue.flush1");
                }
            }
            catch (Throwable throwable) {
                c.b("WriteQueue.periodicFlush");
                this.scheduled.set(false);
                if (!this.queue.isEmpty()) {
                    this.scheduleFlush();
                }
                throw throwable;
            }
        }
        c.b("WriteQueue.periodicFlush");
        this.scheduled.set(false);
        if (!this.queue.isEmpty()) {
            this.scheduleFlush();
            return;
        }
    }

    static interface QueuedCommand {
        public ChannelPromise promise();

        public void promise(ChannelPromise var1);

        public void run(Channel var1);
    }

    static abstract class AbstractQueuedCommand
    implements QueuedCommand {
        private ChannelPromise promise;
        private final b link = c.b();

        AbstractQueuedCommand() {
        }

        public final void promise(ChannelPromise channelPromise) {
            this.promise = channelPromise;
        }

        public final ChannelPromise promise() {
            return this.promise;
        }

        public final void run(Channel channel) {
            AbstractQueuedCommand abstractQueuedCommand = this;
            channel.write(abstractQueuedCommand, abstractQueuedCommand.promise);
        }

        public b getLink() {
            return this.link;
        }
    }

    private static class RunnableCommand
    implements QueuedCommand {
        private final Runnable runnable;
        private final b link = c.b();

        public RunnableCommand(Runnable runnable) {
            this.runnable = runnable;
        }

        public final void promise(ChannelPromise channelPromise) {
            throw new UnsupportedOperationException();
        }

        public final ChannelPromise promise() {
            throw new UnsupportedOperationException();
        }

        public final void run(Channel channel) {
            this.runnable.run();
        }
    }
}

