/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.InternalMetadata;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.SharedResourceHolder;
import com.appoptics.ext.io.grpc.internal.TransportFrameUtil;
import com.appoptics.ext.io.grpc.netty.GrpcHttp2HeadersUtils;
import com.appoptics.ext.io.grpc.netty.GrpcHttp2OutboundHeaders;
import com.appoptics.ext.io.netty.buffer.ByteBufAllocator;
import com.appoptics.ext.io.netty.buffer.PooledByteBufAllocator;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFactory;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.EventLoopGroup;
import com.appoptics.ext.io.netty.channel.ReflectiveChannelFactory;
import com.appoptics.ext.io.netty.channel.ServerChannel;
import com.appoptics.ext.io.netty.channel.nio.NioEventLoopGroup;
import com.appoptics.ext.io.netty.channel.socket.nio.NioServerSocketChannel;
import com.appoptics.ext.io.netty.channel.socket.nio.NioSocketChannel;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.NettyRuntime;
import com.appoptics.ext.io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Utils {
    private static final Logger logger = Logger.getLogger(Utils.class.getName());
    public static final AsciiString STATUS_OK = AsciiString.of("200");
    public static final AsciiString HTTP_METHOD = AsciiString.of("POST");
    public static final AsciiString HTTP_GET_METHOD = AsciiString.of("GET");
    public static final AsciiString HTTPS = AsciiString.of("https");
    public static final AsciiString HTTP = AsciiString.of("http");
    public static final AsciiString CONTENT_TYPE_HEADER = AsciiString.of(GrpcUtil.CONTENT_TYPE_KEY.name());
    public static final AsciiString CONTENT_TYPE_GRPC = AsciiString.of("application/grpc");
    public static final AsciiString TE_HEADER = AsciiString.of(GrpcUtil.TE_HEADER.name());
    public static final AsciiString TE_TRAILERS = AsciiString.of("trailers");
    public static final AsciiString USER_AGENT = AsciiString.of(GrpcUtil.USER_AGENT_KEY.name());
    public static final SharedResourceHolder.Resource<EventLoopGroup> NIO_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-nio-boss-ELG", EventLoopGroupType.NIO);
    public static final SharedResourceHolder.Resource<EventLoopGroup> NIO_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-nio-worker-ELG", EventLoopGroupType.NIO);
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP;
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP;
    public static final ChannelFactory<? extends ServerChannel> DEFAULT_SERVER_CHANNEL_FACTORY;
    public static final Class<? extends Channel> DEFAULT_CLIENT_CHANNEL_TYPE;
    private static final Constructor<? extends EventLoopGroup> EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR;

    public static ByteBufAllocator getByteBufAllocator(boolean bl) {
        if (Boolean.parseBoolean(System.getProperty("com.appoptics.ext.io.grpc.netty.useCustomAllocator", "true"))) {
            boolean bl2 = PooledByteBufAllocator.defaultPreferDirect();
            logger.log(Level.FINE, String.format("Using custom allocator: forceHeapBuffer=%s, defaultPreferDirect=%s", bl, bl2));
            if (bl || !bl2) {
                return ByteBufAllocatorPreferHeapHolder.allocator;
            }
            return ByteBufAllocatorPreferDirectHolder.allocator;
        }
        logger.log(Level.FINE, "Using default allocator");
        return ByteBufAllocator.DEFAULT;
    }

    private static ByteBufAllocator createByteBufAllocator(boolean bl) {
        int n2;
        logger.log(Level.FINE, "Creating allocator, preferDirect=" + bl);
        if (System.getProperty("com.appoptics.ext.io.netty.allocator.maxOrder") == null) {
            n2 = 8;
            logger.log(Level.FINE, "Forcing maxOrder=" + 8);
        } else {
            n2 = PooledByteBufAllocator.defaultMaxOrder();
            logger.log(Level.FINE, "Using default maxOrder=" + n2);
        }
        return new PooledByteBufAllocator(bl, PooledByteBufAllocator.defaultNumHeapArena(), bl ? PooledByteBufAllocator.defaultNumDirectArena() : 0, PooledByteBufAllocator.defaultPageSize(), n2, PooledByteBufAllocator.defaultTinyCacheSize(), PooledByteBufAllocator.defaultSmallCacheSize(), PooledByteBufAllocator.defaultNormalCacheSize(), PooledByteBufAllocator.defaultUseCacheForAllThreads());
    }

    public static Metadata convertHeaders(Http2Headers http2Headers) {
        if (http2Headers instanceof GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders) {
            http2Headers = (GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers;
            return InternalMetadata.newMetadata(((GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers).numHeaders(), ((GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers).namesAndValues());
        }
        return InternalMetadata.newMetadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(Http2Headers object) {
        byte[][] byArrayArray = new byte[object.size() << 1][];
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            byArrayArray[n2++] = Utils.bytes((CharSequence)entry.getKey());
            byArrayArray[n2++] = Utils.bytes((CharSequence)entry.getValue());
        }
        return TransportFrameUtil.toRawSerializedHeaders(byArrayArray);
    }

    private static byte[] bytes(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            if (((AsciiString)(charSequence = (AsciiString)charSequence)).isEntireArrayUsed()) {
                return ((AsciiString)charSequence).array();
            }
            return ((AsciiString)charSequence).toByteArray();
        }
        return charSequence.toString().getBytes(CharsetUtil.UTF_8);
    }

    public static Http2Headers convertClientHeaders(Metadata metadata, AsciiString asciiString, AsciiString asciiString2, AsciiString asciiString3, AsciiString asciiString4, AsciiString asciiString5) {
        b.a(asciiString2, (Object)"defaultPath");
        b.a(asciiString3, (Object)"authority");
        b.a(asciiString4, (Object)"method");
        metadata.discardAll(GrpcUtil.CONTENT_TYPE_KEY);
        metadata.discardAll(GrpcUtil.TE_HEADER);
        metadata.discardAll(GrpcUtil.USER_AGENT_KEY);
        return GrpcHttp2OutboundHeaders.clientRequestHeaders(TransportFrameUtil.toHttp2Headers(metadata), asciiString3, asciiString2, asciiString4, asciiString, asciiString5);
    }

    public static Metadata convertTrailers(Http2Headers http2Headers) {
        if (http2Headers instanceof GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders) {
            http2Headers = (GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers;
            return InternalMetadata.newMetadata(((GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers).numHeaders(), ((GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers).namesAndValues());
        }
        return InternalMetadata.newMetadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Status statusFromThrowable(Throwable throwable) {
        Object object = Status.fromThrowable(throwable);
        if (((Status)object).getCode() != Status.Code.UNKNOWN) {
            return object;
        }
        if (throwable instanceof ClosedChannelException) {
            object = new ClosedChannelException();
            ((Throwable)object).initCause(throwable);
            return Status.UNKNOWN.withDescription("channel closed").withCause((Throwable)object);
        }
        if (throwable instanceof IOException) {
            return Status.UNAVAILABLE.withDescription("com.appoptics.ext.io exception").withCause(throwable);
        }
        if (throwable instanceof UnresolvedAddressException) {
            return Status.UNAVAILABLE.withDescription("unresolved address").withCause(throwable);
        }
        if (throwable instanceof Http2Exception) {
            return Status.INTERNAL.withDescription("http2 exception").withCause(throwable);
        }
        return object;
    }

    static boolean isEpollAvailable() {
        try {
            return (Boolean)Class.forName("com.appoptics.ext.io.netty.channel.epoll.Epoll").getDeclaredMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while checking Epoll availability", exception);
        }
    }

    private static Throwable getEpollUnavailabilityCause() {
        try {
            return (Throwable)Class.forName("com.appoptics.ext.io.netty.channel.epoll.Epoll").getDeclaredMethod("unavailabilityCause", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            return exception;
        }
    }

    private static Class<? extends Channel> epollChannelType() {
        try {
            Class<Channel> clazz = Class.forName("com.appoptics.ext.io.netty.channel.epoll.EpollSocketChannel").asSubclass(Channel.class);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Cannot load EpollSocketChannel", classNotFoundException);
        }
    }

    private static Constructor<? extends EventLoopGroup> epollEventLoopGroupConstructor() {
        try {
            return Class.forName("com.appoptics.ext.io.netty.channel.epoll.EpollEventLoopGroup").asSubclass(EventLoopGroup.class).getConstructor(Integer.TYPE, ThreadFactory.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Cannot load EpollEventLoopGroup", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("EpollEventLoopGroup constructor not found", noSuchMethodException);
        }
    }

    private static Class<? extends ServerChannel> epollServerChannelType() {
        try {
            Class<ServerChannel> clazz = Class.forName("com.appoptics.ext.io.netty.channel.epoll.EpollServerSocketChannel").asSubclass(ServerChannel.class);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Cannot load EpollServerSocketChannel", classNotFoundException);
        }
    }

    private static EventLoopGroup createEpollEventLoopGroup(int n2, ThreadFactory threadFactory) {
        b.b(EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR != null, "Epoll is not available");
        try {
            return EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR.newInstance(n2, threadFactory);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot create Epoll EventLoopGroup", exception);
        }
    }

    private static ChannelFactory<ServerChannel> nioServerChannelFactory() {
        return new ChannelFactory<ServerChannel>(){

            @Override
            public ServerChannel newChannel() {
                return new NioServerSocketChannel();
            }
        };
    }

    static ChannelOption<Integer> maybeGetTcpUserTimeoutOption() {
        return Utils.getEpollChannelOption("TCP_USER_TIMEOUT");
    }

    private static <T> ChannelOption<T> getEpollChannelOption(String string) {
        if (Utils.isEpollAvailable()) {
            try {
                return (ChannelOption)Class.forName("com.appoptics.ext.io.netty.channel.epoll.EpollChannelOption").getField(string).get(null);
            }
            catch (Exception exception) {
                throw new RuntimeException("ChannelOption(" + string + ") is not available", exception);
            }
        }
        return null;
    }

    private Utils() {
    }

    static /* synthetic */ ByteBufAllocator access$000(boolean bl) {
        return Utils.createByteBufAllocator(bl);
    }

    static {
        if (Utils.isEpollAvailable()) {
            DEFAULT_CLIENT_CHANNEL_TYPE = Utils.epollChannelType();
            DEFAULT_SERVER_CHANNEL_FACTORY = new ReflectiveChannelFactory<ServerChannel>(Utils.epollServerChannelType());
            EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR = Utils.epollEventLoopGroupConstructor();
            DEFAULT_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-default-boss-ELG", EventLoopGroupType.EPOLL);
            DEFAULT_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-default-worker-ELG", EventLoopGroupType.EPOLL);
        } else {
            logger.log(Level.FINE, "Epoll is not available, using Nio.", Utils.getEpollUnavailabilityCause());
            DEFAULT_SERVER_CHANNEL_FACTORY = Utils.nioServerChannelFactory();
            DEFAULT_CLIENT_CHANNEL_TYPE = NioSocketChannel.class;
            DEFAULT_BOSS_EVENT_LOOP_GROUP = NIO_BOSS_EVENT_LOOP_GROUP;
            DEFAULT_WORKER_EVENT_LOOP_GROUP = NIO_WORKER_EVENT_LOOP_GROUP;
            EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventLoopGroupType {
        NIO,
        EPOLL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultEventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;
        private final int numEventLoops;
        private final EventLoopGroupType eventLoopGroupType;

        DefaultEventLoopGroupResource(int n2, String string, EventLoopGroupType eventLoopGroupType) {
            this.name = string;
            this.numEventLoops = n2 == 0 && System.getProperty("com.appoptics.ext.io.netty.eventLoopThreads") == null ? NettyRuntime.availableProcessors() : n2;
            this.eventLoopGroupType = eventLoopGroupType;
        }

        @Override
        public final EventLoopGroup create() {
            DefaultThreadFactory defaultThreadFactory = new DefaultThreadFactory(this.name, true);
            switch (this.eventLoopGroupType) {
                case NIO: {
                    return new NioEventLoopGroup(this.numEventLoops, defaultThreadFactory);
                }
                case EPOLL: {
                    return Utils.createEpollEventLoopGroup(this.numEventLoops, defaultThreadFactory);
                }
            }
            throw new AssertionError((Object)("Unknown/Unsupported EventLoopGroupType: " + (Object)((Object)this.eventLoopGroupType)));
        }

        @Override
        public final void close(EventLoopGroup eventLoopGroup) {
            eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        public final String toString() {
            return this.name;
        }
    }

    private static final class ByteBufAllocatorPreferHeapHolder {
        private static final ByteBufAllocator allocator = Utils.access$000(false);
    }

    private static final class ByteBufAllocatorPreferDirectHolder {
        private static final ByteBufAllocator allocator = Utils.access$000(true);
    }
}

