/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.InternalLogId;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.internal.ClientStream;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.ConnectionClientTransport;
import com.appoptics.ext.io.grpc.internal.FailingClientStream;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.Http2Ping;
import com.appoptics.ext.io.grpc.internal.KeepAliveManager;
import com.appoptics.ext.io.grpc.internal.ManagedClientTransport;
import com.appoptics.ext.io.grpc.internal.StatsTraceContext;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import com.appoptics.ext.io.grpc.netty.ClientTransportLifecycleManager;
import com.appoptics.ext.io.grpc.netty.ForcefulCloseCommand;
import com.appoptics.ext.io.grpc.netty.GracefulCloseCommand;
import com.appoptics.ext.io.grpc.netty.NettyChannelBuilder;
import com.appoptics.ext.io.grpc.netty.NettyClientHandler;
import com.appoptics.ext.io.grpc.netty.NettyClientStream;
import com.appoptics.ext.io.grpc.netty.ProtocolNegotiator;
import com.appoptics.ext.io.grpc.netty.SendPingCommand;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.grpc.netty.WriteBufferingAndExceptionHandler;
import com.appoptics.ext.io.netty.bootstrap.Bootstrap;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFactory;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandler;
import com.appoptics.ext.io.netty.channel.ChannelOption;
import com.appoptics.ext.io.netty.channel.EventLoopGroup;
import com.appoptics.ext.io.netty.handler.codec.http2.StreamBufferingEncoder;
import com.appoptics.ext.io.netty.util.AsciiString;
import com.appoptics.ext.io.netty.util.AttributeKey;
import com.tracelytics.a.d.a.a.g;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NettyClientTransport
implements ConnectionClientTransport {
    static final AttributeKey<ChannelLogger> LOGGER_KEY = NettyClientTransport.getOrCreateChannelLogger();
    private final InternalLogId logId;
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final SocketAddress remoteAddress;
    private final ChannelFactory<? extends Channel> channelFactory;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final String authorityString;
    private final AsciiString authority;
    private final AsciiString userAgent;
    private final boolean autoFlowControl;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private KeepAliveManager keepAliveManager;
    private final long keepAliveTimeNanos;
    private final long keepAliveTimeoutNanos;
    private final boolean keepAliveWithoutCalls;
    private final AsciiString negotiationScheme;
    private final Runnable tooManyPingsRunnable;
    private NettyClientHandler handler;
    private Channel channel;
    private Status statusExplainingWhyTheChannelIsNull;
    private ClientTransportLifecycleManager lifecycleManager;
    private final TransportTracer transportTracer;
    private final Attributes eagAttributes;
    private final NettyChannelBuilder.LocalSocketPicker localSocketPicker;
    private final ChannelLogger channelLogger;
    private final boolean useGetForSafeMethods;

    private static final AttributeKey<ChannelLogger> getOrCreateChannelLogger() {
        AttributeKey<ChannelLogger> attributeKey = AttributeKey.valueOf("channelLogger");
        if (attributeKey == null) {
            attributeKey = AttributeKey.newInstance("channelLogger");
        }
        return attributeKey;
    }

    NettyClientTransport(SocketAddress socketAddress, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> map, EventLoopGroup eventLoopGroup, ProtocolNegotiator protocolNegotiator, boolean bl, int n2, int n3, int n4, long l2, long l3, boolean bl2, String string, String string2, Runnable runnable, TransportTracer transportTracer, Attributes attributes, NettyChannelBuilder.LocalSocketPicker localSocketPicker, ChannelLogger channelLogger, boolean bl3) {
        this.negotiator = b.a(protocolNegotiator, (Object)"negotiator");
        this.negotiationScheme = this.negotiator.scheme();
        this.remoteAddress = b.a(socketAddress, (Object)"address");
        this.group = b.a(eventLoopGroup, (Object)"group");
        this.channelFactory = channelFactory;
        this.channelOptions = b.a(map, (Object)"channelOptions");
        this.autoFlowControl = bl;
        this.flowControlWindow = n2;
        this.maxMessageSize = n3;
        this.maxHeaderListSize = n4;
        this.keepAliveTimeNanos = l2;
        this.keepAliveTimeoutNanos = l3;
        this.keepAliveWithoutCalls = bl2;
        this.authorityString = string;
        this.authority = new AsciiString(string);
        this.userAgent = new AsciiString(GrpcUtil.getGrpcUserAgent("netty", string2));
        this.tooManyPingsRunnable = b.a(runnable, (Object)"tooManyPingsRunnable");
        this.transportTracer = b.a(transportTracer, (Object)"transportTracer");
        this.eagAttributes = b.a(attributes, (Object)"eagAttributes");
        this.localSocketPicker = b.a(localSocketPicker, (Object)"localSocketPicker");
        this.logId = InternalLogId.allocate(this.getClass(), this.remoteAddress.toString());
        this.channelLogger = b.a(channelLogger, (Object)"channelLogger");
        this.useGetForSafeMethods = bl3;
    }

    @Override
    public void ping(final ClientTransport.PingCallback pingCallback, final Executor executor) {
        if (this.channel == null) {
            executor.execute(new Runnable(){

                public void run() {
                    pingCallback.onFailure(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull.asException());
                }
            });
            return;
        }
        ChannelFutureListener channelFutureListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture object) throws Exception {
                if (!object.isSuccess()) {
                    object = NettyClientTransport.this.statusFromFailedFuture((ChannelFuture)object);
                    Http2Ping.notifyFailed(pingCallback, executor, ((Status)object).asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(pingCallback, executor), true).addListener(channelFutureListener);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> methodDescriptor, Metadata metadata, CallOptions callOptions) {
        b.a(methodDescriptor, (Object)"method");
        b.a(metadata, (Object)"headers");
        if (this.channel == null) {
            return new FailingClientStream(this.statusExplainingWhyTheChannelIsNull);
        }
        StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext(callOptions, this.getAttributes(), metadata);
        NettyClientTransport nettyClientTransport = this;
        return new NettyClientStream(new NettyClientStream.TransportState(nettyClientTransport.handler, this.channel.eventLoop(), this.maxMessageSize, statsTraceContext, this.transportTracer, methodDescriptor.getFullMethodName()){

            protected Status statusFromFailedFuture(ChannelFuture channelFuture) {
                return NettyClientTransport.this.statusFromFailedFuture(channelFuture);
            }
        }, methodDescriptor, metadata, this.channel, this.authority, this.negotiationScheme, this.userAgent, statsTraceContext, this.transportTracer, callOptions, this.useGetForSafeMethods);
    }

    @Override
    public Runnable start(ManagedClientTransport.Listener object) {
        this.lifecycleManager = new ClientTransportLifecycleManager((ManagedClientTransport.Listener)b.a(object, (Object)"listener"));
        object = this.group.next();
        if (this.keepAliveTimeNanos != Long.MAX_VALUE) {
            this.keepAliveManager = new KeepAliveManager(new KeepAliveManager.ClientKeepAlivePinger(this), (ScheduledExecutorService)object, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
        }
        this.handler = NettyClientHandler.newHandler(this.lifecycleManager, this.keepAliveManager, this.autoFlowControl, this.flowControlWindow, this.maxHeaderListSize, GrpcUtil.STOPWATCH_SUPPLIER, this.tooManyPingsRunnable, this.transportTracer, this.eagAttributes, this.authorityString);
        ChannelHandler channelHandler = this.negotiator.newHandler(this.handler);
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.option(ChannelOption.ALLOCATOR, Utils.getByteBufAllocator(false));
        bootstrap.attr(LOGGER_KEY, this.channelLogger);
        bootstrap.group((EventLoopGroup)object);
        bootstrap.channelFactory(this.channelFactory);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, Boolean.TRUE);
        if (this.keepAliveTimeNanos != Long.MAX_VALUE && (object = Utils.maybeGetTcpUserTimeoutOption()) != null) {
            bootstrap.option(object, (int)TimeUnit.NANOSECONDS.toMillis(this.keepAliveTimeoutNanos));
        }
        for (Map.Entry object22 : this.channelOptions.entrySet()) {
            bootstrap.option((ChannelOption)object22.getKey(), object22.getValue());
        }
        object = new WriteBufferingAndExceptionHandler(channelHandler);
        bootstrap.handler((ChannelHandler)object);
        ChannelFuture channelFuture = bootstrap.register();
        if (channelFuture.isDone() && !channelFuture.isSuccess()) {
            this.channel = null;
            object = channelFuture.cause();
            if (object == null) {
                object = new IllegalStateException("Channel is null, but future doesn't have a cause");
            }
            this.statusExplainingWhyTheChannelIsNull = Utils.statusFromThrowable((Throwable)object);
            return new Runnable(){

                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull);
                }
            };
        }
        this.channel = channelFuture.channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.writeAndFlush(NettyClientHandler.NOOP_MESSAGE).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (!channelFuture.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(channelFuture.cause()));
                }
            }
        });
        object = this.localSocketPicker.createSocketAddress(this.remoteAddress, this.eagAttributes);
        if (object != null) {
            this.channel.connect(this.remoteAddress, (SocketAddress)object);
        } else {
            this.channel.connect(this.remoteAddress);
        }
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportStarted();
        }
        return null;
    }

    @Override
    public void shutdown(Status status) {
        if (this.channel == null) {
            return;
        }
        if (this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(status), true);
        }
    }

    @Override
    public void shutdownNow(final Status status) {
        if (this.channel != null && this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new Runnable(){

                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyShutdown(status);
                    NettyClientTransport.this.channel.close();
                    NettyClientTransport.this.channel.write(new ForcefulCloseCommand(status));
                }
            }, true);
        }
    }

    public String toString() {
        return g.a(this).a("logId", this.logId.getId()).a("remoteAddress", this.remoteAddress).a("channel", this.channel).toString();
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    public Attributes getAttributes() {
        return this.handler.getAttributes();
    }

    private Status statusFromFailedFuture(ChannelFuture object) {
        if ((object = object.cause()) instanceof ClosedChannelException || object instanceof StreamBufferingEncoder.Http2ChannelClosedException) {
            Status status = this.lifecycleManager.getShutdownStatus();
            if (status == null) {
                return Status.UNKNOWN.withDescription("Channel closed but for unknown reason").withCause(new ClosedChannelException().initCause((Throwable)object));
            }
            return status;
        }
        return Utils.statusFromThrowable((Throwable)object);
    }
}

