/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.a.c;
import com.appoptics.ext.io.a.d;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.StatusException;
import com.appoptics.ext.io.grpc.internal.AbstractClientStream;
import com.appoptics.ext.io.grpc.internal.ClientStreamListener;
import com.appoptics.ext.io.grpc.internal.ClientTransport;
import com.appoptics.ext.io.grpc.internal.GrpcAttributes;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.appoptics.ext.io.grpc.internal.Http2Ping;
import com.appoptics.ext.io.grpc.internal.InUseStateAggregator;
import com.appoptics.ext.io.grpc.internal.KeepAliveManager;
import com.appoptics.ext.io.grpc.internal.TransportTracer;
import com.appoptics.ext.io.grpc.netty.AbstractNettyHandler;
import com.appoptics.ext.io.grpc.netty.CancelClientStreamCommand;
import com.appoptics.ext.io.grpc.netty.ClientTransportLifecycleManager;
import com.appoptics.ext.io.grpc.netty.CreateStreamCommand;
import com.appoptics.ext.io.grpc.netty.ForcefulCloseCommand;
import com.appoptics.ext.io.grpc.netty.GracefulCloseCommand;
import com.appoptics.ext.io.grpc.netty.GrpcHttp2HeadersUtils;
import com.appoptics.ext.io.grpc.netty.NettyClientStream;
import com.appoptics.ext.io.grpc.netty.SendGrpcFrameCommand;
import com.appoptics.ext.io.grpc.netty.SendPingCommand;
import com.appoptics.ext.io.grpc.netty.Utils;
import com.appoptics.ext.io.grpc.netty.WriteBufferingAndExceptionHandler;
import com.appoptics.ext.io.grpc.netty.WriteQueue;
import com.appoptics.ext.io.netty.buffer.ByteBuf;
import com.appoptics.ext.io.netty.buffer.ByteBufUtil;
import com.appoptics.ext.io.netty.buffer.Unpooled;
import com.appoptics.ext.io.netty.channel.Channel;
import com.appoptics.ext.io.netty.channel.ChannelFuture;
import com.appoptics.ext.io.netty.channel.ChannelFutureListener;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.DecoratingHttp2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2LocalFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Connection;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Error;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameAdapter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameLogger;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameReader;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2FrameWriter;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Headers;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2HeadersDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2InboundFrameLogger;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2RemoteFlowController;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2StreamVisitor;
import com.appoptics.ext.io.netty.handler.codec.http2.StreamBufferingEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.StreamByteDistributor;
import com.appoptics.ext.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import com.appoptics.ext.io.netty.handler.logging.LogLevel;
import com.appoptics.ext.io.netty.util.CharsetUtil;
import com.appoptics.ext.io.netty.util.internal.ObjectUtil;
import com.tracelytics.a.d.a.a.l;
import com.tracelytics.a.d.a.a.m;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NettyClientHandler
extends AbstractNettyHandler {
    private static final Logger logger = Logger.getLogger(NettyClientHandler.class.getName());
    static final Object NOOP_MESSAGE = new Object();
    private static final Status EXHAUSTED_STREAMS_STATUS = Status.UNAVAILABLE.withDescription("Stream IDs have been exhausted");
    private final Http2Connection.PropertyKey streamKey;
    private final ClientTransportLifecycleManager lifecycleManager;
    private final KeepAliveManager keepAliveManager;
    private final m<l> stopwatchFactory;
    private final TransportTracer transportTracer;
    private final Attributes eagAttributes;
    private final String authority;
    private final InUseStateAggregator<Http2Stream> inUseState = new InUseStateAggregator<Http2Stream>(){

        @Override
        protected void handleInUse() {
            NettyClientHandler.this.lifecycleManager.notifyInUse(true);
        }

        @Override
        protected void handleNotInUse() {
            NettyClientHandler.this.lifecycleManager.notifyInUse(false);
        }
    };
    private WriteQueue clientWriteQueue;
    private Http2Ping ping;
    private Attributes attributes;
    private InternalChannelz.Security securityInfo;
    private Status abruptGoAwayStatus;
    private Status channelInactiveReason;

    static NettyClientHandler newHandler(ClientTransportLifecycleManager clientTransportLifecycleManager, KeepAliveManager keepAliveManager, boolean bl, int n2, int n3, m<l> m2, Runnable runnable, TransportTracer transportTracer, Attributes attributes, String string) {
        b.a(n3 > 0, (Object)"maxHeaderListSize must be positive");
        Object object = new GrpcHttp2HeadersUtils.GrpcHttp2ClientHeadersDecoder(n3);
        object = new DefaultHttp2FrameReader((Http2HeadersDecoder)object);
        DefaultHttp2FrameWriter defaultHttp2FrameWriter = new DefaultHttp2FrameWriter();
        DefaultHttp2Connection defaultHttp2Connection = new DefaultHttp2Connection(false);
        Object object2 = new WeightedFairQueueByteDistributor(defaultHttp2Connection);
        ((WeightedFairQueueByteDistributor)object2).allocationQuantum(16384);
        object2 = new DefaultHttp2RemoteFlowController((Http2Connection)defaultHttp2Connection, (StreamByteDistributor)object2);
        defaultHttp2Connection.remote().flowController((Http2RemoteFlowController)object2);
        return NettyClientHandler.newHandler(defaultHttp2Connection, (Http2FrameReader)object, defaultHttp2FrameWriter, clientTransportLifecycleManager, keepAliveManager, bl, n2, n3, m2, runnable, transportTracer, attributes, string);
    }

    static NettyClientHandler newHandler(Http2Connection object, Http2FrameReader closeable, Http2FrameWriter http2FrameWriter, ClientTransportLifecycleManager clientTransportLifecycleManager, KeepAliveManager keepAliveManager, boolean bl, int n2, int n3, m<l> m2, Runnable runnable, TransportTracer transportTracer, Attributes attributes, String string) {
        b.a(object, (Object)"connection");
        b.a(closeable, (Object)"frameReader");
        b.a(clientTransportLifecycleManager, (Object)"lifecycleManager");
        b.a(n2 > 0, (Object)"flowControlWindow must be positive");
        b.a(n3 > 0, (Object)"maxHeaderListSize must be positive");
        b.a(m2, (Object)"stopwatchFactory");
        b.a(runnable, (Object)"tooManyPingsRunnable");
        b.a(attributes, (Object)"eagAttributes");
        b.a(string, (Object)"authority");
        Object object2 = new Http2FrameLogger(LogLevel.DEBUG, NettyClientHandler.class);
        closeable = new Http2InboundFrameLogger((Http2FrameReader)closeable, (Http2FrameLogger)object2);
        http2FrameWriter = new Http2OutboundFrameLogger(http2FrameWriter, (Http2FrameLogger)object2);
        object2 = new PingCountingFrameWriter(http2FrameWriter);
        http2FrameWriter = object2;
        http2FrameWriter = new StreamBufferingEncoder(new DefaultHttp2ConnectionEncoder((Http2Connection)object, http2FrameWriter));
        object.local().flowController(new DefaultHttp2LocalFlowController((Http2Connection)object, 0.5f, true));
        closeable = new DefaultHttp2ConnectionDecoder((Http2Connection)object, (Http2ConnectionEncoder)http2FrameWriter, (Http2FrameReader)closeable);
        transportTracer.setFlowControlWindowReader(new TransportTracer.FlowControlReader((Http2Connection)object){
            final Http2FlowController local;
            final Http2FlowController remote;
            final /* synthetic */ Http2Connection val$connection;
            {
                this.val$connection = http2Connection;
                this.local = this.val$connection.local().flowController();
                this.remote = this.val$connection.remote().flowController();
            }
        });
        object = new Http2Settings();
        ((Http2Settings)object).pushEnabled(false);
        ((Http2Settings)object).initialWindowSize(n2);
        ((Http2Settings)object).maxConcurrentStreams(0L);
        ((Http2Settings)object).maxHeaderListSize(n3);
        return new NettyClientHandler((Http2ConnectionDecoder)closeable, (Http2ConnectionEncoder)http2FrameWriter, (Http2Settings)object, clientTransportLifecycleManager, keepAliveManager, m2, runnable, transportTracer, attributes, string, bl, (AbstractNettyHandler.PingLimiter)object2);
    }

    private NettyClientHandler(Http2ConnectionDecoder object, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, ClientTransportLifecycleManager clientTransportLifecycleManager, KeepAliveManager keepAliveManager, m<l> m2, final Runnable runnable, TransportTracer transportTracer, Attributes attributes, String string, boolean bl, AbstractNettyHandler.PingLimiter pingLimiter) {
        super(null, (Http2ConnectionDecoder)object, http2ConnectionEncoder, http2Settings, bl, pingLimiter);
        this.lifecycleManager = clientTransportLifecycleManager;
        this.keepAliveManager = keepAliveManager;
        this.stopwatchFactory = m2;
        this.transportTracer = b.a(transportTracer);
        this.eagAttributes = attributes;
        this.authority = string;
        this.attributes = Attributes.newBuilder().set(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS, attributes).build();
        this.decoder().frameListener(new FrameListener());
        object = http2ConnectionEncoder.connection();
        this.streamKey = object.newKey();
        object.addListener(new Http2ConnectionAdapter(){

            public void onGoAwayReceived(int n2, long l2, ByteBuf byteBuf) {
                Object object = ByteBufUtil.getBytes(byteBuf);
                NettyClientHandler.this.goingAway(l2, object);
                if (l2 == Http2Error.ENHANCE_YOUR_CALM.code()) {
                    object = new String((byte[])object, CharsetUtil.UTF_8);
                    logger.log(Level.WARNING, "Received GOAWAY with ENHANCE_YOUR_CALM. Debug data: {0}", object);
                    if ("too_many_pings".equals(object)) {
                        runnable.run();
                    }
                }
            }

            public void onStreamActive(Http2Stream http2Stream) {
                if (NettyClientHandler.this.connection().numActiveStreams() == 1 && NettyClientHandler.this.keepAliveManager != null) {
                    NettyClientHandler.this.keepAliveManager.onTransportActive();
                }
            }

            public void onStreamClosed(Http2Stream http2Stream) {
                NettyClientHandler.this.inUseState.updateObjectInUse(http2Stream, false);
                if (NettyClientHandler.this.connection().numActiveStreams() == 0 && NettyClientHandler.this.keepAliveManager != null) {
                    NettyClientHandler.this.keepAliveManager.onTransportIdle();
                }
            }
        });
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) throws Exception {
        if (object instanceof CreateStreamCommand) {
            this.createStream((CreateStreamCommand)object, channelPromise);
            return;
        }
        if (object instanceof SendGrpcFrameCommand) {
            this.sendGrpcFrame(channelHandlerContext, (SendGrpcFrameCommand)object, channelPromise);
            return;
        }
        if (object instanceof CancelClientStreamCommand) {
            this.cancelStream(channelHandlerContext, (CancelClientStreamCommand)object, channelPromise);
            return;
        }
        if (object instanceof SendPingCommand) {
            this.sendPingFrame(channelHandlerContext, (SendPingCommand)object, channelPromise);
            return;
        }
        if (object instanceof GracefulCloseCommand) {
            this.gracefulClose(channelHandlerContext, (GracefulCloseCommand)object, channelPromise);
            return;
        }
        if (object instanceof ForcefulCloseCommand) {
            this.forcefulClose(channelHandlerContext, (ForcefulCloseCommand)object, channelPromise);
            return;
        }
        if (object == NOOP_MESSAGE) {
            channelHandlerContext.write(Unpooled.EMPTY_BUFFER, channelPromise);
            return;
        }
        throw new AssertionError((Object)("Write called for unexpected type: " + object.getClass().getName()));
    }

    void startWriteQueue(Channel channel) {
        this.clientWriteQueue = new WriteQueue(channel);
    }

    WriteQueue getWriteQueue() {
        return this.clientWriteQueue;
    }

    ClientTransportLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    void returnProcessedBytes(Http2Stream http2Stream, int n2) {
        try {
            this.decoder().flowController().consumeBytes(http2Stream, n2);
            return;
        }
        catch (Http2Exception http2Exception) {
            throw new RuntimeException(http2Exception);
        }
    }

    private void onHeadersRead(int n2, Http2Headers http2Headers, boolean bl) {
        if (n2 != 1) {
            NettyClientHandler nettyClientHandler = this;
            NettyClientStream.TransportState transportState = nettyClientHandler.clientStream(nettyClientHandler.requireHttp2Stream(n2));
            c.b("NettyClientHandler.onHeadersRead", transportState.tag());
            transportState.transportHeadersReceived(http2Headers, bl);
        }
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onDataReceived();
        }
    }

    private void onDataRead(int n2, ByteBuf byteBuf, int n3, boolean bl) {
        this.flowControlPing().onDataRead(byteBuf.readableBytes(), n3);
        NettyClientHandler nettyClientHandler = this;
        NettyClientStream.TransportState transportState = nettyClientHandler.clientStream(nettyClientHandler.requireHttp2Stream(n2));
        c.b("NettyClientHandler.onDataRead", transportState.tag());
        transportState.transportDataReceived(byteBuf, bl);
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onDataReceived();
        }
    }

    private void onRstStreamRead(int n2, long l2) {
        NettyClientHandler nettyClientHandler = this;
        NettyClientStream.TransportState transportState = nettyClientHandler.clientStream(nettyClientHandler.connection().stream(n2));
        if (transportState != null) {
            c.b("NettyClientHandler.onRstStreamRead", transportState.tag());
            Status status = this.statusFromH2Error(null, "RST_STREAM closed stream", l2, null);
            transportState.transportReportStatus(status, l2 == Http2Error.REFUSED_STREAM.code() ? ClientStreamListener.RpcProgress.REFUSED : ClientStreamListener.RpcProgress.PROCESSED, false, new Metadata());
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onDataReceived();
            }
        }
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) throws Exception {
        logger.fine("Network channel being closed by the application.");
        if (channelHandlerContext.channel().isActive()) {
            this.lifecycleManager.notifyShutdown(Status.UNAVAILABLE.withDescription("Transport closed for unknown reason"));
        }
        super.close(channelHandlerContext, channelPromise);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        try {
            logger.fine("Network channel is closed");
            Status status = Status.UNAVAILABLE.withDescription("Network closed for unknown reason");
            this.lifecycleManager.notifyShutdown(status);
            final Status status2 = this.channelInactiveReason != null ? this.channelInactiveReason : this.lifecycleManager.getShutdownStatus();
            try {
                NettyClientHandler nettyClientHandler = this;
                nettyClientHandler.cancelPing(nettyClientHandler.lifecycleManager.getShutdownThrowable());
                this.connection().forEachActiveStream(new Http2StreamVisitor(){

                    public boolean visit(Http2Stream object) throws Http2Exception {
                        if ((object = NettyClientHandler.this.clientStream((Http2Stream)object)) != null) {
                            ((AbstractClientStream.TransportState)object).transportReportStatus(status2, false, new Metadata());
                        }
                        return true;
                    }
                });
            }
            finally {
                this.lifecycleManager.notifyTerminated(status);
            }
        }
        catch (Throwable throwable) {
            super.channelInactive(channelHandlerContext);
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportTermination();
            }
            throw throwable;
        }
        super.channelInactive(channelHandlerContext);
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportTermination();
            return;
        }
    }

    @Override
    public void handleProtocolNegotiationCompleted(Attributes attributes, InternalChannelz.Security security) {
        this.attributes = this.attributes.toBuilder().setAll(attributes).build();
        this.securityInfo = security;
        super.handleProtocolNegotiationCompleted(attributes, security);
        NettyClientHandler.writeBufferingAndRemove(this.ctx().channel());
    }

    static void writeBufferingAndRemove(Channel channelOutboundInvoker) {
        ObjectUtil.checkNotNull(channelOutboundInvoker, "channel");
        channelOutboundInvoker = channelOutboundInvoker.pipeline().context(WriteBufferingAndExceptionHandler.class);
        if (channelOutboundInvoker == null) {
            return;
        }
        ((WriteBufferingAndExceptionHandler)channelOutboundInvoker.handler()).writeBufferedAndRemove((ChannelHandlerContext)channelOutboundInvoker);
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception http2Exception) {
        logger.log(Level.FINE, "Caught a connection error", throwable);
        this.lifecycleManager.notifyShutdown(Utils.statusFromThrowable(throwable));
        super.onConnectionError(channelHandlerContext, bl, throwable, http2Exception);
    }

    @Override
    protected void onStreamError(ChannelHandlerContext channelHandlerContext, boolean bl, Throwable throwable, Http2Exception.StreamException streamException) {
        NettyClientHandler nettyClientHandler = this;
        NettyClientStream.TransportState transportState = nettyClientHandler.clientStream(nettyClientHandler.connection().stream(streamException.streamId()));
        if (transportState != null) {
            transportState.transportReportStatus(Utils.statusFromThrowable(throwable), false, new Metadata());
        } else {
            logger.log(Level.FINE, "Stream error for unknown stream " + streamException.streamId(), throwable);
        }
        super.onStreamError(channelHandlerContext, bl, throwable, streamException);
    }

    @Override
    protected boolean isGracefulShutdownComplete() {
        return super.isGracefulShutdownComplete() && ((StreamBufferingEncoder)this.encoder()).numBufferedStreams() == 0;
    }

    private void createStream(CreateStreamCommand createStreamCommand, ChannelPromise channelPromise) throws Exception {
        int n2;
        if (this.lifecycleManager.getShutdownThrowable() != null) {
            createStreamCommand.stream().setNonExistent();
            createStreamCommand.stream().transportReportStatus(this.lifecycleManager.getShutdownStatus(), ClientStreamListener.RpcProgress.REFUSED, true, new Metadata());
            channelPromise.setFailure(this.lifecycleManager.getShutdownThrowable());
            return;
        }
        try {
            n2 = this.incrementAndGetNextStreamId();
        }
        catch (StatusException statusException) {
            createStreamCommand.stream().setNonExistent();
            channelPromise.setFailure(statusException);
            if (!this.connection().goAwaySent()) {
                logger.fine("Stream IDs have been exhausted for this connection. Initiating graceful shutdown of the connection.");
                this.lifecycleManager.notifyShutdown(statusException.getStatus());
                NettyClientHandler nettyClientHandler = this;
                nettyClientHandler.close(nettyClientHandler.ctx(), this.ctx().newPromise());
            }
            return;
        }
        if (this.connection().goAwayReceived() && n2 > this.connection().local().lastStreamKnownByPeer()) {
            createStreamCommand.stream().setNonExistent();
            Status status = this.abruptGoAwayStatus;
            if (status == null) {
                status = Status.INTERNAL.withDescription("Failed due to abrupt GOAWAY, but can't find GOAWAY details");
            }
            createStreamCommand.stream().transportReportStatus(status, ClientStreamListener.RpcProgress.REFUSED, true, new Metadata());
            channelPromise.setFailure(status.asRuntimeException());
            return;
        }
        NettyClientStream.TransportState transportState = createStreamCommand.stream();
        Http2Headers http2Headers = createStreamCommand.headers();
        transportState.setId(n2);
        c.a("NettyClientHandler.createStream", transportState.tag());
        c.a(createStreamCommand.getLink());
        try {
            this.createStreamTraced(n2, transportState, http2Headers, createStreamCommand.isGet(), createStreamCommand.shouldBeCountedForInUse(), channelPromise);
            return;
        }
        finally {
            c.c("NettyClientHandler.createStream", transportState.tag());
        }
    }

    private void createStreamTraced(final int n2, final NettyClientStream.TransportState transportState, Http2Headers http2Headers, boolean bl, final boolean bl2, final ChannelPromise channelPromise) {
        ChannelPromise channelPromise2 = this.ctx().newPromise();
        this.encoder().writeHeaders(this.ctx(), n2, http2Headers, 0, bl, channelPromise2).addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture object) throws Exception {
                if (object.isSuccess()) {
                    object = NettyClientHandler.this.connection().stream(n2);
                    if (object != null) {
                        transportState.getStatsTraceContext().clientOutboundHeaders();
                        object.setProperty(NettyClientHandler.this.streamKey, transportState);
                        if (bl2) {
                            NettyClientHandler.this.inUseState.updateObjectInUse(object, true);
                        }
                        transportState.setHttp2Stream((Http2Stream)object);
                    }
                    channelPromise.setSuccess();
                    return;
                }
                if ((object = object.cause()) instanceof StreamBufferingEncoder.Http2GoAwayException) {
                    object = (StreamBufferingEncoder.Http2GoAwayException)object;
                    object = NettyClientHandler.this.statusFromH2Error(Status.Code.UNAVAILABLE, "GOAWAY closed buffered stream", ((StreamBufferingEncoder.Http2GoAwayException)object).errorCode(), ((StreamBufferingEncoder.Http2GoAwayException)object).debugData());
                    transportState.transportReportStatus((Status)object, ClientStreamListener.RpcProgress.REFUSED, true, new Metadata());
                    channelPromise.setFailure(((Status)object).asRuntimeException());
                    return;
                }
                channelPromise.setFailure((Throwable)object);
            }
        });
    }

    private void cancelStream(ChannelHandlerContext channelHandlerContext, CancelClientStreamCommand cancelClientStreamCommand, ChannelPromise channelPromise) {
        NettyClientStream.TransportState transportState = cancelClientStreamCommand.stream();
        c.a("NettyClientHandler.cancelStream", transportState.tag());
        c.a(cancelClientStreamCommand.getLink());
        try {
            Status status = cancelClientStreamCommand.reason();
            if (status != null) {
                transportState.transportReportStatus(status, true, new Metadata());
            }
            if (!cancelClientStreamCommand.stream().isNonExistent()) {
                this.encoder().writeRstStream(channelHandlerContext, transportState.id(), Http2Error.CANCEL.code(), channelPromise);
            } else {
                channelPromise.setSuccess();
            }
            return;
        }
        finally {
            c.c("NettyClientHandler.cancelStream", transportState.tag());
        }
    }

    private void sendGrpcFrame(ChannelHandlerContext channelHandlerContext, SendGrpcFrameCommand sendGrpcFrameCommand, ChannelPromise channelPromise) {
        c.a("NettyClientHandler.sendGrpcFrame", sendGrpcFrameCommand.stream().tag());
        c.a(sendGrpcFrameCommand.getLink());
        try {
            this.encoder().writeData(channelHandlerContext, sendGrpcFrameCommand.stream().id(), sendGrpcFrameCommand.content(), 0, sendGrpcFrameCommand.endStream(), channelPromise);
            return;
        }
        finally {
            c.c("NettyClientHandler.sendGrpcFrame", sendGrpcFrameCommand.stream().tag());
        }
    }

    private void sendPingFrame(ChannelHandlerContext channelHandlerContext, SendPingCommand sendPingCommand, ChannelPromise channelPromise) {
        c.a("NettyClientHandler.sendPingFrame");
        c.a(sendPingCommand.getLink());
        try {
            this.sendPingFrameTraced(channelHandlerContext, sendPingCommand, channelPromise);
            return;
        }
        finally {
            c.b("NettyClientHandler.sendPingFrame");
        }
    }

    private void sendPingFrameTraced(ChannelHandlerContext object, SendPingCommand object2, ChannelPromise channelPromise) {
        ClientTransport.PingCallback pingCallback = ((SendPingCommand)object2).callback();
        object2 = ((SendPingCommand)object2).executor();
        if (this.ping != null) {
            channelPromise.setSuccess();
            this.ping.addCallback(pingCallback, (Executor)object2);
            return;
        }
        channelPromise.setSuccess();
        channelPromise = this.ctx().newPromise();
        l l2 = this.stopwatchFactory.get();
        l2.b();
        this.ping = new Http2Ping(1111L, l2);
        this.ping.addCallback(pingCallback, (Executor)object2);
        this.encoder().writePing((ChannelHandlerContext)object, false, 1111L, channelPromise);
        object.flush();
        object = this.ping;
        channelPromise.addListener(new ChannelFutureListener((Http2Ping)object){
            final /* synthetic */ Http2Ping val$finalPing;
            {
                this.val$finalPing = http2Ping;
            }

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (channelFuture.isSuccess()) {
                    NettyClientHandler.this.transportTracer.reportKeepAliveSent();
                    return;
                }
                Throwable throwable = channelFuture.cause();
                if (throwable instanceof ClosedChannelException && (throwable = NettyClientHandler.this.lifecycleManager.getShutdownThrowable()) == null) {
                    throwable = Status.UNKNOWN.withDescription("Ping failed but for unknown reason.").withCause(channelFuture.cause()).asException();
                }
                this.val$finalPing.failed(throwable);
                if (NettyClientHandler.this.ping == this.val$finalPing) {
                    NettyClientHandler.this.ping = null;
                }
            }
        });
    }

    private void gracefulClose(ChannelHandlerContext channelHandlerContext, GracefulCloseCommand gracefulCloseCommand, ChannelPromise channelPromise) throws Exception {
        this.lifecycleManager.notifyShutdown(gracefulCloseCommand.getStatus());
        this.flush(channelHandlerContext);
        this.close(channelHandlerContext, channelPromise);
    }

    private void forcefulClose(final ChannelHandlerContext channelHandlerContext, final ForcefulCloseCommand forcefulCloseCommand, ChannelPromise channelPromise) throws Exception {
        this.connection().forEachActiveStream(new Http2StreamVisitor(){

            public boolean visit(Http2Stream http2Stream) throws Http2Exception {
                NettyClientStream.TransportState transportState = NettyClientHandler.this.clientStream(http2Stream);
                d d2 = transportState != null ? transportState.tag() : c.a();
                c.a("NettyClientHandler.forcefulClose", d2);
                c.a(forcefulCloseCommand.getLink());
                try {
                    if (transportState != null) {
                        transportState.transportReportStatus(forcefulCloseCommand.getStatus(), true, new Metadata());
                        NettyClientHandler.this.resetStream(channelHandlerContext, http2Stream.id(), Http2Error.CANCEL.code(), channelHandlerContext.newPromise());
                    }
                    http2Stream.close();
                    return true;
                }
                finally {
                    c.c("NettyClientHandler.forcefulClose", d2);
                }
            }
        });
        channelPromise.setSuccess();
    }

    private void goingAway(long l2, byte[] byArray) {
        Status status = this.statusFromH2Error(Status.Code.UNAVAILABLE, "GOAWAY shut down transport", l2, byArray);
        this.lifecycleManager.notifyGracefulShutdown(status);
        this.abruptGoAwayStatus = this.statusFromH2Error(Status.Code.UNAVAILABLE, "Abrupt GOAWAY closed unsent stream", l2, byArray);
        final Status status2 = this.statusFromH2Error(null, "Abrupt GOAWAY closed sent stream", l2, byArray);
        this.clientWriteQueue.drainNow();
        if (this.lifecycleManager.notifyShutdown(status)) {
            this.channelInactiveReason = this.statusFromH2Error(null, "Connection closed after GOAWAY", l2, byArray);
        }
        final int n2 = this.connection().local().lastStreamKnownByPeer();
        try {
            this.connection().forEachActiveStream(new Http2StreamVisitor(){

                public boolean visit(Http2Stream http2Stream) throws Http2Exception {
                    if (http2Stream.id() > n2) {
                        NettyClientStream.TransportState transportState = NettyClientHandler.this.clientStream(http2Stream);
                        if (transportState != null) {
                            transportState.transportReportStatus(status2, ClientStreamListener.RpcProgress.PROCESSED, false, new Metadata());
                        }
                        http2Stream.close();
                    }
                    return true;
                }
            });
            return;
        }
        catch (Http2Exception http2Exception) {
            throw new RuntimeException(http2Exception);
        }
    }

    private void cancelPing(Throwable throwable) {
        if (this.ping != null) {
            this.ping.failed(throwable);
            this.ping = null;
        }
    }

    private Status statusFromH2Error(Status.Code code, String string, long l2, byte[] byArray) {
        Status status = GrpcUtil.Http2Error.statusForCode((int)l2);
        if (code == null) {
            code = status.getCode();
        }
        String string2 = "";
        if (byArray != null && byArray.length > 0) {
            string2 = ", debug data: " + new String(byArray, CharsetUtil.UTF_8);
        }
        return code.toStatus().withDescription(string + ". " + status.getDescription() + string2);
    }

    private NettyClientStream.TransportState clientStream(Http2Stream http2Stream) {
        if (http2Stream == null) {
            return null;
        }
        return (NettyClientStream.TransportState)http2Stream.getProperty(this.streamKey);
    }

    private int incrementAndGetNextStreamId() throws StatusException {
        int n2 = this.connection().local().incrementAndGetNextStreamId();
        if (n2 < 0) {
            logger.fine("Stream IDs have been exhausted for this connection. Initiating graceful shutdown of the connection.");
            throw EXHAUSTED_STREAMS_STATUS.asException();
        }
        return n2;
    }

    private Http2Stream requireHttp2Stream(int n2) {
        Http2Stream http2Stream = this.connection().stream(n2);
        if (http2Stream == null) {
            throw new AssertionError((Object)("Stream does not exist: " + n2));
        }
        return http2Stream;
    }

    private static class PingCountingFrameWriter
    extends DecoratingHttp2FrameWriter
    implements AbstractNettyHandler.PingLimiter {
        private int pingCount;

        public PingCountingFrameWriter(Http2FrameWriter http2FrameWriter) {
            super(http2FrameWriter);
        }

        public boolean isPingAllowed() {
            return this.pingCount < 2;
        }

        public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, boolean bl, ChannelPromise channelPromise) {
            this.pingCount = 0;
            return super.writeHeaders(channelHandlerContext, n2, http2Headers, n3, bl, channelPromise);
        }

        public ChannelFuture writeHeaders(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2, ChannelPromise channelPromise) {
            this.pingCount = 0;
            return super.writeHeaders(channelHandlerContext, n2, http2Headers, n3, s2, bl, n4, bl2, channelPromise);
        }

        public ChannelFuture writeWindowUpdate(ChannelHandlerContext channelHandlerContext, int n2, int n3, ChannelPromise channelPromise) {
            this.pingCount = 0;
            return super.writeWindowUpdate(channelHandlerContext, n2, n3, channelPromise);
        }

        public ChannelFuture writePing(ChannelHandlerContext channelHandlerContext, boolean bl, long l2, ChannelPromise channelPromise) {
            if (!bl) {
                ++this.pingCount;
            }
            return super.writePing(channelHandlerContext, bl, l2, channelPromise);
        }

        public ChannelFuture writeData(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl, ChannelPromise channelPromise) {
            if (byteBuf.isReadable()) {
                this.pingCount = 0;
            }
            return super.writeData(channelHandlerContext, n2, byteBuf, n3, bl, channelPromise);
        }
    }

    private class FrameListener
    extends Http2FrameAdapter {
        private boolean firstSettings = true;

        private FrameListener() {
        }

        public void onSettingsRead(ChannelHandlerContext channelHandlerContext, Http2Settings http2Settings) {
            if (this.firstSettings) {
                this.firstSettings = false;
                NettyClientHandler.this.lifecycleManager.notifyReady();
            }
        }

        public int onDataRead(ChannelHandlerContext channelHandlerContext, int n2, ByteBuf byteBuf, int n3, boolean bl) throws Http2Exception {
            NettyClientHandler.this.onDataRead(n2, byteBuf, n3, bl);
            return n3;
        }

        public void onHeadersRead(ChannelHandlerContext channelHandlerContext, int n2, Http2Headers http2Headers, int n3, short s2, boolean bl, int n4, boolean bl2) throws Http2Exception {
            NettyClientHandler.this.onHeadersRead(n2, http2Headers, bl2);
        }

        public void onRstStreamRead(ChannelHandlerContext channelHandlerContext, int n2, long l2) throws Http2Exception {
            NettyClientHandler.this.onRstStreamRead(n2, l2);
        }

        public void onPingAckRead(ChannelHandlerContext object, long l2) throws Http2Exception {
            object = NettyClientHandler.this.ping;
            if (l2 == NettyClientHandler.this.flowControlPing().payload()) {
                NettyClientHandler.this.flowControlPing().updateWindow();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, String.format("Window: %d", NettyClientHandler.this.decoder().flowController().initialWindowSize(NettyClientHandler.this.connection().connectionStream())));
                }
            } else if (object != null) {
                if (((Http2Ping)object).payload() == l2) {
                    ((Http2Ping)object).complete();
                    NettyClientHandler.this.ping = null;
                } else {
                    logger.log(Level.WARNING, String.format("Received unexpected ping ack. Expecting %d, got %d", ((Http2Ping)object).payload(), l2));
                }
            } else {
                logger.warning("Received unexpected ping ack. No ping outstanding");
            }
            if (NettyClientHandler.this.keepAliveManager != null) {
                NettyClientHandler.this.keepAliveManager.onDataReceived();
            }
        }

        public void onPingRead(ChannelHandlerContext channelHandlerContext, long l2) throws Http2Exception {
            if (NettyClientHandler.this.keepAliveManager != null) {
                NettyClientHandler.this.keepAliveManager.onDataReceived();
            }
        }
    }
}

