/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.netty;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.netty.GrpcHttp2ConnectionHandler;
import com.appoptics.ext.io.netty.channel.ChannelHandlerContext;
import com.appoptics.ext.io.netty.channel.ChannelPromise;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2CodecUtil;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Exception;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Settings;
import com.appoptics.ext.io.netty.handler.codec.http2.Http2Stream;
import java.util.concurrent.TimeUnit;

abstract class AbstractNettyHandler
extends GrpcHttp2ConnectionHandler {
    private final int initialConnectionWindow;
    private final FlowControlPinger flowControlPing;
    private boolean autoTuneFlowControlOn;
    private ChannelHandlerContext ctx;
    private boolean initialWindowSent = false;

    AbstractNettyHandler(ChannelPromise channelPromise, Http2ConnectionDecoder http2ConnectionDecoder, Http2ConnectionEncoder http2ConnectionEncoder, Http2Settings http2Settings, boolean bl, PingLimiter pingLimiter) {
        super(channelPromise, http2ConnectionDecoder, http2ConnectionEncoder, http2Settings);
        this.gracefulShutdownTimeoutMillis(-1L);
        this.initialConnectionWindow = http2Settings.initialWindowSize() == null ? -1 : http2Settings.initialWindowSize();
        this.autoTuneFlowControlOn = bl;
        if (pingLimiter == null) {
            pingLimiter = new AllowPingLimiter();
        }
        this.flowControlPing = new FlowControlPinger(pingLimiter);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.ctx = channelHandlerContext;
        super.handlerAdded(channelHandlerContext);
        this.sendInitialConnectionWindow();
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.channelActive(channelHandlerContext);
        this.sendInitialConnectionWindow();
    }

    public final void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        Http2Exception http2Exception = Http2CodecUtil.getEmbeddedHttp2Exception(throwable);
        if (http2Exception == null) {
            this.onError(channelHandlerContext, false, throwable);
            return;
        }
        super.exceptionCaught(channelHandlerContext, throwable);
    }

    protected final ChannelHandlerContext ctx() {
        return this.ctx;
    }

    private void sendInitialConnectionWindow() throws Http2Exception {
        if (!this.initialWindowSent && this.ctx.channel().isActive()) {
            Http2Stream http2Stream = this.connection().connectionStream();
            int n2 = this.connection().local().flowController().windowSize(http2Stream);
            n2 = this.initialConnectionWindow - n2;
            this.decoder().flowController().incrementWindowSize(http2Stream, n2);
            this.initialWindowSent = true;
            this.ctx.flush();
        }
    }

    FlowControlPinger flowControlPing() {
        return this.flowControlPing;
    }

    private static final class AllowPingLimiter
    implements PingLimiter {
        private AllowPingLimiter() {
        }

        public final boolean isPingAllowed() {
            return true;
        }
    }

    public static interface PingLimiter {
        public boolean isPingAllowed();
    }

    final class FlowControlPinger {
        private final PingLimiter pingLimiter;
        private int pingCount;
        private int pingReturn;
        private boolean pinging;
        private int dataSizeSincePing;
        private float lastBandwidth;
        private long lastPingTime;

        public FlowControlPinger(PingLimiter pingLimiter) {
            b.a(pingLimiter, (Object)"pingLimiter");
            this.pingLimiter = pingLimiter;
        }

        public final long payload() {
            return 1234L;
        }

        public final void onDataRead(int n2, int n3) {
            if (!AbstractNettyHandler.this.autoTuneFlowControlOn) {
                return;
            }
            if (!this.isPinging() && this.pingLimiter.isPingAllowed()) {
                this.setPinging(true);
                FlowControlPinger flowControlPinger = this;
                flowControlPinger.sendPing(flowControlPinger.AbstractNettyHandler.this.ctx());
            }
            this.incrementDataSincePing(n2 + n3);
        }

        public final void updateWindow() throws Http2Exception {
            if (!AbstractNettyHandler.this.autoTuneFlowControlOn) {
                return;
            }
            ++this.pingReturn;
            long l2 = System.nanoTime() - this.lastPingTime;
            if (l2 == 0L) {
                l2 = 1L;
            }
            long l3 = (long)this.getDataSincePing() * TimeUnit.SECONDS.toNanos(1L) / l2;
            Object object = AbstractNettyHandler.this.decoder().flowController();
            int n2 = Math.min(this.getDataSincePing() << 1, 0x800000);
            this.setPinging(false);
            int n3 = object.initialWindowSize(AbstractNettyHandler.this.connection().connectionStream());
            if (n2 > n3 && (float)l3 > this.lastBandwidth) {
                this.lastBandwidth = l3;
                int n4 = n2 - n3;
                object.incrementWindowSize(AbstractNettyHandler.this.connection().connectionStream(), n4);
                object.initialWindowSize(n2);
                object = new Http2Settings();
                ((Http2Settings)object).initialWindowSize(n2);
                AbstractNettyHandler.this.frameWriter().writeSettings(AbstractNettyHandler.this.ctx(), (Http2Settings)object, AbstractNettyHandler.this.ctx().newPromise());
            }
        }

        private boolean isPinging() {
            return this.pinging;
        }

        private void setPinging(boolean bl) {
            this.pinging = bl;
        }

        private void sendPing(ChannelHandlerContext channelHandlerContext) {
            this.setDataSizeSincePing(0);
            this.lastPingTime = System.nanoTime();
            AbstractNettyHandler.this.encoder().writePing(channelHandlerContext, false, 1234L, channelHandlerContext.newPromise());
            ++this.pingCount;
        }

        private void incrementDataSincePing(int n2) {
            int n3 = this.getDataSincePing();
            this.setDataSizeSincePing(n3 + n2);
        }

        final int getDataSincePing() {
            return this.dataSizeSincePing;
        }

        private void setDataSizeSincePing(int n2) {
            this.dataSizeSincePing = n2;
        }
    }
}

