/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.ClientStreamTracer;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.StreamTracer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StatsTraceContext {
    public static final StatsTraceContext NOOP = new StatsTraceContext(new StreamTracer[0]);
    private final StreamTracer[] tracers;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static StatsTraceContext newClientContext(CallOptions object, Attributes streamTracerArray, Metadata metadata) {
        List<ClientStreamTracer.Factory> list = ((CallOptions)object).getStreamTracerFactories();
        if (list.isEmpty()) {
            return NOOP;
        }
        object = ClientStreamTracer.StreamInfo.newBuilder().setTransportAttrs((Attributes)streamTracerArray).setCallOptions((CallOptions)object).build();
        streamTracerArray = new StreamTracer[list.size()];
        for (int i2 = 0; i2 < streamTracerArray.length; ++i2) {
            streamTracerArray[i2] = list.get(i2).newClientStreamTracer((ClientStreamTracer.StreamInfo)object, metadata);
        }
        return new StatsTraceContext(streamTracerArray);
    }

    StatsTraceContext(StreamTracer[] streamTracerArray) {
        this.tracers = streamTracerArray;
    }

    public final void clientOutboundHeaders() {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            ((ClientStreamTracer)streamTracer).outboundHeaders();
        }
    }

    public final void clientInboundHeaders() {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            ((ClientStreamTracer)streamTracer).inboundHeaders();
        }
    }

    public final void clientInboundTrailers(Metadata metadata) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            ((ClientStreamTracer)streamTracer).inboundTrailers(metadata);
        }
    }

    public final void streamClosed(Status status) {
        if (this.closed.compareAndSet(false, true)) {
            StreamTracer[] streamTracerArray = this.tracers;
            int n2 = this.tracers.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StreamTracer streamTracer = streamTracerArray[i2];
                streamTracer.streamClosed(status);
            }
        }
    }

    public final void outboundMessage(int n2) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n3 = this.tracers.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.outboundMessage(n2);
        }
    }

    public final void inboundMessage(int n2) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n3 = this.tracers.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.inboundMessage(n2);
        }
    }

    public final void outboundMessageSent(int n2, long l2, long l3) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n3 = this.tracers.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.outboundMessageSent(n2, l2, l3);
        }
    }

    public final void inboundMessageRead(int n2, long l2, long l3) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n3 = this.tracers.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.inboundMessageRead(n2, l2, l3);
        }
    }

    public final void outboundUncompressedSize(long l2) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.outboundUncompressedSize(l2);
        }
    }

    public final void outboundWireSize(long l2) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.outboundWireSize(l2);
        }
    }

    public final void inboundUncompressedSize(long l2) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.inboundUncompressedSize(l2);
        }
    }

    public final void inboundWireSize(long l2) {
        StreamTracer[] streamTracerArray = this.tracers;
        int n2 = this.tracers.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StreamTracer streamTracer = streamTracerArray[i2];
            streamTracer.inboundWireSize(l2);
        }
    }
}

