/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.grpc.internal.LongCounter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ReflectionLongAdderCounter
implements LongCounter {
    private static final Logger logger = Logger.getLogger(ReflectionLongAdderCounter.class.getName());
    private static final Constructor<?> defaultConstructor;
    private static final Method addMethod;
    private static final Method sumMethod;
    private static final RuntimeException initializationException;
    private final Object instance;

    ReflectionLongAdderCounter() {
        if (initializationException != null) {
            throw initializationException;
        }
        try {
            this.instance = defaultConstructor.newInstance(new Object[0]);
            return;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    static boolean isAvailable() {
        return initializationException == null;
    }

    public final void add(long l2) {
        try {
            addMethod.invoke(this.instance, l2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    static {
        Constructor<?> constructor = null;
        Method method = null;
        Method method2 = null;
        Throwable throwable = null;
        try {
            Constructor<?>[] constructorArray = Class.forName("java.util.concurrent.atomic.LongAdder");
            method = constructorArray.getMethod("add", Long.TYPE);
            method2 = constructorArray.getMethod("sum", new Class[0]);
            Constructor<?>[] constructorArray2 = constructorArray.getConstructors();
            constructorArray = constructorArray2;
            constructorArray = constructorArray2;
            int n2 = constructorArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> constructor2 = constructorArray[i2];
                if (constructor2.getParameterTypes().length != 0) continue;
                constructor = constructor2;
                break;
            }
        }
        catch (Throwable throwable2) {
            logger.log(Level.FINE, "LongAdder can not be found via reflection, this is normal for JDK7 and below", throwable2);
            throwable = throwable2;
        }
        if (throwable == null && constructor != null) {
            defaultConstructor = constructor;
            addMethod = method;
            sumMethod = method2;
            initializationException = null;
        } else {
            defaultConstructor = null;
            addMethod = null;
            sumMethod = null;
            initializationException = new RuntimeException(throwable);
        }
    }
}

