/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.KnownLength;
import com.appoptics.ext.io.grpc.internal.AbstractReadableBuffer;
import com.appoptics.ext.io.grpc.internal.ForwardingReadableBuffer;
import com.appoptics.ext.io.grpc.internal.ReadableBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;

public final class ReadableBuffers {
    private static final ReadableBuffer EMPTY_BUFFER = new ByteArrayWrapper(new byte[0]);

    public static ReadableBuffer wrap(byte[] byArray, int n2, int n3) {
        return new ByteArrayWrapper(byArray, n2, n3);
    }

    public static byte[] readArray(ReadableBuffer readableBuffer) {
        b.a(readableBuffer, (Object)"buffer");
        int n2 = readableBuffer.readableBytes();
        byte[] byArray = new byte[n2];
        readableBuffer.readBytes(byArray, 0, n2);
        return byArray;
    }

    public static String readAsString(ReadableBuffer object, Charset charset) {
        b.a(charset, (Object)"charset");
        object = ReadableBuffers.readArray((ReadableBuffer)object);
        return new String((byte[])object, charset);
    }

    public static InputStream openStream(ReadableBuffer readableBuffer, boolean bl) {
        return new BufferInputStream(bl ? readableBuffer : ReadableBuffers.ignoreClose(readableBuffer));
    }

    public static ReadableBuffer ignoreClose(ReadableBuffer readableBuffer) {
        return new ForwardingReadableBuffer(readableBuffer){

            public void close() {
            }
        };
    }

    private static final class BufferInputStream
    extends InputStream
    implements KnownLength {
        final ReadableBuffer buffer;

        public BufferInputStream(ReadableBuffer readableBuffer) {
            this.buffer = b.a(readableBuffer, (Object)"buffer");
        }

        public final int available() throws IOException {
            return this.buffer.readableBytes();
        }

        public final int read() {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            return this.buffer.readUnsignedByte();
        }

        public final int read(byte[] byArray, int n2, int n3) throws IOException {
            if (this.buffer.readableBytes() == 0) {
                return -1;
            }
            n3 = Math.min(this.buffer.readableBytes(), n3);
            this.buffer.readBytes(byArray, n2, n3);
            return n3;
        }

        public final void close() throws IOException {
            this.buffer.close();
        }
    }

    private static class ByteArrayWrapper
    extends AbstractReadableBuffer {
        int offset;
        final int end;
        final byte[] bytes;

        ByteArrayWrapper(byte[] byArray) {
            this(byArray, 0, byArray.length);
        }

        ByteArrayWrapper(byte[] byArray, int n2, int n3) {
            b.a(n2 >= 0, (Object)"offset must be >= 0");
            b.a(n3 >= 0, (Object)"length must be >= 0");
            b.a(n2 + n3 <= byArray.length, (Object)"offset + length exceeds array boundary");
            this.bytes = b.a(byArray, (Object)"bytes");
            this.offset = n2;
            this.end = n2 + n3;
        }

        public int readableBytes() {
            return this.end - this.offset;
        }

        public int readUnsignedByte() {
            this.checkReadable(1);
            return this.bytes[this.offset++] & 0xFF;
        }

        public void readBytes(byte[] byArray, int n2, int n3) {
            System.arraycopy(this.bytes, this.offset, byArray, n2, n3);
            this.offset += n3;
        }

        public ByteArrayWrapper readBytes(int n2) {
            this.checkReadable(n2);
            int n3 = this.offset;
            this.offset += n2;
            return new ByteArrayWrapper(this.bytes, n3, n2);
        }
    }
}

