/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.HttpConnectProxiedSocketAddress;
import com.appoptics.ext.io.grpc.ProxiedSocketAddress;
import com.appoptics.ext.io.grpc.ProxyDetector;
import com.appoptics.ext.io.grpc.internal.GrpcUtil;
import com.tracelytics.a.d.a.a.m;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProxyDetectorImpl
implements ProxyDetector {
    private static final Logger log = Logger.getLogger(ProxyDetectorImpl.class.getName());
    private static final AuthenticationProvider DEFAULT_AUTHENTICATOR = new AuthenticationProvider(){

        public PasswordAuthentication requestPasswordAuthentication(String string, InetAddress inetAddress, int n2, String string2, String string3, String string4) {
            URL uRL = null;
            try {
                uRL = new URL(string2, string, n2, "");
            }
            catch (MalformedURLException malformedURLException) {
                log.log(Level.WARNING, String.format("failed to create URL for Authenticator: %s %s", string2, string));
            }
            return Authenticator.requestPasswordAuthentication(string, inetAddress, n2, string2, string3, string4, uRL, Authenticator.RequestorType.PROXY);
        }
    };
    private static final m<ProxySelector> DEFAULT_PROXY_SELECTOR = new m<ProxySelector>(){

        @Override
        public ProxySelector get() {
            return ProxySelector.getDefault();
        }
    };
    private final m<ProxySelector> proxySelector;
    private final AuthenticationProvider authenticationProvider;
    private final InetSocketAddress overrideProxyAddress;

    public ProxyDetectorImpl() {
        this(DEFAULT_PROXY_SELECTOR, DEFAULT_AUTHENTICATOR, System.getenv("GRPC_PROXY_EXP"));
    }

    ProxyDetectorImpl(m<ProxySelector> m2, AuthenticationProvider authenticationProvider, String string) {
        this.proxySelector = b.a(m2);
        this.authenticationProvider = b.a(authenticationProvider);
        if (string != null) {
            this.overrideProxyAddress = ProxyDetectorImpl.overrideProxy(string);
            return;
        }
        this.overrideProxyAddress = null;
    }

    @Override
    public ProxiedSocketAddress proxyFor(SocketAddress socketAddress) throws IOException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            return null;
        }
        if (this.overrideProxyAddress != null) {
            return HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress(this.overrideProxyAddress).setTargetAddress((InetSocketAddress)socketAddress).build();
        }
        return this.detectProxy((InetSocketAddress)socketAddress);
    }

    private ProxiedSocketAddress detectProxy(InetSocketAddress inetSocketAddress) throws IOException {
        Object object;
        Object object2;
        try {
            object2 = GrpcUtil.getHost(inetSocketAddress);
        }
        catch (Throwable throwable) {
            log.log(Level.WARNING, "Failed to get host for proxy lookup, proceeding without proxy", throwable);
            return null;
        }
        try {
            object2 = new URI("https", null, (String)object2, inetSocketAddress.getPort(), null, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            log.log(Level.WARNING, "Failed to construct URI for proxy lookup, proceeding without proxy", uRISyntaxException);
            return null;
        }
        Object object3 = this.proxySelector.get();
        if (object3 == null) {
            log.log(Level.FINE, "proxy selector is null, so continuing without proxy lookup");
            return null;
        }
        if ((object2 = ((ProxySelector)object3).select((URI)object2)).size() > 1) {
            log.warning("More than 1 proxy detected, gRPC will select the first one");
        }
        if (((Proxy)(object2 = object2.get(0))).type() == Proxy.Type.DIRECT) {
            return null;
        }
        object2 = (InetSocketAddress)((Proxy)object2).address();
        object3 = "";
        object3 = this.authenticationProvider.requestPasswordAuthentication(GrpcUtil.getHost((InetSocketAddress)object2), ((InetSocketAddress)object2).getAddress(), ((InetSocketAddress)object2).getPort(), "https", (String)object3, null);
        if (((InetSocketAddress)object2).isUnresolved()) {
            object = InetAddress.getByName(((InetSocketAddress)object2).getHostName());
            object2 = new InetSocketAddress((InetAddress)object, ((InetSocketAddress)object2).getPort());
        }
        object = HttpConnectProxiedSocketAddress.newBuilder().setTargetAddress(inetSocketAddress).setProxyAddress((SocketAddress)object2);
        if (object3 == null) {
            return ((HttpConnectProxiedSocketAddress.Builder)object).build();
        }
        return ((HttpConnectProxiedSocketAddress.Builder)object).setUsername(((PasswordAuthentication)object3).getUserName()).setPassword(((PasswordAuthentication)object3).getPassword() == null ? null : new String(((PasswordAuthentication)object3).getPassword())).build();
    }

    private static InetSocketAddress overrideProxy(String stringArray) {
        if (stringArray == null) {
            return null;
        }
        stringArray = stringArray.split(":", 2);
        int n2 = 80;
        if (stringArray.length > 1) {
            n2 = Integer.parseInt(stringArray[1]);
        }
        log.warning("Detected GRPC_PROXY_EXP and will honor it, but this feature will be removed in a future release. Use the JVM flags \"-Dhttps.proxyHost=HOST -Dhttps.proxyPort=PORT\" to set the https proxy for this JVM.");
        return new InetSocketAddress(stringArray[0], n2);
    }

    static interface AuthenticationProvider {
        public PasswordAuthentication requestPasswordAuthentication(String var1, InetAddress var2, int var3, String var4, String var5, String var6);
    }
}

