/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.internal.BackoffPolicy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class ExponentialBackoffPolicy
implements BackoffPolicy {
    private Random random = new Random();
    private long initialBackoffNanos = TimeUnit.SECONDS.toNanos(1L);
    private long maxBackoffNanos = TimeUnit.MINUTES.toNanos(2L);
    private double multiplier = 1.6;
    private double jitter = 0.2;
    private long nextBackoffNanos = this.initialBackoffNanos;

    public final long nextBackoffNanos() {
        long l2 = this.nextBackoffNanos;
        this.nextBackoffNanos = Math.min((long)((double)l2 * this.multiplier), this.maxBackoffNanos);
        ExponentialBackoffPolicy exponentialBackoffPolicy = this;
        return l2 + exponentialBackoffPolicy.uniformRandom(-exponentialBackoffPolicy.jitter * (double)l2, this.jitter * (double)l2);
    }

    private long uniformRandom(double d2, double d3) {
        b.a(d3 >= d2);
        double d4 = d3 - d2;
        return (long)(this.random.nextDouble() * d4 + d2);
    }

    public static final class Provider
    implements BackoffPolicy.Provider {
        public final BackoffPolicy get() {
            return new ExponentialBackoffPolicy();
        }
    }
}

