/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc.internal;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.InternalChannelz;
import com.appoptics.ext.io.grpc.InternalLogId;
import com.appoptics.ext.io.grpc.internal.ChannelTracer;
import com.appoptics.ext.io.grpc.internal.TimeProvider;
import java.text.MessageFormat;
import java.util.logging.Level;

final class ChannelLoggerImpl
extends ChannelLogger {
    private final ChannelTracer tracer;
    private final TimeProvider time;

    ChannelLoggerImpl(ChannelTracer channelTracer, TimeProvider timeProvider) {
        this.tracer = b.a(channelTracer, (Object)"tracer");
        this.time = b.a(timeProvider, (Object)"time");
    }

    public final void log(ChannelLogger.ChannelLogLevel channelLogLevel, String string) {
        ChannelLoggerImpl.logOnly(this.tracer.getLogId(), channelLogLevel, string);
        if (this.isTraceable(channelLogLevel)) {
            this.trace(channelLogLevel, string);
        }
    }

    public final void log(ChannelLogger.ChannelLogLevel channelLogLevel, String string, Object ... objectArray) {
        String string2 = null;
        Level level = ChannelLoggerImpl.toJavaLogLevel(channelLogLevel);
        if (this.isTraceable(channelLogLevel) || ChannelTracer.logger.isLoggable(level)) {
            string2 = MessageFormat.format(string, objectArray);
        }
        this.log(channelLogLevel, string2);
    }

    static void logOnly(InternalLogId internalLogId, ChannelLogger.ChannelLogLevel object, String string) {
        if (ChannelTracer.logger.isLoggable((Level)(object = ChannelLoggerImpl.toJavaLogLevel(object)))) {
            ChannelTracer.logOnly(internalLogId, (Level)object, string);
        }
    }

    static void logOnly(InternalLogId internalLogId, ChannelLogger.ChannelLogLevel object, String string, Object ... objectArray) {
        if (ChannelTracer.logger.isLoggable((Level)(object = ChannelLoggerImpl.toJavaLogLevel(object)))) {
            string = MessageFormat.format(string, objectArray);
            ChannelTracer.logOnly(internalLogId, (Level)object, string);
        }
    }

    private boolean isTraceable(ChannelLogger.ChannelLogLevel channelLogLevel) {
        return channelLogLevel != ChannelLogger.ChannelLogLevel.DEBUG && this.tracer.isTraceEnabled();
    }

    private void trace(ChannelLogger.ChannelLogLevel channelLogLevel, String string) {
        if (channelLogLevel == ChannelLogger.ChannelLogLevel.DEBUG) {
            return;
        }
        this.tracer.traceOnly(new InternalChannelz.ChannelTrace.Event.Builder().setDescription(string).setSeverity(ChannelLoggerImpl.toTracerSeverity(channelLogLevel)).setTimestampNanos(this.time.currentTimeNanos()).build());
    }

    private static InternalChannelz.ChannelTrace.Event.Severity toTracerSeverity(ChannelLogger.ChannelLogLevel channelLogLevel) {
        switch (channelLogLevel) {
            case ERROR: {
                return InternalChannelz.ChannelTrace.Event.Severity.CT_ERROR;
            }
            case WARNING: {
                return InternalChannelz.ChannelTrace.Event.Severity.CT_WARNING;
            }
        }
        return InternalChannelz.ChannelTrace.Event.Severity.CT_INFO;
    }

    private static Level toJavaLogLevel(ChannelLogger.ChannelLogLevel channelLogLevel) {
        switch (channelLogLevel) {
            case ERROR: {
                return Level.FINE;
            }
            case WARNING: {
                return Level.FINER;
            }
        }
        return Level.FINEST;
    }
}

