/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.grpc.Context;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ThreadLocalContextStorage
extends Context.Storage {
    private static final Logger log = Logger.getLogger(ThreadLocalContextStorage.class.getName());
    static final ThreadLocal<Context> localContext = new ThreadLocal();

    ThreadLocalContextStorage() {
    }

    public final Context doAttach(Context context) {
        Context context2 = this.current();
        localContext.set(context);
        return context2;
    }

    public final void detach(Context context, Context context2) {
        if (this.current() != context) {
            log.log(Level.SEVERE, "Context was not attached when detaching", new Throwable().fillInStackTrace());
        }
        if (context2 != Context.ROOT) {
            localContext.set(context2);
            return;
        }
        localContext.set(null);
    }

    public final Context current() {
        Context context = localContext.get();
        if (context == null) {
            return Context.ROOT;
        }
        return context;
    }
}

