/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.Attributes;
import com.appoptics.ext.io.grpc.CallOptions;
import com.appoptics.ext.io.grpc.ChannelLogger;
import com.appoptics.ext.io.grpc.ClientStreamTracer;
import com.appoptics.ext.io.grpc.ConnectivityState;
import com.appoptics.ext.io.grpc.ConnectivityStateInfo;
import com.appoptics.ext.io.grpc.EquivalentAddressGroup;
import com.appoptics.ext.io.grpc.Metadata;
import com.appoptics.ext.io.grpc.MethodDescriptor;
import com.appoptics.ext.io.grpc.Status;
import com.appoptics.ext.io.grpc.SynchronizationContext;
import com.tracelytics.a.d.a.a.d;
import com.tracelytics.a.d.a.a.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoadBalancer {
    public static final Attributes.Key<Map<String, ?>> ATTR_HEALTH_CHECKING_CONFIG = Attributes.Key.create("health-checking-config");
    private int recursionCount;

    @Deprecated
    public void handleResolvedAddressGroups(List<EquivalentAddressGroup> list, Attributes attributes) {
        if (this.recursionCount++ == 0) {
            this.handleResolvedAddresses(ResolvedAddresses.newBuilder().setAddresses(list).setAttributes(attributes).build());
        }
        this.recursionCount = 0;
    }

    public void handleResolvedAddresses(ResolvedAddresses resolvedAddresses) {
        if (this.recursionCount++ == 0) {
            this.handleResolvedAddressGroups(resolvedAddresses.getAddresses(), resolvedAddresses.getAttributes());
        }
        this.recursionCount = 0;
    }

    public abstract void handleNameResolutionError(Status var1);

    public abstract void shutdown();

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return false;
    }

    public static abstract class Factory {
        public abstract LoadBalancer newLoadBalancer(Helper var1);
    }

    public static interface SubchannelStateListener {
        public void onSubchannelState(ConnectivityStateInfo var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Subchannel {
        public void start(SubchannelStateListener subchannelStateListener) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public abstract void shutdown();

        public abstract void requestConnection();

        public final EquivalentAddressGroup getAddresses() {
            List<EquivalentAddressGroup> list = this.getAllAddresses();
            b.b(list.size() == 1, "%s does not have exactly one group", list);
            return list.get(0);
        }

        public List<EquivalentAddressGroup> getAllAddresses() {
            throw new UnsupportedOperationException();
        }

        public abstract Attributes getAttributes();

        public void updateAddresses(List<EquivalentAddressGroup> list) {
            throw new UnsupportedOperationException();
        }

        public Object getInternalSubchannel() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Helper {
        public Subchannel createSubchannel(CreateSubchannelArgs createSubchannelArgs) {
            throw new UnsupportedOperationException();
        }

        public abstract void updateBalancingState(ConnectivityState var1, SubchannelPicker var2);

        public SynchronizationContext getSynchronizationContext() {
            throw new UnsupportedOperationException();
        }

        public ChannelLogger getChannelLogger() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CreateSubchannelArgs {
        private final List<EquivalentAddressGroup> addrs;
        private final Attributes attrs;
        private final Object[][] customOptions;

        private CreateSubchannelArgs(List<EquivalentAddressGroup> list, Attributes attributes, Object[][] objectArray) {
            this.addrs = b.a(list, (Object)"addresses are not set");
            this.attrs = b.a(attributes, (Object)"attrs");
            this.customOptions = b.a(objectArray, (Object)"customOptions");
        }

        public final List<EquivalentAddressGroup> getAddresses() {
            return this.addrs;
        }

        public final Attributes getAttributes() {
            return this.attrs;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public final String toString() {
            return g.a(this).a("addrs", this.addrs).a("attrs", this.attrs).a("customOptions", Arrays.deepToString((Object[])this.customOptions)).toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Builder {
            private List<EquivalentAddressGroup> addrs;
            private Attributes attrs = Attributes.EMPTY;
            private Object[][] customOptions = new Object[0][2];

            Builder() {
            }

            public final Builder setAddresses(EquivalentAddressGroup equivalentAddressGroup) {
                this.addrs = Collections.singletonList(equivalentAddressGroup);
                return this;
            }

            public final Builder setAddresses(List<EquivalentAddressGroup> list) {
                b.a(!list.isEmpty(), (Object)"addrs is empty");
                this.addrs = Collections.unmodifiableList(new ArrayList<EquivalentAddressGroup>(list));
                return this;
            }

            public final Builder setAttributes(Attributes attributes) {
                this.attrs = b.a(attributes, (Object)"attrs");
                return this;
            }

            public final CreateSubchannelArgs build() {
                return new CreateSubchannelArgs(this.addrs, this.attrs, this.customOptions);
            }
        }
    }

    public static final class PickResult {
        private static final PickResult NO_RESULT = new PickResult(null, null, Status.OK, false);
        private final Subchannel subchannel;
        private final ClientStreamTracer.Factory streamTracerFactory;
        private final Status status;
        private final boolean drop;

        private PickResult(Subchannel subchannel, ClientStreamTracer.Factory factory, Status status, boolean bl) {
            this.subchannel = subchannel;
            this.streamTracerFactory = factory;
            this.status = b.a(status, (Object)"status");
            this.drop = bl;
        }

        public static PickResult withSubchannel(Subchannel subchannel, ClientStreamTracer.Factory factory) {
            return new PickResult(b.a(subchannel, (Object)"subchannel"), factory, Status.OK, false);
        }

        public static PickResult withSubchannel(Subchannel subchannel) {
            return PickResult.withSubchannel(subchannel, null);
        }

        public static PickResult withError(Status status) {
            b.a(!status.isOk(), (Object)"error status shouldn't be OK");
            return new PickResult(null, null, status, false);
        }

        public static PickResult withDrop(Status status) {
            b.a(!status.isOk(), (Object)"drop status shouldn't be OK");
            return new PickResult(null, null, status, true);
        }

        public static PickResult withNoResult() {
            return NO_RESULT;
        }

        public final Subchannel getSubchannel() {
            return this.subchannel;
        }

        public final ClientStreamTracer.Factory getStreamTracerFactory() {
            return this.streamTracerFactory;
        }

        public final Status getStatus() {
            return this.status;
        }

        public final boolean isDrop() {
            return this.drop;
        }

        public final String toString() {
            return g.a(this).a("subchannel", this.subchannel).a("streamTracerFactory", this.streamTracerFactory).a("status", this.status).a("drop", this.drop).toString();
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.subchannel, this.status, this.streamTracerFactory, this.drop};
            return Arrays.hashCode(objectArray);
        }

        public final boolean equals(Object object) {
            if (!(object instanceof PickResult)) {
                return false;
            }
            object = (PickResult)object;
            return d.a(this.subchannel, (Object)((PickResult)object).subchannel) && d.a(this.status, (Object)((PickResult)object).status) && d.a(this.streamTracerFactory, (Object)((PickResult)object).streamTracerFactory) && this.drop == ((PickResult)object).drop;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PickSubchannelArgs {
        public abstract CallOptions getCallOptions();

        public abstract Metadata getHeaders();

        public abstract MethodDescriptor<?, ?> getMethodDescriptor();
    }

    public static abstract class SubchannelPicker {
        public abstract PickResult pickSubchannel(PickSubchannelArgs var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ResolvedAddresses {
        private final List<EquivalentAddressGroup> addresses;
        private final Attributes attributes;
        private final Object loadBalancingPolicyConfig;

        private ResolvedAddresses(List<EquivalentAddressGroup> list, Attributes attributes, Object object) {
            this.addresses = Collections.unmodifiableList(new ArrayList(b.a(list, (Object)"addresses")));
            this.attributes = b.a(attributes, (Object)"attributes");
            this.loadBalancingPolicyConfig = object;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public final List<EquivalentAddressGroup> getAddresses() {
            return this.addresses;
        }

        public final Attributes getAttributes() {
            return this.attributes;
        }

        public final Object getLoadBalancingPolicyConfig() {
            return this.loadBalancingPolicyConfig;
        }

        public final String toString() {
            return g.a(this).a("addresses", this.addresses).a("attributes", this.attributes).a("loadBalancingPolicyConfig", this.loadBalancingPolicyConfig).toString();
        }

        public final int hashCode() {
            Object[] objectArray = new Object[]{this.addresses, this.attributes, this.loadBalancingPolicyConfig};
            return Arrays.hashCode(objectArray);
        }

        public final boolean equals(Object object) {
            if (!(object instanceof ResolvedAddresses)) {
                return false;
            }
            object = (ResolvedAddresses)object;
            return d.a(this.addresses, ((ResolvedAddresses)object).addresses) && d.a(this.attributes, (Object)((ResolvedAddresses)object).attributes) && d.a(this.loadBalancingPolicyConfig, ((ResolvedAddresses)object).loadBalancingPolicyConfig);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class Builder {
            private List<EquivalentAddressGroup> addresses;
            private Attributes attributes = Attributes.EMPTY;
            private Object loadBalancingPolicyConfig;

            Builder() {
            }

            public final Builder setAddresses(List<EquivalentAddressGroup> list) {
                this.addresses = list;
                return this;
            }

            public final Builder setAttributes(Attributes attributes) {
                this.attributes = attributes;
                return this;
            }

            public final Builder setLoadBalancingPolicyConfig(Object object) {
                this.loadBalancingPolicyConfig = object;
                return this;
            }

            public final ResolvedAddresses build() {
                return new ResolvedAddresses(this.addresses, this.attributes, this.loadBalancingPolicyConfig);
            }
        }
    }
}

