/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.grpc.Deadline;
import com.appoptics.ext.io.grpc.PersistentHashArrayMappedTrie;
import com.appoptics.ext.io.grpc.ThreadLocalContextStorage;
import java.io.Closeable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    static final Logger log = Logger.getLogger(Context.class.getName());
    public static final Context ROOT = new Context();
    final CancellableContext cancellableAncestor = null;
    final PersistentHashArrayMappedTrie.Node<Object<?>, Object> keyValueEntries = null;
    final int generation;

    static Storage storage() {
        return LazyStorage.storage;
    }

    public static Context current() {
        Context context = Context.storage().current();
        if (context == null) {
            return ROOT;
        }
        return context;
    }

    private Context() {
        this.generation = 0;
        Context.validateGeneration(this.generation);
    }

    public Context attach() {
        Context context = Context.storage().doAttach(this);
        if (context == null) {
            return ROOT;
        }
        return context;
    }

    public void detach(Context context) {
        Context.checkNotNull(context, "toAttach");
        Context.storage().detach(this, context);
    }

    public boolean isCancelled() {
        if (this.cancellableAncestor == null) {
            return false;
        }
        return this.cancellableAncestor.isCancelled();
    }

    public Throwable cancellationCause() {
        if (this.cancellableAncestor == null) {
            return null;
        }
        return this.cancellableAncestor.cancellationCause();
    }

    public Deadline getDeadline() {
        if (this.cancellableAncestor == null) {
            return null;
        }
        return this.cancellableAncestor.getDeadline();
    }

    public void addListener(CancellationListener cancellationListener, Executor executor) {
        Context.checkNotNull(cancellationListener, "cancellationListener");
        Context.checkNotNull(executor, "executor");
        if (this.cancellableAncestor == null) {
            return;
        }
        this.cancellableAncestor.addListenerInternal(new ExecutableListener(executor, cancellationListener, this));
    }

    public void removeListener(CancellationListener cancellationListener) {
        if (this.cancellableAncestor == null) {
            return;
        }
        this.cancellableAncestor.removeListenerInternal(cancellationListener, this);
    }

    static <T> T checkNotNull(T t2, Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    private static void validateGeneration(int n2) {
        if (n2 == 1000) {
            log.log(Level.SEVERE, "Context ancestry chain length is abnormally long. This suggests an error in application code. Length exceeded: 1000", new Exception());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DirectExecutor implements Executor
    {
        INSTANCE;


        @Override
        public final void execute(Runnable runnable) {
            runnable.run();
        }

        public final String toString() {
            return "Context.DirectExecutor";
        }
    }

    private static final class ExecutableListener
    implements Runnable {
        private final Executor executor;
        final CancellationListener listener;
        private final Context context;

        ExecutableListener(Executor executor, CancellationListener cancellationListener, Context context) {
            this.executor = executor;
            this.listener = cancellationListener;
            this.context = context;
        }

        final void deliver() {
            try {
                this.executor.execute(this);
                return;
            }
            catch (Throwable throwable) {
                log.log(Level.INFO, "Exception notifying context listener", throwable);
                return;
            }
        }

        public final void run() {
            this.listener.cancelled(this.context);
        }
    }

    public static abstract class Storage {
        @Deprecated
        public void attach(Context context) {
            throw new UnsupportedOperationException("Deprecated. Do not call.");
        }

        public Context doAttach(Context context) {
            Context context2 = this.current();
            this.attach(context);
            return context2;
        }

        public abstract void detach(Context var1, Context var2);

        public abstract Context current();
    }

    public static interface CancellationListener {
        public void cancelled(Context var1);
    }

    public static final class CancellableContext
    extends Context
    implements Closeable {
        private final Deadline deadline;
        private final Context uncancellableSurrogate;
        private ArrayList<ExecutableListener> listeners;
        private CancellationListener parentListener;
        private Throwable cancellationCause;
        private ScheduledFuture<?> pendingDeadline;
        private boolean cancelled;

        public final Context attach() {
            return this.uncancellableSurrogate.attach();
        }

        public final void detach(Context context) {
            this.uncancellableSurrogate.detach(context);
        }

        public final void addListener(CancellationListener cancellationListener, Executor executor) {
            CancellableContext.checkNotNull(cancellationListener, "cancellationListener");
            CancellableContext.checkNotNull(executor, "executor");
            this.addListenerInternal(new ExecutableListener(executor, cancellationListener, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListenerInternal(ExecutableListener executableListener) {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.isCancelled()) {
                    executableListener.deliver();
                } else if (this.listeners == null) {
                    this.listeners = new ArrayList();
                    this.listeners.add(executableListener);
                    if (this.cancellableAncestor != null) {
                        this.parentListener = new CancellationListener(){

                            public void cancelled(Context context) {
                                CancellableContext.this.cancel(context.cancellationCause());
                            }
                        };
                        this.cancellableAncestor.addListenerInternal(new ExecutableListener(DirectExecutor.INSTANCE, this.parentListener, this));
                    }
                } else {
                    this.listeners.add(executableListener);
                }
                return;
            }
        }

        public final void removeListener(CancellationListener cancellationListener) {
            this.removeListenerInternal(cancellationListener, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeListenerInternal(CancellationListener cancellationListener, Context context) {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.listeners != null) {
                    for (int i2 = this.listeners.size() - 1; i2 >= 0; --i2) {
                        ExecutableListener executableListener = this.listeners.get(i2);
                        if (executableListener.listener != cancellationListener || executableListener.context != context) continue;
                        this.listeners.remove(i2);
                        break;
                    }
                    if (this.listeners.isEmpty()) {
                        if (this.cancellableAncestor != null) {
                            this.cancellableAncestor.removeListener(this.parentListener);
                        }
                        this.parentListener = null;
                        this.listeners = null;
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean cancel(Throwable throwable) {
            boolean bl = false;
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (!this.cancelled) {
                    this.cancelled = true;
                    if (this.pendingDeadline != null) {
                        this.pendingDeadline.cancel(false);
                        this.pendingDeadline = null;
                    }
                    this.cancellationCause = throwable;
                    bl = true;
                }
            }
            if (bl) {
                this.notifyAndClearListeners();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAndClearListeners() {
            ArrayList<ExecutableListener> arrayList;
            CancellationListener cancellationListener;
            Iterator<ExecutableListener> iterator = this;
            synchronized (iterator) {
                if (this.listeners == null) {
                    return;
                }
                cancellationListener = this.parentListener;
                this.parentListener = null;
                arrayList = this.listeners;
                this.listeners = null;
            }
            for (ExecutableListener executableListener : arrayList) {
                if (executableListener.context != this) continue;
                executableListener.deliver();
            }
            for (ExecutableListener executableListener : arrayList) {
                if (executableListener.context == this) continue;
                executableListener.deliver();
            }
            if (this.cancellableAncestor != null) {
                this.cancellableAncestor.removeListener(cancellationListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isCancelled() {
            CancellableContext cancellableContext = this;
            synchronized (cancellableContext) {
                if (this.cancelled) {
                    return true;
                }
            }
            if (super.isCancelled()) {
                CancellableContext cancellableContext2 = this;
                cancellableContext2.cancel(super.cancellationCause());
                return true;
            }
            return false;
        }

        public final Throwable cancellationCause() {
            if (this.isCancelled()) {
                return this.cancellationCause;
            }
            return null;
        }

        public final Deadline getDeadline() {
            return this.deadline;
        }

        public final void close() {
            this.cancel(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LazyStorage {
        static final Storage storage;

        private static Storage createStorage(AtomicReference<? super ClassNotFoundException> atomicReference) {
            try {
                Class<?> clazz = Class.forName("com.appoptics.ext.io.grpc.override.ContextStorageOverride");
                return clazz.asSubclass(Storage.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                atomicReference.set(classNotFoundException);
                return new ThreadLocalContextStorage();
            }
            catch (Exception exception) {
                throw new RuntimeException("Storage override failed to initialize", exception);
            }
        }

        static {
            Serializable serializable = new AtomicReference();
            storage = LazyStorage.createStorage(serializable);
            if ((serializable = (Throwable)serializable.get()) != null) {
                log.log(Level.FINE, "Storage override doesn't exist. Using default", (Throwable)serializable);
            }
        }
    }
}

