/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.grpc.Codec;
import com.appoptics.ext.io.grpc.Compressor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CompressorRegistry {
    private static final CompressorRegistry DEFAULT_INSTANCE = new CompressorRegistry(new Codec.Gzip(), Codec.Identity.NONE);
    private final ConcurrentMap<String, Compressor> compressors = new ConcurrentHashMap<String, Compressor>();

    public static CompressorRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    CompressorRegistry(Compressor ... compressorArray) {
        for (Compressor compressor : compressorArray) {
            this.compressors.put(compressor.getMessageEncoding(), compressor);
        }
    }

    public final Compressor lookupCompressor(String string) {
        return (Compressor)this.compressors.get(string);
    }
}

