/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.grpc.Compressor;
import com.appoptics.ext.io.grpc.Decompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public interface Codec
extends Compressor,
Decompressor {

    public static final class Identity
    implements Codec {
        public static final Codec NONE = new Identity();

        public final InputStream decompress(InputStream inputStream) {
            return inputStream;
        }

        public final String getMessageEncoding() {
            return "identity";
        }

        public final OutputStream compress(OutputStream outputStream) {
            return outputStream;
        }

        private Identity() {
        }
    }

    public static final class Gzip
    implements Codec {
        public final String getMessageEncoding() {
            return "gzip";
        }

        public final OutputStream compress(OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }

        public final InputStream decompress(InputStream inputStream) throws IOException {
            return new GZIPInputStream(inputStream);
        }
    }
}

