/*
 * Decompiled with CFR 0.152.
 */
package com.appoptics.ext.io.grpc;

import com.appoptics.ext.io.a.b;
import com.appoptics.ext.io.grpc.CallCredentials;
import com.appoptics.ext.io.grpc.ClientStreamTracer;
import com.appoptics.ext.io.grpc.Deadline;
import com.tracelytics.a.d.a.a.g;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallOptions {
    public static final CallOptions DEFAULT = new CallOptions();
    private Deadline deadline;
    private Executor executor;
    private String authority;
    private CallCredentials credentials;
    private String compressorName;
    private Object[][] customOptions = new Object[0][2];
    private List<ClientStreamTracer.Factory> streamTracerFactories = Collections.emptyList();
    private Boolean waitForReady;
    private Integer maxInboundMessageSize;
    private Integer maxOutboundMessageSize;

    public final CallOptions withCompression(String string) {
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).compressorName = string;
        return callOptions;
    }

    public final CallOptions withDeadline(Deadline deadline) {
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).deadline = deadline;
        return callOptions;
    }

    public final Deadline getDeadline() {
        return this.deadline;
    }

    public final CallOptions withWaitForReady() {
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).waitForReady = Boolean.TRUE;
        return callOptions;
    }

    public final CallOptions withoutWaitForReady() {
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).waitForReady = Boolean.FALSE;
        return callOptions;
    }

    public final String getCompressor() {
        return this.compressorName;
    }

    public final String getAuthority() {
        return this.authority;
    }

    public final CallCredentials getCredentials() {
        return this.credentials;
    }

    public final CallOptions withExecutor(Executor executor) {
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).executor = executor;
        return callOptions;
    }

    public final CallOptions withStreamTracerFactory(ClientStreamTracer.Factory factory) {
        CallOptions callOptions = new CallOptions(this);
        ArrayList<ClientStreamTracer.Factory> arrayList = new ArrayList<ClientStreamTracer.Factory>(this.streamTracerFactories.size() + 1);
        arrayList.addAll(this.streamTracerFactories);
        arrayList.add(factory);
        callOptions.streamTracerFactories = Collections.unmodifiableList(arrayList);
        return callOptions;
    }

    public final List<ClientStreamTracer.Factory> getStreamTracerFactories() {
        return this.streamTracerFactories;
    }

    public final <T> CallOptions withOption(Key<T> key, T t2) {
        b.a(key, (Object)"key");
        b.a(t2, (Object)"value");
        CallOptions callOptions = new CallOptions(this);
        int n2 = -1;
        for (int i2 = 0; i2 < this.customOptions.length; ++i2) {
            if (!key.equals(this.customOptions[i2][0])) continue;
            n2 = i2;
            break;
        }
        callOptions.customOptions = new Object[this.customOptions.length + (n2 == -1 ? 1 : 0)][2];
        System.arraycopy(this.customOptions, 0, callOptions.customOptions, 0, this.customOptions.length);
        if (n2 == -1) {
            callOptions.customOptions[this.customOptions.length] = new Object[]{key, t2};
        } else {
            callOptions.customOptions[n2] = new Object[]{key, t2};
        }
        return callOptions;
    }

    public final <T> T getOption(Key<T> key) {
        b.a(key, (Object)"key");
        for (int i2 = 0; i2 < this.customOptions.length; ++i2) {
            if (!key.equals(this.customOptions[i2][0])) continue;
            return (T)this.customOptions[i2][1];
        }
        return (T)((Key)key).defaultValue;
    }

    public final Executor getExecutor() {
        return this.executor;
    }

    private CallOptions() {
    }

    public final boolean isWaitForReady() {
        return Boolean.TRUE.equals(this.waitForReady);
    }

    public final CallOptions withMaxInboundMessageSize(int n2) {
        b.a(n2 >= 0, "invalid maxsize %s", n2);
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).maxInboundMessageSize = n2;
        return callOptions;
    }

    public final CallOptions withMaxOutboundMessageSize(int n2) {
        b.a(n2 >= 0, "invalid maxsize %s", n2);
        CallOptions callOptions = new CallOptions(this);
        new CallOptions(this).maxOutboundMessageSize = n2;
        return callOptions;
    }

    public final Integer getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    public final Integer getMaxOutboundMessageSize() {
        return this.maxOutboundMessageSize;
    }

    private CallOptions(CallOptions callOptions) {
        this.deadline = callOptions.deadline;
        this.authority = callOptions.authority;
        this.credentials = callOptions.credentials;
        this.executor = callOptions.executor;
        this.compressorName = callOptions.compressorName;
        this.customOptions = callOptions.customOptions;
        this.waitForReady = callOptions.waitForReady;
        this.maxInboundMessageSize = callOptions.maxInboundMessageSize;
        this.maxOutboundMessageSize = callOptions.maxOutboundMessageSize;
        this.streamTracerFactories = callOptions.streamTracerFactories;
    }

    public final String toString() {
        return g.a(this).a("deadline", this.deadline).a("authority", this.authority).a("callCredentials", this.credentials).a("executor", this.executor != null ? this.executor.getClass() : null).a("compressorName", this.compressorName).a("customOptions", Arrays.deepToString((Object[])this.customOptions)).a("waitForReady", this.isWaitForReady()).a("maxInboundMessageSize", this.maxInboundMessageSize).a("maxOutboundMessageSize", this.maxOutboundMessageSize).a("streamTracerFactories", this.streamTracerFactories).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Key<T> {
        private final String debugString;
        private final T defaultValue;

        private Key(String string, T t2) {
            this.debugString = string;
            this.defaultValue = t2;
        }

        public final String toString() {
            return this.debugString;
        }

        public static <T> Key<T> create(String string) {
            b.a(string, (Object)"debugString");
            return new Key<Object>(string, null);
        }
    }
}

