/*
 * Decompiled with CFR 0.152.
 */
package com.appodeal.ads.adapters.admob.unified;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.appodeal.ads.AdNetwork;
import com.appodeal.ads.AdNetworkBuilder;
import com.appodeal.ads.AdNetworkMediationParams;
import com.appodeal.ads.AdUnit;
import com.appodeal.ads.NetworkInitializationListener;
import com.appodeal.ads.adapters.admob.unified.UnifiedAdmobRequestParams;
import com.appodeal.ads.modules.common.internal.context.ContextProvider;
import com.appodeal.ads.networking.LoadingError;
import com.appodeal.ads.utils.ActivityRule;
import com.appodeal.ads.utils.Log;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.RequestConfiguration;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONObject;

public abstract class UnifiedAdmobNetwork<AdRequestType extends AdRequest, AdRequestBuilderType extends AdRequest.Builder>
extends AdNetwork<UnifiedAdmobRequestParams<AdRequestType>> {
    private static boolean isInitialized;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public UnifiedAdmobNetwork(AdNetworkBuilder adNetworkBuilder) {
        super(adNetworkBuilder);
    }

    @NonNull
    private UnifiedAdmobRequestParams<AdRequestType> createParams(@NonNull AdRequestType AdRequestType, @NonNull String string, @Nullable Boolean bl, boolean bl2, boolean bl3) {
        return new UnifiedAdmobRequestParams<AdRequestType>(AdRequestType, string, bl, bl2, bl3);
    }

    private void setMediatorName(@NonNull AdRequestBuilderType AdRequestBuilderType, @Nullable String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            AdRequestBuilderType.setRequestAgent(string);
        }
    }

    private void setConsent(@NonNull AdRequestBuilderType object, @NonNull AdNetworkMediationParams adNetworkMediationParams) {
        UnifiedAdmobNetwork unifiedAdmobNetwork = adNetworkMediationParams.getRestrictedData();
        if (unifiedAdmobNetwork.isUserGdprProtected()) {
            Bundle bundle;
            adNetworkMediationParams = bundle;
            new Bundle().putString("npa", "1");
            object.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)adNetworkMediationParams);
        }
        if (unifiedAdmobNetwork.isUserCcpaProtected()) {
            if (TextUtils.isEmpty((CharSequence)unifiedAdmobNetwork.getUSPrivacyString())) {
                Bundle bundle;
                unifiedAdmobNetwork = bundle;
                new Bundle().putString("rdp", "1");
                object.addNetworkExtrasBundle(AdMobAdapter.class, (Bundle)unifiedAdmobNetwork);
            } else {
                Bundle bundle;
                AdRequestBuilderType AdRequestBuilderType = object;
                object = bundle;
                object();
                bundle.putString("IABUSPrivacy_String", unifiedAdmobNetwork.getUSPrivacyString());
                AdRequestBuilderType.addNetworkExtrasBundle(AdMobAdapter.class, object);
            }
        }
    }

    private void setTargeting(@NonNull Context context, @NonNull RequestConfiguration.Builder builder2, @NonNull AdNetworkMediationParams adNetworkMediationParams) {
        builder2.setTagForChildDirectedTreatment(adNetworkMediationParams.getRestrictedData().isUserAgeRestricted() ? 1 : 0);
        if (adNetworkMediationParams.isTestMode()) {
            builder2.setTestDeviceIds(Arrays.asList(this.obtainTestDevice(context), "B3EEABB8EE11C2BE770B684D95219ECB"));
        }
    }

    private String obtainTestDevice(@NonNull Context context) {
        try {
            Object object = MessageDigest.getInstance("MD5").digest(Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception exception) {
            Log.log((Throwable)exception);
            return "B3EEABB8EE11C2BE770B684D95219ECB";
        }
        return new BigInteger(1, (byte[])object).toString(16).toUpperCase(Locale.ENGLISH);
    }

    public static <AdRequestType extends AdRequest> LoadingError mapError(@Nullable LoadAdError loadAdError) {
        if (loadAdError == null) {
            return null;
        }
        switch (loadAdError.getCode()) {
            default: {
                return null;
            }
            case 2: {
                return LoadingError.ConnectionError;
            }
            case 1: {
                return LoadingError.IncorrectAdunit;
            }
            case 0: 
            case 3: 
        }
        return LoadingError.NoFill;
    }

    static {
        $assertionsDisabled = UnifiedAdmobNetwork.class.desiredAssertionStatus() ^ true;
        isInitialized = false;
    }

    public String getVersion() {
        return MobileAds.getVersion().toString();
    }

    @Nullable
    public String getRecommendedVersion() {
        return "21.4.0";
    }

    public boolean isSupportSmartBanners() {
        return true;
    }

    public void initialize(@NonNull ContextProvider object, @NonNull AdUnit adUnit, @NonNull AdNetworkMediationParams adNetworkMediationParams, @NonNull NetworkInitializationListener<UnifiedAdmobRequestParams<AdRequestType>> networkInitializationListener) {
        ContextProvider contextProvider = object;
        AdUnit adUnit2 = adUnit;
        JSONObject jSONObject = adUnit2.getJsonData();
        object = jSONObject.getString("admob_key");
        boolean bl = jSONObject.optBoolean("use_adaptive_banner", false);
        boolean bl2 = jSONObject.optBoolean("use_smart_banner", false);
        Boolean bl3 = adUnit2.isMuted();
        Context context = contextProvider.getApplicationContext();
        if (!isInitialized) {
            isInitialized = true;
            MobileAds.initialize((Context)context);
            if (bl3 != null) {
                MobileAds.setAppMuted((boolean)bl3);
            }
        }
        UnifiedAdmobNetwork unifiedAdmobNetwork = this;
        networkInitializationListener.onInitializationFinished(unifiedAdmobNetwork.createParams(unifiedAdmobNetwork.configureAdRequest(context, adUnit, adNetworkMediationParams), (String)object, bl3, bl, bl2));
    }

    public AdRequestType configureAdRequest(@NonNull Context context, @NonNull AdUnit adUnit, @NonNull AdNetworkMediationParams adNetworkMediationParams) {
        UnifiedAdmobNetwork unifiedAdmobNetwork = unifiedAdmobNetwork3;
        Context context2 = context;
        UnifiedAdmobNetwork unifiedAdmobNetwork2 = unifiedAdmobNetwork3;
        UnifiedAdmobNetwork<AdRequestType, AdRequestBuilderType> unifiedAdmobNetwork3 = unifiedAdmobNetwork3.createAdRequestBuilder(adUnit.getJsonData());
        context = MobileAds.getRequestConfiguration().toBuilder();
        unifiedAdmobNetwork2.setMediatorName((AdRequestBuilderType)((Object)unifiedAdmobNetwork3), adUnit.getMediatorName());
        unifiedAdmobNetwork2.setConsent((AdRequestBuilderType)((Object)unifiedAdmobNetwork3), adNetworkMediationParams);
        unifiedAdmobNetwork.setTargeting(context2, (RequestConfiguration.Builder)context, adNetworkMediationParams);
        MobileAds.setRequestConfiguration((RequestConfiguration)context.build());
        return unifiedAdmobNetwork.createAdRequest((AdRequestBuilderType)((Object)unifiedAdmobNetwork3));
    }

    @NonNull
    public abstract AdRequestBuilderType createAdRequestBuilder(@NonNull JSONObject var1);

    @NonNull
    public abstract AdRequestType createAdRequest(@NonNull AdRequestBuilderType var1);

    public static abstract class builder
    extends AdNetworkBuilder {
        public ActivityRule[] getAdActivityRules() {
            return new ActivityRule[]{new ActivityRule.Builder("com.google.android.gms.ads.AdActivity").build()};
        }
    }
}

