/*
 * Decompiled with CFR 0.152.
 */
package com.appodeal.ads.adapters.admob.banner;

import android.content.Context;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.appodeal.ads.adapters.admob.unified.UnifiedAdmobNetwork;
import com.appodeal.ads.adapters.admob.unified.UnifiedAdmobRequestParams;
import com.appodeal.ads.modules.common.internal.context.ContextProvider;
import com.appodeal.ads.unified.UnifiedAdUtils;
import com.appodeal.ads.unified.UnifiedBanner;
import com.appodeal.ads.unified.UnifiedBannerCallback;
import com.appodeal.ads.unified.UnifiedBannerParams;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.BaseAdView;
import com.google.android.gms.ads.LoadAdError;

public abstract class UnifiedAdmobBanner<AdViewType extends BaseAdView, AdRequestType extends AdRequest>
extends UnifiedBanner<UnifiedAdmobRequestParams<AdRequestType>> {
    @Nullable
    private AdViewType adView;

    public void load(@NonNull ContextProvider contextProvider, @NonNull UnifiedBannerParams unifiedBannerParams, @NonNull UnifiedAdmobRequestParams<AdRequestType> unifiedAdmobRequestParams, @NonNull UnifiedBannerCallback unifiedBannerCallback) {
        int n;
        contextProvider = contextProvider.getApplicationContext();
        AdViewType AdViewType = this.createAdView((Context)contextProvider);
        this.adView = AdViewType;
        AdViewType.setAdUnitId(unifiedAdmobRequestParams.key);
        float f = UnifiedAdUtils.getScreenHeightInDp((Context)contextProvider);
        if (unifiedAdmobRequestParams.useAdaptiveBanner && unifiedBannerParams.useSmartBanners((Context)contextProvider)) {
            AdSize adSize = AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)contextProvider, (int)unifiedBannerParams.getMaxWidth((Context)contextProvider));
            this.adView.setAdSize(adSize);
            n = adSize.getHeight();
        } else if (unifiedAdmobRequestParams.useSmartBanner && unifiedBannerParams.useSmartBanners((Context)contextProvider)) {
            this.adView.setAdSize(AdSize.SMART_BANNER);
            n = f <= 400.0f ? 32 : (f > 720.0f ? 90 : 50);
        } else if (unifiedBannerParams.needLeaderBoard((Context)contextProvider)) {
            this.adView.setAdSize(AdSize.LEADERBOARD);
            n = 90;
        } else {
            this.adView.setAdSize(AdSize.BANNER);
            n = 50;
        }
        UnifiedAdmobBanner unifiedAdmobBanner = this;
        UnifiedAdmobBanner unifiedAdmobBanner2 = this;
        unifiedAdmobBanner.adView.setAdListener(new a(unifiedAdmobBanner2, unifiedBannerCallback, unifiedAdmobBanner2.adView, n));
        unifiedAdmobBanner.adView.loadAd(unifiedAdmobRequestParams.request);
    }

    @NonNull
    public abstract AdViewType createAdView(@NonNull Context var1);

    public void onDestroy() {
        AdViewType AdViewType = this.adView;
        if (AdViewType != null) {
            AdViewType.setAdListener(null);
            this.adView.destroy();
            this.adView = null;
        }
    }

    @VisibleForTesting
    public static final class a<AdViewType extends BaseAdView, AdRequestType extends AdRequest>
    extends AdListener {
        @NonNull
        public final UnifiedAdmobBanner<AdViewType, AdRequestType> a;
        @NonNull
        public final UnifiedBannerCallback b;
        @NonNull
        public final AdViewType c;
        public final int d;

        @VisibleForTesting
        public a(@NonNull UnifiedAdmobBanner<AdViewType, AdRequestType> unifiedAdmobBanner, @NonNull UnifiedBannerCallback unifiedBannerCallback, @NonNull AdViewType AdViewType, int n) {
            this.a = unifiedAdmobBanner;
            this.b = unifiedBannerCallback;
            this.c = AdViewType;
            this.d = n;
        }

        public final void onAdLoaded() {
            a a2 = a4;
            super.onAdLoaded();
            AdSize adSize = a2.c.getAdSize();
            if (adSize != AdSize.LEADERBOARD && adSize != AdSize.BANNER) {
                a4.a.setRefreshOnRotate(true);
            }
            a a3 = a4;
            a<AdViewType, AdRequestType> a4 = a3.c;
            int n = a3.d;
            a4.b.onAdLoaded((View)a4, -1, n);
        }

        public final void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            super.onAdFailedToLoad(loadAdError);
            if (loadAdError != null) {
                this.b.printError(loadAdError.getMessage(), (Object)loadAdError.getCode());
            }
            this.b.onAdLoadFailed(UnifiedAdmobNetwork.mapError(loadAdError));
        }

        public final void onAdClicked() {
            a a2 = this;
            super.onAdClicked();
            a2.b.onAdClicked();
        }
    }
}

