/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxAppOpenAdapter;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxNativeAdAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;
import sg.bigo.ads.BigoAdSdk;
import sg.bigo.ads.ConsentOptions;
import sg.bigo.ads.api.AdConfig;
import sg.bigo.ads.api.AdError;
import sg.bigo.ads.api.AdInteractionListener;
import sg.bigo.ads.api.AdLoadListener;
import sg.bigo.ads.api.AdOptionsView;
import sg.bigo.ads.api.AdSize;
import sg.bigo.ads.api.BannerAd;
import sg.bigo.ads.api.BannerAdLoader;
import sg.bigo.ads.api.BannerAdRequest;
import sg.bigo.ads.api.InterstitialAd;
import sg.bigo.ads.api.InterstitialAdLoader;
import sg.bigo.ads.api.InterstitialAdRequest;
import sg.bigo.ads.api.MediaView;
import sg.bigo.ads.api.NativeAd;
import sg.bigo.ads.api.NativeAdLoader;
import sg.bigo.ads.api.NativeAdRequest;
import sg.bigo.ads.api.RewardAdInteractionListener;
import sg.bigo.ads.api.RewardVideoAd;
import sg.bigo.ads.api.RewardVideoAdLoader;
import sg.bigo.ads.api.RewardVideoAdRequest;
import sg.bigo.ads.api.SplashAd;
import sg.bigo.ads.api.SplashAdInteractionListener;
import sg.bigo.ads.api.SplashAdLoader;
import sg.bigo.ads.api.SplashAdRequest;
import sg.bigo.ads.api.b;

public class BigoAdsMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxAppOpenAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter,
MaxNativeAdAdapter {
    private static final int TITLE_LABEL_TAG = 1;
    private static final int MEDIA_VIEW_CONTAINER_TAG = 2;
    private static final int ICON_VIEW_TAG = 3;
    private static final int BODY_VIEW_TAG = 4;
    private static final int CALL_TO_ACTION_VIEW_TAG = 5;
    private static final int ADVERTISER_VIEW_TAG = 8;
    private static final String MEDIATION_INFO;
    private static final AtomicBoolean initialized;
    private static MaxAdapter.InitializationStatus status;
    private InterstitialAd interstitialAd;
    private SplashAd appOpenAd;
    private RewardVideoAd rewardedAd;
    private BannerAd adViewAd;
    private NativeAd nativeAd;
    private InterstitialAdListener interstitialAdListener;
    private AppOpenAdListener appOpenAdListener;
    private RewardedAdListener rewardedAdListener;
    private AdViewListener adViewListener;
    private NativeAdViewListener nativeAdViewListener;
    private NativeAdListener nativeAdListener;

    public BigoAdsMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, @Nullable Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        if (initialized.compareAndSet(false, true)) {
            status = MaxAdapter.InitializationStatus.INITIALIZING;
            Bundle serverParameters = parameters.getServerParameters();
            String appId = serverParameters.getString("app_id");
            this.log("Initializing Bigo Ads SDK with app id: " + appId + "...");
            AdConfig config = new AdConfig.Builder().setAppId(appId).setDebug(parameters.isTesting()).build();
            BigoAdSdk.initialize((Context)this.getApplicationContext(), (AdConfig)config, (BigoAdSdk.InitListener)new BigoAdSdk.InitListener(){

                public void onInitialized() {
                    if (BigoAdSdk.isInitialized()) {
                        BigoAdsMediationAdapter.this.log("Bigo Ads SDK initialized");
                        status = MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS;
                    } else {
                        BigoAdsMediationAdapter.this.log("Bigo Ads SDK failed to initialize");
                        status = MaxAdapter.InitializationStatus.INITIALIZED_FAILURE;
                    }
                    onCompletionListener.onCompletion(status, null);
                }
            });
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return BigoAdSdk.getSDKVersionName();
    }

    public String getAdapterVersion() {
        return "5.2.1.0";
    }

    public void onDestroy() {
        this.log("Destroy called for adapter " + (Object)((Object)this));
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
            this.interstitialAdListener = null;
        }
        if (this.appOpenAd != null) {
            this.appOpenAd.destroy();
            this.appOpenAd = null;
            this.appOpenAdListener = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
            this.rewardedAd = null;
            this.rewardedAdListener = null;
        }
        if (this.adViewAd != null) {
            this.adViewAd.destroy();
            this.adViewAd = null;
            this.adViewListener = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
            this.nativeAdViewListener = null;
            this.nativeAdListener = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, @Nullable Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        this.updateUserConsent((MaxAdapterParameters)parameters);
        String bidToken = BigoAdSdk.getBidderToken();
        callback.onSignalCollected(bidToken);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading interstitial ad for slot id: " + slotId + "...");
        if (!BigoAdSdk.isInitialized()) {
            this.log("Bigo Ads SDK not successfully initialized: failing interstitial ad load for slot id: " + slotId);
            listener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserConsent((MaxAdapterParameters)parameters);
        this.interstitialAdListener = new InterstitialAdListener(slotId, listener);
        InterstitialAdLoader interstitialAdLoader = new InterstitialAdLoader.Builder().withAdLoadListener((AdLoadListener)this.interstitialAdListener).withExt(MEDIATION_INFO).build();
        InterstitialAdRequest interstitialAdRequest = (InterstitialAdRequest)((InterstitialAdRequest.Builder)((InterstitialAdRequest.Builder)new InterstitialAdRequest.Builder().withSlotId(slotId)).withBid(parameters.getBidResponse())).build();
        interstitialAdLoader.loadAd((b)interstitialAdRequest);
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxInterstitialAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad for slot id: " + slotId + "...");
        if (this.interstitialAd.isExpired()) {
            this.log("Unable to show interstitial ad for slot id: " + slotId + " - ad expired");
            listener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
        } else {
            this.interstitialAd.setAdInteractionListener((AdInteractionListener)this.interstitialAdListener);
            this.interstitialAd.show();
        }
    }

    public void loadAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading app open ad for slot id: " + slotId + "...");
        if (!BigoAdSdk.isInitialized()) {
            this.log("Bigo Ads SDK not successfully initialized: failing app open ad load for slot id: " + slotId);
            listener.onAppOpenAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserConsent((MaxAdapterParameters)parameters);
        this.appOpenAdListener = new AppOpenAdListener(slotId, listener);
        SplashAdLoader splashAdLoader = new SplashAdLoader.Builder().withAdLoadListener((AdLoadListener)this.appOpenAdListener).withExt(MEDIATION_INFO).build();
        ApplicationInfo applicationInfo = this.getApplicationContext().getApplicationInfo();
        int appLogo = applicationInfo.logo;
        String appName = applicationInfo.name;
        SplashAdRequest splashAdRequest = (SplashAdRequest)((SplashAdRequest.Builder)((SplashAdRequest.Builder)new SplashAdRequest.Builder().withSlotId(slotId)).withBid(parameters.getBidResponse())).withAppLogo(appLogo).withAppName(appName).build();
        splashAdLoader.loadAd((b)splashAdRequest);
    }

    public void showAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing app open ad for slot id: " + slotId + "...");
        if (this.appOpenAd.isExpired()) {
            this.log("Unable to show app open ad for slot id: " + slotId + " - ad expired");
            listener.onAppOpenAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
        } else {
            this.appOpenAd.setAdInteractionListener((SplashAdInteractionListener)this.appOpenAdListener);
            this.appOpenAd.show();
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading rewarded ad for slot id: " + slotId + "...");
        if (!BigoAdSdk.isInitialized()) {
            this.log("Bigo Ads SDK not successfully initialized: failing rewarded ad load for slot id: " + slotId);
            listener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserConsent((MaxAdapterParameters)parameters);
        this.rewardedAdListener = new RewardedAdListener(slotId, listener);
        RewardVideoAdLoader rewardVideoAdAdLoader = new RewardVideoAdLoader.Builder().withAdLoadListener((AdLoadListener)this.rewardedAdListener).withExt(MEDIATION_INFO).build();
        RewardVideoAdRequest rewardVideoAdAdRequest = (RewardVideoAdRequest)((RewardVideoAdRequest.Builder)((RewardVideoAdRequest.Builder)new RewardVideoAdRequest.Builder().withSlotId(slotId)).withBid(parameters.getBidResponse())).build();
        rewardVideoAdAdLoader.loadAd((b)rewardVideoAdAdRequest);
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxRewardedAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad for slot id: " + slotId + "...");
        if (this.rewardedAd.isExpired()) {
            this.log("Unable to show rewarded ad for slot id: " + slotId + " - ad expired");
            listener.onRewardedAdDisplayFailed(MaxAdapterError.AD_EXPIRED);
        } else {
            this.configureReward(parameters);
            this.rewardedAd.setAdInteractionListener((RewardAdInteractionListener)this.rewardedAdListener);
            this.rewardedAd.show();
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, @Nullable Activity activity, MaxAdViewAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isNative ? "native " : "") + adFormat.getLabel() + " ad for slot id: " + slotId);
        if (!BigoAdSdk.isInitialized()) {
            this.log("Bigo Ads SDK not successfully initialized: failing " + adFormat.getLabel() + " ad load for slot id: " + slotId);
            listener.onAdViewAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserConsent((MaxAdapterParameters)parameters);
        if (isNative) {
            this.nativeAdViewListener = new NativeAdViewListener(slotId, adFormat, parameters.getServerParameters(), listener);
            NativeAdLoader nativeAdLoader = new NativeAdLoader.Builder().withAdLoadListener((AdLoadListener)this.nativeAdViewListener).withExt(MEDIATION_INFO).build();
            NativeAdRequest nativeAdRequest = (NativeAdRequest)((NativeAdRequest.Builder)((NativeAdRequest.Builder)new NativeAdRequest.Builder().withSlotId(slotId)).withBid(parameters.getBidResponse())).build();
            nativeAdLoader.loadAd((b)nativeAdRequest);
        } else {
            AdSize adSize = this.toAdSize(adFormat);
            if (adSize == null) {
                MaxAdapterError adapterError = new MaxAdapterError(-5202, "Unsupported ad format: " + adFormat);
                this.log(adFormat.getLabel() + " ad failed to load with error: " + adapterError);
                listener.onAdViewAdLoadFailed(adapterError);
                return;
            }
            this.adViewListener = new AdViewListener(slotId, adFormat, listener);
            BannerAdLoader bannerAdLoader = new BannerAdLoader.Builder().withAdLoadListener((AdLoadListener)this.adViewListener).withExt(MEDIATION_INFO).build();
            BannerAdRequest bannerAdRequest = (BannerAdRequest)((BannerAdRequest.Builder)((BannerAdRequest.Builder)new BannerAdRequest.Builder().withSlotId(slotId)).withBid(parameters.getBidResponse())).withAdSizes(new AdSize[]{adSize}).build();
            bannerAdLoader.loadAd((b)bannerAdRequest);
        }
    }

    public void loadNativeAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxNativeAdAdapterListener listener) {
        String slotId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading native ad for slot id: " + slotId + "...");
        if (!BigoAdSdk.isInitialized()) {
            this.log("Bigo Ads SDK not successfully initialized: failing native ad load for slot id: " + slotId);
            listener.onNativeAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateUserConsent((MaxAdapterParameters)parameters);
        this.nativeAdListener = new NativeAdListener(slotId, parameters.getServerParameters(), listener);
        NativeAdLoader nativeAdLoader = new NativeAdLoader.Builder().withAdLoadListener((AdLoadListener)this.nativeAdListener).withExt(MEDIATION_INFO).build();
        NativeAdRequest nativeAdRequest = (NativeAdRequest)((NativeAdRequest.Builder)((NativeAdRequest.Builder)new NativeAdRequest.Builder().withSlotId(slotId)).withBid(parameters.getBidResponse())).build();
        nativeAdLoader.loadAd((b)nativeAdRequest);
    }

    @Nullable
    private AdSize toAdSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return AdSize.BANNER;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        return null;
    }

    private static MaxAdapterError toMaxError(AdError error) {
        int bigoAdsErrorCode = error.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (bigoAdsErrorCode) {
            case 1000: {
                adapterError = MaxAdapterError.NOT_INITIALIZED;
                break;
            }
            case 1001: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 1003: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 1004: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 1005: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 1007: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                break;
            }
            case 2000: {
                adapterError = MaxAdapterError.AD_EXPIRED;
                break;
            }
            case 2001: {
                adapterError = MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS;
                break;
            }
            case 1006: 
            case 2002: 
            case 2003: 
            case 2004: {
                adapterError = MaxAdapterError.AD_DISPLAY_FAILED;
                break;
            }
            case 2005: {
                adapterError = MaxAdapterError.MISSING_ACTIVITY;
                break;
            }
            case 1011: {
                adapterError = MaxAdapterError.TIMEOUT;
            }
        }
        return new MaxAdapterError(adapterError, bigoAdsErrorCode, error.getMessage());
    }

    private void updateUserConsent(MaxAdapterParameters parameters) {
        Boolean isDoNotSell;
        Context context = this.getApplicationContext();
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            BigoAdSdk.setUserConsent((Context)context, (ConsentOptions)ConsentOptions.GDPR, (boolean)hasUserConsent);
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null) {
            BigoAdSdk.setUserConsent((Context)context, (ConsentOptions)ConsentOptions.CCPA, (isDoNotSell == false ? 1 : 0) != 0);
        }
    }

    static {
        initialized = new AtomicBoolean();
        JSONObject mediationInfoJSON = new JSONObject();
        try {
            mediationInfoJSON.putOpt("mediationName", (Object)"Max");
            mediationInfoJSON.putOpt("mediationVersion", (Object)AppLovinSdk.VERSION);
            mediationInfoJSON.putOpt("adapterVersion", (Object)"5.2.1.0");
        }
        catch (Throwable th) {
            Log.e((String)"BigoAdsMediationAdapter", (String)"Error creating mediation info JSON", (Throwable)th);
        }
        MEDIATION_INFO = mediationInfoJSON.toString();
    }

    private class NativeAdListener
    implements AdLoadListener<NativeAd>,
    AdInteractionListener {
        private final String slotId;
        private final Bundle serverParameters;
        private final MaxNativeAdAdapterListener listener;

        private NativeAdListener(String slotId, Bundle serverParameters, MaxNativeAdAdapterListener listener) {
            this.slotId = slotId;
            this.serverParameters = serverParameters;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull NativeAd ad) {
            BigoAdsMediationAdapter.this.log("Native ad loaded for slot id: " + this.slotId);
            if (ad == null) {
                BigoAdsMediationAdapter.this.log("Native ad (" + ad + ")  can't be null.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            ad.setAdInteractionListener((AdInteractionListener)BigoAdsMediationAdapter.this.nativeAdListener);
            BigoAdsMediationAdapter.this.nativeAd = ad;
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)ad.getTitle())) {
                BigoAdsMediationAdapter.this.log("Native ad (" + ad + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            Context context = BigoAdsMediationAdapter.this.getApplicationContext();
            ImageView iconView = new ImageView(context);
            AdOptionsView optionsView = new AdOptionsView(context);
            MediaView mediaView = new MediaView(context);
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(ad.getTitle()).setAdvertiser(ad.getAdvertiser()).setBody(ad.getDescription()).setCallToAction(ad.getCallToAction()).setIconView((View)iconView).setOptionsView((View)optionsView).setMediaView((View)mediaView).setMediaContentAspectRatio(ad.getMediaContentAspectRatio());
            MaxBigoAdsNativeAd maxNativeAd = new MaxBigoAdsNativeAd(builder);
            this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, null);
        }

        public void onError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Native ad (" + this.slotId + ") failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdOpened() {
        }

        public void onAdImpression() {
            BigoAdsMediationAdapter.this.log("Native ad impression recorded for slot id: " + this.slotId);
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Native ad (" + this.slotId + ") failed to show with error: " + adapterError);
        }

        public void onAdClicked() {
            BigoAdsMediationAdapter.this.log("Native ad click recorded for slot id: " + this.slotId);
            this.listener.onNativeAdClicked();
        }

        public void onAdClosed() {
        }
    }

    private class NativeAdViewListener
    implements AdLoadListener<NativeAd>,
    AdInteractionListener {
        private final String slotId;
        private final MaxAdFormat adFormat;
        private final Bundle serverParameters;
        private final MaxAdViewAdapterListener listener;

        private NativeAdViewListener(String slotId, MaxAdFormat adFormat, Bundle serverParameters, MaxAdViewAdapterListener listener) {
            this.slotId = slotId;
            this.adFormat = adFormat;
            this.serverParameters = serverParameters;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull NativeAd ad) {
            MaxNativeAdView maxNativeAdView;
            BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded for slot id: " + this.slotId);
            if (ad == null) {
                BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad + (" + ad + ") can 't be null.");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.NO_FILL);
                return;
            }
            if (TextUtils.isEmpty((CharSequence)ad.getTitle())) {
                BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + ad + ") does not have required assets.");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.MISSING_REQUIRED_NATIVE_AD_ASSETS);
                return;
            }
            ad.setAdInteractionListener((AdInteractionListener)BigoAdsMediationAdapter.this.nativeAdViewListener);
            BigoAdsMediationAdapter.this.nativeAd = ad;
            Context context = BigoAdsMediationAdapter.this.getApplicationContext();
            ImageView iconView = new ImageView(context);
            AdOptionsView optionsView = new AdOptionsView(context);
            MediaView mediaView = new MediaView(context);
            MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(ad.getTitle()).setAdvertiser(ad.getAdvertiser()).setBody(ad.getDescription()).setCallToAction(ad.getCallToAction()).setIconView((View)iconView).setOptionsView((View)optionsView).setMediaView((View)mediaView);
            MaxBigoAdsNativeAd maxNativeAd = new MaxBigoAdsNativeAd(builder);
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            if (templateName.equals("vertical")) {
                String verticalTemplateName = this.adFormat == MaxAdFormat.LEADER ? "vertical_leader_template" : "vertical_media_banner_template";
                maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxNativeAd, verticalTemplateName, BigoAdsMediationAdapter.this.getApplicationContext());
            } else {
                maxNativeAdView = new MaxNativeAdView((MaxNativeAd)maxNativeAd, templateName, BigoAdsMediationAdapter.this.getApplicationContext());
            }
            maxNativeAd.prepareForInteraction(maxNativeAdView.getClickableViews(), (ViewGroup)maxNativeAdView);
            this.listener.onAdViewAdLoaded((View)maxNativeAdView);
        }

        public void onError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.slotId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdOpened() {
        }

        public void onAdImpression() {
            BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad impression recorded for slot id: " + this.slotId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.slotId + ") failed to show with error: " + adapterError);
            this.listener.onAdViewAdDisplayFailed(adapterError);
        }

        public void onAdClicked() {
            BigoAdsMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad click recorded for slot id: " + this.slotId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
        }
    }

    private class AdViewListener
    implements AdLoadListener<BannerAd>,
    AdInteractionListener {
        private final String slotId;
        private final MaxAdFormat adFormat;
        private final MaxAdViewAdapterListener listener;

        private AdViewListener(String slotId, MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.slotId = slotId;
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull BannerAd ad) {
            BigoAdsMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded for slot id: " + this.slotId);
            BigoAdsMediationAdapter.this.adViewAd = ad;
            ad.setAdInteractionListener((AdInteractionListener)BigoAdsMediationAdapter.this.adViewListener);
            this.listener.onAdViewAdLoaded(ad.adView());
        }

        public void onError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.slotId + ") failed to load with error :" + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdOpened() {
        }

        public void onAdImpression() {
            BigoAdsMediationAdapter.this.log(this.adFormat.getLabel() + " ad impression recorded for slot id: " + this.slotId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdError(@NonNull AdError adError) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(adError);
            BigoAdsMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.slotId + ") failed to show with error: " + adapterError);
            this.listener.onAdViewAdDisplayFailed(adapterError);
        }

        public void onAdClicked() {
            BigoAdsMediationAdapter.this.log(this.adFormat.getLabel() + " ad clicked recorded for slot id: " + this.slotId);
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
        }
    }

    private class InterstitialAdListener
    implements AdLoadListener<InterstitialAd>,
    AdInteractionListener {
        private final String slotId;
        private final MaxInterstitialAdapterListener listener;

        private InterstitialAdListener(String slotId, MaxInterstitialAdapterListener listener) {
            this.slotId = slotId;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull InterstitialAd ad) {
            BigoAdsMediationAdapter.this.log("Interstitial ad loaded for slot id: " + this.slotId);
            BigoAdsMediationAdapter.this.interstitialAd = ad;
            this.listener.onInterstitialAdLoaded();
        }

        public void onError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Interstitial ad (" + this.slotId + ") failed to load with error: " + adapterError);
            this.listener.onInterstitialAdLoadFailed(adapterError);
        }

        public void onAdOpened() {
            BigoAdsMediationAdapter.this.log("Interstitial ad opened for slot id: " + this.slotId);
        }

        public void onAdImpression() {
            BigoAdsMediationAdapter.this.log("Interstitial ad impression recorded for slot id: " + this.slotId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Interstitial ad (" + this.slotId + ") failed to show with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdClicked() {
            BigoAdsMediationAdapter.this.log("Interstitial ad click recorded for slot id: " + this.slotId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdClosed() {
            BigoAdsMediationAdapter.this.log("Interstitial ad hidden for slot id: " + this.slotId);
            this.listener.onInterstitialAdHidden();
        }
    }

    private class AppOpenAdListener
    implements AdLoadListener<SplashAd>,
    SplashAdInteractionListener {
        private final String slotId;
        private final MaxAppOpenAdapterListener listener;

        private AppOpenAdListener(String slotId, MaxAppOpenAdapterListener listener) {
            this.slotId = slotId;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull SplashAd splashAd) {
            BigoAdsMediationAdapter.this.log("App open ad loaded for slot id: " + this.slotId);
            BigoAdsMediationAdapter.this.appOpenAd = splashAd;
            this.listener.onAppOpenAdLoaded();
        }

        public void onError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("App open ad (" + this.slotId + ") failed to load with error: " + adapterError);
            this.listener.onAppOpenAdLoadFailed(adapterError);
        }

        public void onAdOpened() {
        }

        public void onAdImpression() {
            BigoAdsMediationAdapter.this.log("App open ad impression recorded for slot id: " + this.slotId);
            this.listener.onAppOpenAdDisplayed();
        }

        public void onAdError(@NonNull AdError adError) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(adError);
            BigoAdsMediationAdapter.this.log("App open ad (" + this.slotId + ") failed to show with error: " + adapterError);
            this.listener.onAppOpenAdDisplayFailed(adapterError);
        }

        public void onAdClicked() {
            BigoAdsMediationAdapter.this.log("App open ad click recorded for slot id: " + this.slotId);
            this.listener.onAppOpenAdClicked();
        }

        public void onAdFinished() {
            BigoAdsMediationAdapter.this.log("App open ad finished for slot id: " + this.slotId);
        }

        public void onAdSkipped() {
            BigoAdsMediationAdapter.this.log("App open ad skipped for slot id: " + this.slotId);
            this.listener.onAppOpenAdHidden();
        }

        public void onAdClosed() {
        }
    }

    private class RewardedAdListener
    implements AdLoadListener<RewardVideoAd>,
    RewardAdInteractionListener {
        private final String slotId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        private RewardedAdListener(String slotId, MaxRewardedAdapterListener listener) {
            this.slotId = slotId;
            this.listener = listener;
        }

        public void onAdLoaded(@NonNull RewardVideoAd ad) {
            BigoAdsMediationAdapter.this.log("Rewarded ad loaded for slot id: " + this.slotId);
            BigoAdsMediationAdapter.this.rewardedAd = ad;
            this.listener.onRewardedAdLoaded();
        }

        public void onError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Rewarded ad (" + this.slotId + ") failed to load with error: " + adapterError);
            this.listener.onRewardedAdLoadFailed(adapterError);
        }

        public void onAdOpened() {
            BigoAdsMediationAdapter.this.log("Rewarded ad opened for slot id: " + this.slotId);
        }

        public void onAdImpression() {
            BigoAdsMediationAdapter.this.log("Rewarded ad impression recorded for slot id: " + this.slotId);
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdError(@NonNull AdError error) {
            MaxAdapterError adapterError = BigoAdsMediationAdapter.toMaxError(error);
            BigoAdsMediationAdapter.this.log("Rewarded ad (" + this.slotId + ") failed to show with error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdClicked() {
            BigoAdsMediationAdapter.this.log("Rewarded ad click recorded for slot id: " + this.slotId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdRewarded() {
            BigoAdsMediationAdapter.this.log("User earned reward for slot id: " + this.slotId);
            this.hasGrantedReward = true;
        }

        public void onAdClosed() {
            if (this.hasGrantedReward || BigoAdsMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = BigoAdsMediationAdapter.this.getReward();
                BigoAdsMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            BigoAdsMediationAdapter.this.log("Rewarded ad hidden for slot id: " + this.slotId);
            this.listener.onRewardedAdHidden();
        }
    }

    private class MaxBigoAdsNativeAd
    extends MaxNativeAd {
        public MaxBigoAdsNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = BigoAdsMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                BigoAdsMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            if (container instanceof MaxNativeAdView) {
                MaxNativeAdView maxNativeAdView = (MaxNativeAdView)container;
                MediaView mediaView = null;
                if (maxNativeAdView.getMediaContentViewGroup() != null) {
                    mediaView = (MediaView)this.getMediaView();
                }
                ImageView iconView = null;
                if (maxNativeAdView.getIconImageView() != null) {
                    iconView = maxNativeAdView.getIconImageView();
                }
                AdOptionsView optionsView = null;
                if (maxNativeAdView.getOptionsContentViewGroup() != null) {
                    optionsView = (AdOptionsView)this.getOptionsView();
                }
                nativeAd.registerViewForInteraction(container, mediaView, iconView, optionsView, clickableViews);
            } else {
                ImageView iconView = null;
                MediaView mediaView = null;
                for (View view : clickableViews) {
                    Object viewTag = view.getTag();
                    if (viewTag == null) continue;
                    int tag = (Integer)viewTag;
                    if (tag == 1) {
                        view.setTag((Object)2);
                        continue;
                    }
                    if (tag == 3) {
                        if (!(view instanceof ImageView)) continue;
                        iconView = (ImageView)view;
                        continue;
                    }
                    if (tag == 2) {
                        mediaView = (MediaView)this.getMediaView();
                        continue;
                    }
                    if (tag == 4) {
                        view.setTag((Object)6);
                        continue;
                    }
                    if (tag == 5) {
                        view.setTag((Object)7);
                        continue;
                    }
                    if (tag != 8) continue;
                    view.setTag((Object)3);
                }
                nativeAd.registerViewForInteraction(container, mediaView, iconView, null, clickableViews);
            }
            return true;
        }
    }
}

