/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.parser;

import com.apphud.sdk.parser.Parser;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/apphud/sdk/parser/GsonParser;", "Lcom/apphud/sdk/parser/Parser;", "gson", "Lcom/google/gson/Gson;", "<init>", "(Lcom/google/gson/Gson;)V", "toJson", "", "T", "body", "(Ljava/lang/Object;)Ljava/lang/String;", "fromJson", "O", "json", "type", "Ljava/lang/reflect/Type;", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "isJson", "", "jsonString", "sdk_release"})
public final class GsonParser
implements Parser {
    @NotNull
    private final Gson gson;

    public GsonParser(@NotNull Gson gson) {
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        this.gson = gson;
    }

    @Override
    @NotNull
    public <T> String toJson(T body) {
        String string = this.gson.toJson(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    @Override
    @Nullable
    public <O> O fromJson(@Nullable String json, @NotNull Type type2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        try {
            object = this.gson.fromJson(json, type2);
        }
        catch (JsonParseException e) {
            object = null;
        }
        return (O)object;
    }

    @Override
    public boolean isJson(@Nullable String jsonString) {
        boolean bl;
        try {
            this.gson.fromJson(jsonString, Object.class);
            bl = true;
        }
        catch (JsonSyntaxException e) {
            bl = false;
        }
        return bl;
    }
}

