/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.presentation.figma;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import androidx.activity.OnBackPressedCallback;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.RepeatOnLifecycleKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.apphud.sdk.ApphudInternal;
import com.apphud.sdk.ApphudInternal_PurchasesKt;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudPurchaseResult;
import com.apphud.sdk.R;
import com.apphud.sdk.domain.ApphudProduct;
import com.apphud.sdk.internal.presentation.figma.FigmaViewViewModel;
import com.apphud.sdk.internal.presentation.figma.FigmaWebViewActivity;
import com.apphud.sdk.internal.presentation.figma.WebViewEvent;
import com.apphud.sdk.internal.presentation.figma.WebViewState;
import com.apphud.sdk.internal.presentation.figma.WebViewWrapper;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0012\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0013\u001a\u00020\rH\u0014J\b\u0010\u0014\u001a\u00020\rH\u0014J\b\u0010\u0015\u001a\u00020\rH\u0014J\b\u0010\u0016\u001a\u00020\rH\u0014J\b\u0010\u0017\u001a\u00020\rH\u0014J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0019\u001a\u00020\rH\u0003J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\rH\u0002J\b\u0010\u001f\u001a\u00020\rH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020&H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/apphud/sdk/internal/presentation/figma/FigmaWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "viewModel", "Lcom/apphud/sdk/internal/presentation/figma/FigmaViewViewModel;", "webView", "Landroid/webkit/WebView;", "webViewWrapper", "Lcom/apphud/sdk/internal/presentation/figma/WebViewWrapper;", "purchaseLoaderOverlay", "Landroid/widget/FrameLayout;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "Landroid/content/Intent;", "onStart", "onResume", "onPause", "onStop", "onDestroy", "processIntent", "setupWebView", "setupObservers", "startPurchase", "product", "Lcom/apphud/sdk/domain/ApphudProduct;", "showPurchaseLoader", "hidePurchaseLoader", "handleSpecialUrl", "", "url", "Landroid/net/Uri;", "setupFullscreen", "displayPaywallUrl", "", "Companion", "sdk_release"})
public final class FigmaWebViewActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private FigmaViewViewModel viewModel;
    private WebView webView;
    private WebViewWrapper webViewWrapper;
    private FrameLayout purchaseLoaderOverlay;
    @NotNull
    private static final String EXTRA_PAYWALL_ID = "EXTRA_PAYWALL_ID";
    @NotNull
    private static final String EXTRA_RENDER_ITEMS = "EXTRA_RENDER_ITEMS";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onCreate, savedInstanceState: " + (savedInstanceState != null ? "exists" : "null"));
        this.setContentView(R.layout.apphud_rule_webview_activity_layout);
        this.setupFullscreen();
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.purchaseLoaderOverlay = (FrameLayout)this.findViewById(R.id.purchaseLoaderOverlay);
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        this.webViewWrapper = new WebViewWrapper(webView);
        this.setupWebView();
        this.viewModel = (FigmaViewViewModel)new ViewModelProvider((ViewModelStoreOwner)this, FigmaViewViewModel.Companion.getFactory()).get(FigmaViewViewModel.class);
        this.setupObservers();
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        this.processIntent(intent);
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(this){
            final /* synthetic */ FigmaWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(true);
            }

            public void handleOnBackPressed() {
                FigmaViewViewModel figmaViewViewModel = FigmaWebViewActivity.access$getViewModel$p(this.this$0);
                if (figmaViewViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    figmaViewViewModel = null;
                }
                figmaViewViewModel.processBackPressed();
            }
        });
    }

    protected void onNewIntent(@Nullable Intent intent) {
        super.onNewIntent(intent);
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onNewIntent");
        if (intent != null) {
            this.setIntent(intent);
            this.processIntent(intent);
        }
    }

    protected void onStart() {
        super.onStart();
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onStart");
    }

    protected void onResume() {
        super.onResume();
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onResume");
        this.setupFullscreen();
    }

    protected void onPause() {
        super.onPause();
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onPause");
    }

    protected void onStop() {
        super.onStop();
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onStop");
    }

    protected void onDestroy() {
        super.onDestroy();
        ApphudLog.INSTANCE.log("[FigmaWebViewActivity] onDestroy");
        WebViewWrapper webViewWrapper = this.webViewWrapper;
        if (webViewWrapper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webViewWrapper");
            webViewWrapper = null;
        }
        webViewWrapper.reset();
    }

    private final void processIntent(Intent intent) {
        String ruleId = intent.getStringExtra(EXTRA_PAYWALL_ID);
        String renderItemsJson = intent.getStringExtra(EXTRA_RENDER_ITEMS);
        ApphudLog.INSTANCE.log("[RuleWebViewActivity] Processing intent: ruleId: " + ruleId);
        FigmaViewViewModel figmaViewViewModel = this.viewModel;
        if (figmaViewViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            figmaViewViewModel = null;
        }
        figmaViewViewModel.init(ruleId, renderItemsJson);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void setupWebView() {
        WebSettings webSettings;
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        WebSettings $this$setupWebView_u24lambda_u240 = webSettings = webView.getSettings();
        boolean bl = false;
        $this$setupWebView_u24lambda_u240.setJavaScriptEnabled(true);
        $this$setupWebView_u24lambda_u240.setDomStorageEnabled(true);
        $this$setupWebView_u24lambda_u240.setLoadsImagesAutomatically(true);
        $this$setupWebView_u24lambda_u240.setUseWideViewPort(true);
        $this$setupWebView_u24lambda_u240.setLoadWithOverviewMode(true);
        $this$setupWebView_u24lambda_u240.setMixedContentMode(0);
        $this$setupWebView_u24lambda_u240.setAllowFileAccess(true);
        $this$setupWebView_u24lambda_u240.setGeolocationEnabled(true);
        $this$setupWebView_u24lambda_u240.setSupportZoom(false);
        $this$setupWebView_u24lambda_u240.setBuiltInZoomControls(false);
        $this$setupWebView_u24lambda_u240.setDisplayZoomControls(false);
        $this$setupWebView_u24lambda_u240.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView2 = null;
        }
        webView2.setInitialScale(100);
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView3 = null;
        }
        webView3.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                block0: {
                    ConsoleMessage consoleMessage2 = consoleMessage;
                    if (consoleMessage2 == null) break block0;
                    ConsoleMessage it = consoleMessage2;
                    boolean bl = false;
                    String message = "Console: " + it.message() + " -- From line " + it.lineNumber() + " of " + it.sourceId();
                    ApphudLog.INSTANCE.log(message);
                }
                return true;
            }
        });
        WebView webView4 = this.webView;
        if (webView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView4 = null;
        }
        webView4.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ FigmaWebViewActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                WebResourceRequest webResourceRequest = request;
                Uri url = webResourceRequest != null ? webResourceRequest.getUrl() : null;
                ApphudLog.INSTANCE.log("[WebViewClient] shouldOverrideUrlLoading: " + url);
                if (url != null) {
                    return FigmaWebViewActivity.access$handleSpecialUrl(this.this$0, url);
                }
                return false;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                ApphudLog.INSTANCE.log("[WebViewClient] onPageStarted: " + url);
                WebViewWrapper webViewWrapper = FigmaWebViewActivity.access$getWebViewWrapper$p(this.this$0);
                if (webViewWrapper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webViewWrapper");
                    webViewWrapper = null;
                }
                webViewWrapper.onPageStarted(url);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                WebResourceError webResourceError = error;
                WebResourceRequest webResourceRequest = request;
                String errorMessage = "WebView error: " + (webResourceError != null ? webResourceError.getDescription() : null) + ", URL: " + (Uri)(webResourceRequest != null ? webResourceRequest.getUrl() : null);
                ApphudLog.INSTANCE.logE("[WebViewClient] " + errorMessage);
                WebViewWrapper webViewWrapper = FigmaWebViewActivity.access$getWebViewWrapper$p(this.this$0);
                if (webViewWrapper == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"webViewWrapper");
                    webViewWrapper = null;
                }
                webViewWrapper.onLoadError();
                FigmaViewViewModel figmaViewViewModel = FigmaWebViewActivity.access$getViewModel$p(this.this$0);
                if (figmaViewViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    figmaViewViewModel = null;
                }
                figmaViewViewModel.processWebViewError(errorMessage);
            }

            public void onPageFinished(WebView view, String url) {
                block6: {
                    String renderItemsJson;
                    super.onPageFinished(view, url);
                    ApphudLog.INSTANCE.log("[WebViewClient] onPageFinished: " + url);
                    WebViewWrapper webViewWrapper = FigmaWebViewActivity.access$getWebViewWrapper$p(this.this$0);
                    if (webViewWrapper == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"webViewWrapper");
                        webViewWrapper = null;
                    }
                    webViewWrapper.onPageFinished(url);
                    FigmaViewViewModel figmaViewViewModel = FigmaWebViewActivity.access$getViewModel$p(this.this$0);
                    if (figmaViewViewModel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        figmaViewViewModel = null;
                    }
                    String string = renderItemsJson = figmaViewViewModel.getCurrentRenderItemsJson();
                    if (string == null) break block6;
                    String renderJson = string;
                    boolean bl = false;
                    try {
                        Unit unit;
                        String jsCode = "PaywallSDK.shared().processDomMacros(" + renderJson + ")";
                        ApphudLog.INSTANCE.log("[WebViewClient] Executing JS with escaped JSON");
                        WebView webView = view;
                        if (webView != null) {
                            webView.evaluateJavascript(jsCode, setupWebView.3::onPageFinished$lambda$1$lambda$0);
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    catch (Exception e) {
                        ApphudLog.INSTANCE.logE("[WebViewClient] Error executing JS: " + e.getMessage());
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                WebResourceResponse webResourceResponse = errorResponse;
                WebResourceResponse webResourceResponse2 = errorResponse;
                WebResourceRequest webResourceRequest = request;
                String errorMessage = "HTTP Error: " + (webResourceResponse != null ? Integer.valueOf(webResourceResponse.getStatusCode()) : null) + " - " + (webResourceResponse2 != null ? webResourceResponse2.getReasonPhrase() : null) + " for URL: " + (Uri)(webResourceRequest != null ? webResourceRequest.getUrl() : null);
                ApphudLog.INSTANCE.logE("[WebViewClient] " + errorMessage);
                WebResourceResponse webResourceResponse3 = errorResponse;
                if (!(webResourceResponse3 != null ? webResourceResponse3.getStatusCode() == 200 : false)) {
                    FigmaViewViewModel figmaViewViewModel = FigmaWebViewActivity.access$getViewModel$p(this.this$0);
                    if (figmaViewViewModel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                        figmaViewViewModel = null;
                    }
                    figmaViewViewModel.processWebViewError(errorMessage);
                }
            }

            private static final void onPageFinished$lambda$1$lambda$0(String result) {
                ApphudLog.INSTANCE.log("[WebViewClient] JS execution result: " + result);
            }
        });
    }

    private final void setupObservers() {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FigmaWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = RepeatOnLifecycleKt.repeatOnLifecycle((LifecycleOwner)((LifecycleOwner)this.this$0), (Lifecycle.State)Lifecycle.State.STARTED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ FigmaWebViewActivity this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        FigmaViewViewModel figmaViewViewModel = FigmaWebViewActivity.access$getViewModel$p(this.this$0);
                                        if (figmaViewViewModel == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                                            figmaViewViewModel = null;
                                        }
                                        this.label = 1;
                                        Object object3 = figmaViewViewModel.getState().collect(new FlowCollector(this.this$0){
                                            final /* synthetic */ FigmaWebViewActivity this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(WebViewState state, Continuation<? super Unit> $completion) {
                                                WebViewState webViewState = state;
                                                if (webViewState instanceof WebViewState.Loading) {
                                                    ApphudLog.INSTANCE.log("[RuleWebViewActivity] Loading state");
                                                    FigmaWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.Content) {
                                                    ApphudLog.INSTANCE.log("[RuleWebViewActivity] Content loaded for paywall: " + ((WebViewState.Content)state).getPaywall().getName());
                                                    FigmaWebViewActivity.access$displayPaywallUrl(this.this$0, ((WebViewState.Content)state).getUrl());
                                                    FigmaWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.ContentWithPurchaseLoading) {
                                                    ApphudLog.INSTANCE.log("[RuleWebViewActivity] Content with purchase loading");
                                                    FigmaWebViewActivity.access$displayPaywallUrl(this.this$0, ((WebViewState.ContentWithPurchaseLoading)state).getUrl());
                                                    FigmaWebViewActivity.access$showPurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.Error) {
                                                    ApphudLog.INSTANCE.logE("[RuleWebViewActivity] Error state");
                                                    FigmaWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.WebViewLoadError) {
                                                    ApphudLog.INSTANCE.logE("[RuleWebViewActivity] WebView load error state");
                                                    FigmaWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else {
                                                    throw new NoWhenBranchMatchedException();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) throw new KotlinNothingValueException();
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FigmaWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FigmaViewViewModel figmaViewViewModel = FigmaWebViewActivity.access$getViewModel$p(this.this$0);
                        if (figmaViewViewModel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                            figmaViewViewModel = null;
                        }
                        this.label = 1;
                        Object object3 = figmaViewViewModel.getEvents().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ FigmaWebViewActivity this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(WebViewEvent event, Continuation<? super Unit> $completion) {
                                WebViewEvent webViewEvent = event;
                                if (webViewEvent instanceof WebViewEvent.CloseScreen || Intrinsics.areEqual((Object)webViewEvent, (Object)WebViewEvent.PurchaseCompleted.INSTANCE) || webViewEvent instanceof WebViewEvent.RestoreCompleted || Intrinsics.areEqual((Object)webViewEvent, (Object)WebViewEvent.InvalidPurchaseIndex.INSTANCE)) {
                                    this.this$0.finishAndRemoveTask();
                                } else if (Intrinsics.areEqual((Object)webViewEvent, (Object)WebViewEvent.ShowPurchaseLoader.INSTANCE)) {
                                    FigmaWebViewActivity.access$showPurchaseLoader(this.this$0);
                                } else if (webViewEvent instanceof WebViewEvent.StartPurchase) {
                                    FigmaWebViewActivity.access$startPurchase(this.this$0, ((WebViewEvent.StartPurchase)event).getProduct());
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void startPurchase(ApphudProduct product) {
        ApphudInternal_PurchasesKt.purchase(ApphudInternal.INSTANCE, (Activity)this, product, null, null, null, null, true, false, (Function1<? super ApphudPurchaseResult, Unit>)((Function1)arg_0 -> FigmaWebViewActivity.startPurchase$lambda$1(this, arg_0)));
    }

    private final void showPurchaseLoader() {
        FrameLayout frameLayout = this.purchaseLoaderOverlay;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"purchaseLoaderOverlay");
            frameLayout = null;
        }
        frameLayout.setVisibility(0);
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setEnabled(false);
    }

    private final void hidePurchaseLoader() {
        FrameLayout frameLayout = this.purchaseLoaderOverlay;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"purchaseLoaderOverlay");
            frameLayout = null;
        }
        frameLayout.setVisibility(8);
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setEnabled(true);
    }

    private final boolean handleSpecialUrl(Uri url) {
        String lastPathComponent = url.getLastPathSegment();
        String string = url.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String urlString = string;
        ApphudLog.INSTANCE.log("[RuleWebViewActivity] Handling URL: " + urlString + ", lastPathComponent: " + lastPathComponent);
        String string2 = lastPathComponent;
        if (Intrinsics.areEqual((Object)string2, (Object)"restore")) {
            ApphudLog.INSTANCE.log("[RuleWebViewActivity] Restore action triggered");
            FigmaViewViewModel figmaViewViewModel = this.viewModel;
            if (figmaViewViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                figmaViewViewModel = null;
            }
            figmaViewViewModel.processRestore();
            return true;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"close")) {
            ApphudLog.INSTANCE.log("[RuleWebViewActivity] Close action triggered");
            FigmaViewViewModel figmaViewViewModel = this.viewModel;
            if (figmaViewViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                figmaViewViewModel = null;
            }
            figmaViewViewModel.processDismiss();
            return true;
        }
        if (StringsKt.contains$default((CharSequence)urlString, (CharSequence)"/purchase/", (boolean)false, (int)2, null)) {
            String index = lastPathComponent;
            CharSequence charSequence = index;
            if (!(charSequence == null || charSequence.length() == 0)) {
                try {
                    int purchaseIndex = Integer.parseInt(index);
                    if (purchaseIndex >= 0) {
                        ApphudLog.INSTANCE.log("[RuleWebViewActivity] Purchase action triggered for index: " + purchaseIndex);
                        FigmaViewViewModel figmaViewViewModel = this.viewModel;
                        if (figmaViewViewModel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                            figmaViewViewModel = null;
                        }
                        figmaViewViewModel.processPurchaseByIndex(purchaseIndex);
                    }
                }
                catch (NumberFormatException e) {
                    ApphudLog.INSTANCE.logE("[RuleWebViewActivity] Invalid purchase index: " + index);
                }
            }
            return true;
        }
        return false;
    }

    private final void setupFullscreen() {
        try {
            this.getWindow().addFlags(128);
            this.getWindow().setStatusBarColor(0);
            this.getWindow().setNavigationBarColor(0);
            if (Build.VERSION.SDK_INT >= 30) {
                this.getWindow().setDecorFitsSystemWindows(false);
                WindowInsetsController windowInsetsController = this.getWindow().getInsetsController();
                if (windowInsetsController != null) {
                    WindowInsetsController controller = windowInsetsController;
                    boolean bl = false;
                    controller.hide(WindowInsets.Type.statusBars() | WindowInsets.Type.navigationBars());
                    controller.setSystemBarsBehavior(2);
                }
            } else {
                this.getWindow().getDecorView().setSystemUiVisibility(5894);
            }
            ApphudLog.INSTANCE.log("[FigmaWebViewActivity] Fullscreen setup completed");
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[FigmaWebViewActivity] Error setting up fullscreen: " + e.getMessage());
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void displayPaywallUrl(String url) {
        try {
            ApphudLog.INSTANCE.log("[RuleWebViewActivity] Loading paywall URL: " + url);
            WebViewWrapper webViewWrapper = this.webViewWrapper;
            if (webViewWrapper == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webViewWrapper");
                webViewWrapper = null;
            }
            webViewWrapper.loadUrl(url);
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RuleWebViewActivity] Error loading paywall URL: " + e.getMessage());
            FigmaViewViewModel figmaViewViewModel = this.viewModel;
            if (figmaViewViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                figmaViewViewModel = null;
            }
            figmaViewViewModel.processWebViewError("Error loading paywall URL: " + e.getMessage());
        }
    }

    private static final Unit startPurchase$lambda$1(FigmaWebViewActivity this$0, ApphudPurchaseResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        FigmaViewViewModel figmaViewViewModel = this$0.viewModel;
        if (figmaViewViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            figmaViewViewModel = null;
        }
        figmaViewViewModel.onPurchaseResult(result);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ FigmaViewViewModel access$getViewModel$p(FigmaWebViewActivity $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ boolean access$handleSpecialUrl(FigmaWebViewActivity $this, Uri url) {
        return $this.handleSpecialUrl(url);
    }

    public static final /* synthetic */ WebViewWrapper access$getWebViewWrapper$p(FigmaWebViewActivity $this) {
        return $this.webViewWrapper;
    }

    public static final /* synthetic */ void access$hidePurchaseLoader(FigmaWebViewActivity $this) {
        $this.hidePurchaseLoader();
    }

    public static final /* synthetic */ void access$displayPaywallUrl(FigmaWebViewActivity $this, String url) {
        $this.displayPaywallUrl(url);
    }

    public static final /* synthetic */ void access$showPurchaseLoader(FigmaWebViewActivity $this) {
        $this.showPurchaseLoader();
    }

    public static final /* synthetic */ void access$startPurchase(FigmaWebViewActivity $this, ApphudProduct product) {
        $this.startPurchase(product);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/apphud/sdk/internal/presentation/figma/FigmaWebViewActivity$Companion;", "", "<init>", "()V", "EXTRA_PAYWALL_ID", "", "EXTRA_RENDER_ITEMS", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "paywallId", "renderItemsJson", "getIntent$sdk_release", "sdk_release"})
    @SourceDebugExtension(value={"SMAP\nFigmaWebViewActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FigmaWebViewActivity.kt\ncom/apphud/sdk/internal/presentation/figma/FigmaWebViewActivity$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,445:1\n1#2:446\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent getIntent$sdk_release(@NotNull Context context, @NotNull String paywallId, @Nullable String renderItemsJson) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)paywallId, (String)"paywallId");
            Intent $this$getIntent_u24lambda_u241 = intent = new Intent(context, FigmaWebViewActivity.class);
            boolean bl = false;
            $this$getIntent_u24lambda_u241.putExtra(FigmaWebViewActivity.EXTRA_PAYWALL_ID, paywallId);
            String string = renderItemsJson;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                $this$getIntent_u24lambda_u241.putExtra(FigmaWebViewActivity.EXTRA_RENDER_ITEMS, it);
            }
            $this$getIntent_u24lambda_u241.setFlags(0x20000000);
            if (!(context instanceof Activity)) {
                $this$getIntent_u24lambda_u241.setFlags($this$getIntent_u24lambda_u241.getFlags() | 0x10000000);
            }
            return intent;
        }

        public static /* synthetic */ Intent getIntent$sdk_release$default(Companion companion, Context context, String string, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.getIntent$sdk_release(context, string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

