/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.internal.presentation.rule;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.Toast;
import androidx.activity.OnBackPressedCallback;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.RepeatOnLifecycleKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.apphud.sdk.Apphud;
import com.apphud.sdk.ApphudLog;
import com.apphud.sdk.ApphudPurchaseResult;
import com.apphud.sdk.R;
import com.apphud.sdk.domain.ApphudProduct;
import com.apphud.sdk.internal.presentation.rule.RuleViewModel;
import com.apphud.sdk.internal.presentation.rule.WebViewEvent;
import com.apphud.sdk.internal.presentation.rule.WebViewState;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0003J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0002J\u001a\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u001eH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/apphud/sdk/internal/presentation/rule/RuleWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "viewModel", "Lcom/apphud/sdk/internal/presentation/rule/RuleViewModel;", "webView", "Landroid/webkit/WebView;", "purchaseLoaderOverlay", "Landroid/widget/FrameLayout;", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "Landroid/content/Intent;", "processIntent", "setupWebView", "handleAction", "uri", "Landroid/net/Uri;", "sendResultBroadcast", "resultCode", "", "setupObservers", "startPurchase", "product", "Lcom/apphud/sdk/domain/ApphudProduct;", "offerToken", "", "showPurchaseLoader", "hidePurchaseLoader", "displayContent", "htmlContent", "Companion", "sdk_release"})
public final class RuleWebViewActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private RuleViewModel viewModel;
    private WebView webView;
    private FrameLayout purchaseLoaderOverlay;
    public static final int RESULT_PURCHASE = 100;
    public static final int RESULT_DISMISSED = 101;
    @NotNull
    private static final String EXTRA_RULE_ID = "EXTRA_RULE_ID";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.apphud_rule_webview_activity_layout);
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.purchaseLoaderOverlay = (FrameLayout)this.findViewById(R.id.purchaseLoaderOverlay);
        this.setupWebView();
        this.viewModel = (RuleViewModel)new ViewModelProvider((ViewModelStoreOwner)this, RuleViewModel.Companion.getFactory()).get(RuleViewModel.class);
        this.setupObservers();
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        this.processIntent(intent);
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, new OnBackPressedCallback(this){
            final /* synthetic */ RuleWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(true);
            }

            public void handleOnBackPressed() {
                RuleViewModel ruleViewModel = RuleWebViewActivity.access$getViewModel$p(this.this$0);
                if (ruleViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    ruleViewModel = null;
                }
                ruleViewModel.processBackPressed();
            }
        });
    }

    protected void onNewIntent(@Nullable Intent intent) {
        super.onNewIntent(intent);
        if (intent != null) {
            this.setIntent(intent);
            this.processIntent(intent);
        }
    }

    private final void processIntent(Intent intent) {
        String ruleId = intent.getStringExtra(EXTRA_RULE_ID);
        ApphudLog.INSTANCE.log("[RuleWebViewActivity] Processing intent: ruleId: " + ruleId);
        RuleViewModel ruleViewModel = this.viewModel;
        if (ruleViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            ruleViewModel = null;
        }
        ruleViewModel.processRuleId(ruleId);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void setupWebView() {
        WebSettings webSettings;
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        WebSettings $this$setupWebView_u24lambda_u240 = webSettings = webView.getSettings();
        boolean bl = false;
        $this$setupWebView_u24lambda_u240.setJavaScriptEnabled(true);
        $this$setupWebView_u24lambda_u240.setDomStorageEnabled(true);
        $this$setupWebView_u24lambda_u240.setLoadsImagesAutomatically(true);
        $this$setupWebView_u24lambda_u240.setUseWideViewPort(true);
        $this$setupWebView_u24lambda_u240.setLoadWithOverviewMode(true);
        $this$setupWebView_u24lambda_u240.setMixedContentMode(0);
        $this$setupWebView_u24lambda_u240.setAllowFileAccess(true);
        $this$setupWebView_u24lambda_u240.setGeolocationEnabled(true);
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView2 = null;
        }
        webView2.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                block0: {
                    ConsoleMessage consoleMessage2 = consoleMessage;
                    if (consoleMessage2 == null) break block0;
                    ConsoleMessage it = consoleMessage2;
                    boolean bl = false;
                    String message = "Console: " + it.message() + " -- From line " + it.lineNumber() + " of " + it.sourceId();
                    ApphudLog.INSTANCE.log(message);
                }
                return true;
            }
        });
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView3 = null;
        }
        webView3.setWebViewClient(new WebViewClient(this){
            final /* synthetic */ RuleWebViewActivity this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                WebResourceError webResourceError = error;
                WebResourceRequest webResourceRequest = request;
                ApphudLog.INSTANCE.logE("[RuleWebViewActivity] WebView error: " + (webResourceError != null ? webResourceError.getDescription() : null) + ", URL: " + (webResourceRequest != null ? webResourceRequest.getUrl() : null));
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                ApphudLog.INSTANCE.log("[RuleWebViewActivity] Page loaded: " + url);
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                WebResourceResponse webResourceResponse = errorResponse;
                WebResourceResponse webResourceResponse2 = errorResponse;
                WebResourceRequest webResourceRequest = request;
                ApphudLog.INSTANCE.logE("[RuleWebViewActivity] HTTP Error: " + (webResourceResponse != null ? Integer.valueOf(webResourceResponse.getStatusCode()) : null) + " - " + (webResourceResponse2 != null ? webResourceResponse2.getReasonPhrase() : null) + " for URL: " + (webResourceRequest != null ? webResourceRequest.getUrl() : null));
            }

            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                WebResourceRequest webResourceRequest = request;
                if (webResourceRequest != null && (webResourceRequest = webResourceRequest.getUrl()) != null) {
                    WebResourceRequest webResourceRequest2 = webResourceRequest;
                    RuleWebViewActivity ruleWebViewActivity = this.this$0;
                    WebResourceRequest uri = webResourceRequest2;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"http") || Intrinsics.areEqual((Object)uri.getScheme(), (Object)"https")) {
                        String path;
                        String string = uri.getPath();
                        if (string == null) {
                            string = "";
                        }
                        if (Intrinsics.areEqual((Object)(path = string), (Object)"/action")) {
                            RuleWebViewActivity.access$handleAction(ruleWebViewActivity, (Uri)uri);
                            return true;
                        }
                        if (Intrinsics.areEqual((Object)path, (Object)"/link")) {
                            String externalUrl;
                            String string2 = externalUrl = uri.getQueryParameter("url");
                            if (string2 != null) {
                                String it = string2;
                                boolean bl2 = false;
                                ApphudLog.INSTANCE.log("[RuleWebViewActivity] External link: " + it);
                            }
                            return true;
                        }
                    }
                }
                return super.shouldOverrideUrlLoading(view, request);
            }
        });
    }

    private final void handleAction(Uri uri) {
        String type2 = uri.getQueryParameter("type");
        ApphudLog.INSTANCE.log("[RuleWebViewActivity] Handling action: " + type2 + ", URI: " + uri);
        String string = type2;
        if (Intrinsics.areEqual((Object)string, (Object)"dismiss")) {
            RuleViewModel ruleViewModel = this.viewModel;
            if (ruleViewModel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                ruleViewModel = null;
            }
            ruleViewModel.processDismiss();
        } else if (Intrinsics.areEqual((Object)string, (Object)"purchase")) {
            String productId = uri.getQueryParameter("product_id");
            String offerId = uri.getQueryParameter("offer_id");
            if (productId != null) {
                ApphudLog.INSTANCE.log("[RuleWebViewActivity] Purchase action for product: " + productId + ", offer: " + offerId);
                RuleViewModel ruleViewModel = this.viewModel;
                if (ruleViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                    ruleViewModel = null;
                }
                ruleViewModel.processPurchase(productId, offerId);
            }
        }
    }

    private final void sendResultBroadcast(int resultCode) {
        Intent intent;
        Intent $this$sendResultBroadcast_u24lambda_u241 = intent = new Intent("com.apphud.sdk.ACTION_RULE_SCREEN_RESULT");
        boolean bl = false;
        $this$sendResultBroadcast_u24lambda_u241.putExtra("result_code", resultCode);
        $this$sendResultBroadcast_u24lambda_u241.setPackage(this.getPackageName());
        Intent intent2 = intent;
        this.sendBroadcast(intent2);
    }

    private final void setupObservers() {
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RuleWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = RepeatOnLifecycleKt.repeatOnLifecycle((LifecycleOwner)((LifecycleOwner)this.this$0), (Lifecycle.State)Lifecycle.State.STARTED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ RuleWebViewActivity this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        RuleViewModel ruleViewModel = RuleWebViewActivity.access$getViewModel$p(this.this$0);
                                        if (ruleViewModel == null) {
                                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                                            ruleViewModel = null;
                                        }
                                        this.label = 1;
                                        Object object3 = ruleViewModel.getState().collect(new FlowCollector(this.this$0){
                                            final /* synthetic */ RuleWebViewActivity this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(WebViewState state, Continuation<? super Unit> $completion) {
                                                WebViewState webViewState = state;
                                                if (webViewState instanceof WebViewState.Loading) {
                                                    RuleWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.Content) {
                                                    RuleWebViewActivity.access$displayContent(this.this$0, ((WebViewState.Content)state).getRuleScreen().getHtmlScreen());
                                                    RuleWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.ContentWithPurchaseLoading) {
                                                    RuleWebViewActivity.access$displayContent(this.this$0, ((WebViewState.ContentWithPurchaseLoading)state).getRuleScreen().getHtmlScreen());
                                                    RuleWebViewActivity.access$showPurchaseLoader(this.this$0);
                                                } else if (webViewState instanceof WebViewState.Error) {
                                                    ApphudLog.INSTANCE.logE("[RuleWebViewActivity] Error: " + ((WebViewState.Error)state).getMessage());
                                                    RuleWebViewActivity.access$hidePurchaseLoader(this.this$0);
                                                } else {
                                                    throw new NoWhenBranchMatchedException();
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object3 != object2) throw new KotlinNothingValueException();
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RuleWebViewActivity this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        RuleViewModel ruleViewModel = RuleWebViewActivity.access$getViewModel$p(this.this$0);
                        if (ruleViewModel == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                            ruleViewModel = null;
                        }
                        this.label = 1;
                        Object object3 = ruleViewModel.getEvents().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ RuleWebViewActivity this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(WebViewEvent event, Continuation<? super Unit> $completion) {
                                WebViewEvent webViewEvent = event;
                                if (webViewEvent instanceof WebViewEvent.CloseScreen) {
                                    RuleWebViewActivity.access$sendResultBroadcast(this.this$0, 101);
                                    this.this$0.finishAndRemoveTask();
                                } else if (Intrinsics.areEqual((Object)webViewEvent, (Object)WebViewEvent.PurchaseCompleted.INSTANCE)) {
                                    RuleWebViewActivity.access$sendResultBroadcast(this.this$0, 100);
                                    this.this$0.finishAndRemoveTask();
                                } else if (Intrinsics.areEqual((Object)webViewEvent, (Object)WebViewEvent.ProductNotFound.INSTANCE)) {
                                    Toast.makeText((Context)((Context)this.this$0), (CharSequence)"Product or offer not found", (int)0).show();
                                    RuleWebViewActivity.access$sendResultBroadcast(this.this$0, 101);
                                    this.this$0.finishAndRemoveTask();
                                } else if (webViewEvent instanceof WebViewEvent.StartPurchase) {
                                    RuleWebViewActivity.access$startPurchase(this.this$0, ((WebViewEvent.StartPurchase)event).getProduct(), ((WebViewEvent.StartPurchase)event).getOfferToken());
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void startPurchase(ApphudProduct product, String offerToken) {
        Apphud.purchase$default(Apphud.INSTANCE, (Activity)this, product, offerToken, null, null, false, arg_0 -> RuleWebViewActivity.startPurchase$lambda$2(this, arg_0), 56, null);
    }

    private final void showPurchaseLoader() {
        FrameLayout frameLayout = this.purchaseLoaderOverlay;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"purchaseLoaderOverlay");
            frameLayout = null;
        }
        frameLayout.setVisibility(0);
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setEnabled(false);
    }

    private final void hidePurchaseLoader() {
        FrameLayout frameLayout = this.purchaseLoaderOverlay;
        if (frameLayout == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"purchaseLoaderOverlay");
            frameLayout = null;
        }
        frameLayout.setVisibility(8);
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setEnabled(true);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void displayContent(String htmlContent) {
        try {
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            webView.loadDataWithBaseURL("https://static.apphud.com/", htmlContent, "text/html", "UTF-8", null);
        }
        catch (Exception e) {
            ApphudLog.INSTANCE.logE("[RuleWebViewActivity] Error loading HTML: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static final Unit startPurchase$lambda$2(RuleWebViewActivity this$0, ApphudPurchaseResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        RuleViewModel ruleViewModel = this$0.viewModel;
        if (ruleViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
            ruleViewModel = null;
        }
        ruleViewModel.onPurchaseResult(result);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ RuleViewModel access$getViewModel$p(RuleWebViewActivity $this) {
        return $this.viewModel;
    }

    public static final /* synthetic */ void access$handleAction(RuleWebViewActivity $this, Uri uri) {
        $this.handleAction(uri);
    }

    public static final /* synthetic */ void access$hidePurchaseLoader(RuleWebViewActivity $this) {
        $this.hidePurchaseLoader();
    }

    public static final /* synthetic */ void access$displayContent(RuleWebViewActivity $this, String htmlContent) {
        $this.displayContent(htmlContent);
    }

    public static final /* synthetic */ void access$showPurchaseLoader(RuleWebViewActivity $this) {
        $this.showPurchaseLoader();
    }

    public static final /* synthetic */ void access$sendResultBroadcast(RuleWebViewActivity $this, int resultCode) {
        $this.sendResultBroadcast(resultCode);
    }

    public static final /* synthetic */ void access$startPurchase(RuleWebViewActivity $this, ApphudProduct product, String offerToken) {
        $this.startPurchase(product, offerToken);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/apphud/sdk/internal/presentation/rule/RuleWebViewActivity$Companion;", "", "<init>", "()V", "RESULT_PURCHASE", "", "RESULT_DISMISSED", "EXTRA_RULE_ID", "", "getIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "ruleId", "getIntent$sdk_release", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Intent getIntent$sdk_release(@NotNull Context context, @NotNull String ruleId) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
            Intent $this$getIntent_u24lambda_u240 = intent = new Intent(context, RuleWebViewActivity.class);
            boolean bl = false;
            $this$getIntent_u24lambda_u240.putExtra(RuleWebViewActivity.EXTRA_RULE_ID, ruleId);
            $this$getIntent_u24lambda_u240.setFlags(0x20000000);
            if (!(context instanceof Activity)) {
                $this$getIntent_u24lambda_u240.setFlags($this$getIntent_u24lambda_u240.getFlags() | 0x10000000);
            }
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

