/*
 * Decompiled with CFR 0.152.
 */
package com.apphud.sdk.managers;

import com.apphud.sdk.client.ApiClient;
import java.io.IOException;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/apphud/sdk/managers/HeadersInterceptor;", "Lokhttp3/Interceptor;", "apiKey", "", "(Ljava/lang/String;)V", "uuidKey", "getUuidKey", "()Ljava/lang/String;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "Shared", "sdk_release"})
public final class HeadersInterceptor
implements Interceptor {
    @NotNull
    public static final Shared Shared = new Shared(null);
    @Nullable
    private final String apiKey;
    @NotNull
    private final String uuidKey;
    @NotNull
    private static String X_SDK_VERSION = "2.7.4";
    @NotNull
    private static String X_SDK = "Kotlin";
    private static boolean isBlocked;

    public HeadersInterceptor(@Nullable String apiKey) {
        this.apiKey = apiKey;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.uuidKey = string;
    }

    @NotNull
    public final String getUuidKey() {
        return this.uuidKey;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request userAgentRequest = chain.request().newBuilder().header("User-Agent", "Apphud Android (" + X_SDK + ' ' + X_SDK_VERSION + ')').header("Authorization", "Bearer " + this.apiKey).header("Accept", "application/json; utf-8").header("Content-Type", "application/json; charset=utf-8").header("X-Platform", "android").header("X-Store", "play_store").header("X-SDK", X_SDK).header("X-SDK-VERSION", X_SDK_VERSION).header("Idempotency-Key", this.uuidKey).build();
        return chain.proceed(userAgentRequest);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u0006\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/apphud/sdk/managers/HeadersInterceptor$Shared;", "", "()V", "HOST", "", "getHOST", "()Ljava/lang/String;", "X_SDK", "getX_SDK", "setX_SDK", "(Ljava/lang/String;)V", "X_SDK_VERSION", "getX_SDK_VERSION", "setX_SDK_VERSION", "isBlocked", "", "()Z", "setBlocked", "(Z)V", "sdk_release"})
    public static final class Shared {
        private Shared() {
        }

        @NotNull
        public final String getX_SDK_VERSION() {
            return X_SDK_VERSION;
        }

        public final void setX_SDK_VERSION(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            X_SDK_VERSION = string;
        }

        @NotNull
        public final String getX_SDK() {
            return X_SDK;
        }

        public final void setX_SDK(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            X_SDK = string;
        }

        @NotNull
        public final String getHOST() {
            return ApiClient.INSTANCE.getHost();
        }

        public final boolean isBlocked() {
            return isBlocked;
        }

        public final void setBlocked(boolean bl) {
            isBlocked = bl;
        }

        public /* synthetic */ Shared(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

