/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.widget.TextView;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Stylish {
    static final Map<String, Typeface> TYPEFACE = new HashMap<String, Typeface>();
    private static final String TAG = Stylish.class.getSimpleName();
    static String FONT_REGULAR = "";
    static String FONT_BOLD = "";
    static String FONT_ITALIC = "";
    static String FONT_BOLD_ITALIC = "";
    private static final Stylish instance = new Stylish();
    private float fontScale = 1.0f;

    private Stylish() {
    }

    public void set(String regular, String bold, String italic) {
        FONT_REGULAR = regular;
        FONT_BOLD = bold;
        FONT_ITALIC = italic;
    }

    public void set(String regular, String bold, String italic, String boldItalic) {
        FONT_REGULAR = regular;
        FONT_BOLD = bold;
        FONT_ITALIC = italic;
        FONT_BOLD_ITALIC = boldItalic;
    }

    public void setFontRegular(String fontRegular) {
        FONT_REGULAR = fontRegular;
    }

    public void setFontBold(String fontBold) {
        FONT_BOLD = fontBold;
    }

    public void setFontItalic(String fontItalic) {
        FONT_ITALIC = fontItalic;
    }

    public void setFontBoldItalic(String fontBoldItalic) {
        FONT_BOLD_ITALIC = fontBoldItalic;
    }

    public static Stylish getInstance() {
        return instance;
    }

    public Typeface getTypeface(Context context, String font, int style) {
        Typeface typeface;
        if (!TYPEFACE.containsKey(font)) {
            try {
                typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)font);
                TYPEFACE.put(font, typeface);
            }
            catch (Exception e) {
                typeface = Typeface.defaultFromStyle((int)style);
            }
        } else {
            typeface = TYPEFACE.get(font);
        }
        return typeface;
    }

    public Typeface reqular(Context context) {
        return this.getTypeface(context, FONT_REGULAR, 0);
    }

    public Typeface bold(Context context) {
        return this.getTypeface(context, FONT_BOLD, 1);
    }

    public Typeface italic(Context context) {
        return this.getTypeface(context, FONT_ITALIC, 2);
    }

    public Typeface boldItalic(Context context) {
        return this.getTypeface(context, FONT_BOLD_ITALIC, 3);
    }

    boolean isExist(Context context, String font) {
        try {
            return Arrays.asList(context.getResources().getAssets().list("")).contains(font);
        }
        catch (IOException e) {
            return false;
        }
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public void setFontScale(float fontScale) {
        this.fontScale = fontScale;
    }

    public Typeface getRegular() {
        return TYPEFACE.get(FONT_REGULAR);
    }

    public Typeface getBold() {
        return TYPEFACE.get(FONT_BOLD);
    }

    public Typeface getItalic() {
        return TYPEFACE.get(FONT_ITALIC);
    }

    public Typeface getBoldItalic() {
        return TYPEFACE.get(FONT_BOLD_ITALIC);
    }

    public void setTextStyle(TextView textView, int style) {
        String font;
        switch (style) {
            case 1: {
                font = FONT_BOLD;
                break;
            }
            case 2: {
                font = FONT_ITALIC;
                break;
            }
            case 0: {
                font = FONT_REGULAR;
                break;
            }
            case 3: {
                font = FONT_BOLD_ITALIC;
                break;
            }
            default: {
                font = FONT_REGULAR;
            }
        }
        try {
            textView.setTypeface(Stylish.getInstance().getTypeface(textView.getContext(), font, style));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

