/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.Gravity;
import com.app.infideap.stylishwidget.view.ATextView;

public class AVerticalTextView
extends ATextView {
    final boolean topDown;

    public AVerticalTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int gravity = this.getGravity();
        if (Gravity.isVertical((int)gravity) && (gravity & 0x70) == 80) {
            this.setGravity(gravity & 7 | 0x30);
            this.topDown = false;
        } else {
            this.topDown = true;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(heightMeasureSpec, widthMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected void onDraw(Canvas canvas) {
        TextPaint textPaint = this.getPaint();
        textPaint.setColor(this.getCurrentTextColor());
        textPaint.drawableState = this.getDrawableState();
        canvas.save();
        if (this.topDown) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.rotate(90.0f);
        } else {
            canvas.translate(0.0f, (float)this.getHeight());
            canvas.rotate(-90.0f);
        }
        canvas.translate((float)this.getCompoundPaddingLeft(), (float)this.getExtendedPaddingTop());
        this.getLayout().draw(canvas);
        canvas.restore();
    }

    @Override
    public void setSupportTextAppearance(int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.setTextAppearance(resId);
        } else {
            this.setTextAppearance(this.getContext(), resId);
        }
    }
}

