/*
 * Decompiled with CFR 0.152.
 */
package com.app.infideap.stylishwidget.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.support.annotation.Px;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.app.infideap.stylishwidget.R;
import com.app.infideap.stylishwidget.util.Utils;
import java.util.Locale;

public class AMeter
extends LinearLayout {
    private static final String TAG = AMeter.class.getSimpleName();
    private float value;
    private int meterColor;
    private View view;
    private float startAngle = 130.0f;
    private float sweepAngle = 280.0f;
    private float maxValue;
    private View needle1View;
    private View needle2View;
    private int textStyle;
    private float textSize;
    private int gapBottom = (int)Utils.convertDpToPixel(30.0f);
    private int minimumSize = (int)Utils.convertDpToPixel(250.0f);
    private boolean showText;
    private int numberOfLine = 1;
    private float startValue = 0.0f;
    private boolean showNeedle;
    private float lineStrokeSize;
    private float lineWidth;
    private String unit;
    Paint paint = new Paint();

    @RequiresApi(api=11)
    public AMeter(Context context) {
        super(context);
        this.setCustomAttr(context, null);
    }

    @RequiresApi(api=11)
    public AMeter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setCustomAttr(context, attrs);
    }

    @RequiresApi(api=11)
    public AMeter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setCustomAttr(context, attrs);
    }

    @RequiresApi(api=11)
    private void setCustomAttr(Context context, AttributeSet attrs) {
        int textStyle;
        this.initView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.meterAttr);
        this.setMeterColor(a.getColor(R.styleable.meterAttr_sw_meterColor, -1));
        this.setShowNeedle(a.getBoolean(R.styleable.meterAttr_sw_showNeedle, true));
        this.setLineWidth(a.getFloat(R.styleable.meterAttr_sw_lineWidth, 1.0f));
        this.setLineStrokeSize(a.getDimension(R.styleable.meterAttr_sw_lineStrokeSize, Utils.convertDpToPixel(10.0f)));
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.textAttr);
        this.setTextSize(a.getDimension(R.styleable.textAttr_sw_textSize, this.getResources().getDimension(R.dimen.meterTextSize)));
        try {
            textStyle = a.getInt(R.styleable.textAttr_sw_textStyle, 1);
        }
        catch (Exception e) {
            textStyle = 1;
        }
        this.setTextStyle(textStyle);
        a.recycle();
        a = this.getContext().obtainStyledAttributes(attrs, R.styleable.constraintAttr);
        this.setShowText(a.getBoolean(R.styleable.constraintAttr_sw_showText, true));
        this.setValue(a.getFloat(R.styleable.constraintAttr_sw_value, 0.0f));
        this.setStartValue(a.getFloat(R.styleable.constraintAttr_sw_startValue, 0.0f));
        this.setMaxValue(a.getFloat(R.styleable.constraintAttr_sw_maxValue, 1.0f));
        this.setNumberOfLine(a.getInt(R.styleable.constraintAttr_sw_numberOfLine, 1));
        this.setUnit(a.getString(R.styleable.constraintAttr_sw_unit));
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getLayoutParams().width != this.getLayoutParams().height || this.getLayoutParams().width == -2) {
            if (this.getLayoutParams().width != -1 && this.getLayoutParams().width < this.minimumSize) {
                this.getLayoutParams().width = this.minimumSize;
            }
            if (this.getLayoutParams().height != -1 && this.getLayoutParams().height < this.minimumSize) {
                this.getLayoutParams().height = this.minimumSize;
            }
            if (this.getHeight() < this.getWidth()) {
                this.getLayoutParams().height = this.getWidth();
            }
            this.setLayoutParams(this.getLayoutParams());
            super.onMeasure(widthMeasureSpec, widthMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setGravity(17);
        this.setPadding(super.getPaddingLeft(), super.getPaddingTop(), super.getPaddingRight(), super.getPaddingBottom());
        this.view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_needle, (ViewGroup)this, false);
        this.addView(this.view);
        this.needle1View = this.view.findViewById(R.id.view_needle_1);
        this.needle2View = this.view.findViewById(R.id.view_needle_2);
    }

    @RequiresApi(api=11)
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int alphaColor = Utils.adjustAlpha(this.meterColor, 70);
        this.paint.setColor(alphaColor);
        float width = (float)this.getWidth() - (float)super.getPaddingRight() - (float)super.getPaddingLeft();
        float height = (float)this.getHeight() - (float)super.getPaddingTop() - (float)super.getPaddingBottom();
        float radius = width / 2.0f;
        Path path = new Path();
        path.addCircle(width / 2.0f, height / 2.0f, radius, Path.Direction.CW);
        float strokeSize = this.lineStrokeSize;
        this.paint.setStrokeWidth(strokeSize);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStyle(Paint.Style.STROKE);
        float center_x = width / 2.0f + (float)super.getPaddingLeft();
        float center_y = height / 2.0f + (float)super.getPaddingTop();
        RectF oval = new RectF();
        oval.set(center_x - (radius -= strokeSize / 2.0f), center_y - radius, center_x + radius, center_y + radius);
        int numberOfLine = this.numberOfLine;
        float perBit = this.sweepAngle / (float)(numberOfLine * 2 - 1);
        float lineWidth = numberOfLine <= 1 ? 1.0f : this.lineWidth;
        float bit = perBit * lineWidth;
        float weight = numberOfLine <= 1 ? 1.0f : 0.5f * lineWidth;
        float totalBit = bit * (float)numberOfLine;
        float totalSpaceBit = this.sweepAngle - totalBit;
        float space = numberOfLine <= 1 ? 0.0f : totalSpaceBit / (float)(numberOfLine - 1);
        float progress = this.value * (float)numberOfLine / this.maxValue;
        float startProgress = this.startValue * (float)numberOfLine / this.maxValue;
        this.paint.setColor(alphaColor);
        for (int i = 0; i < numberOfLine; ++i) {
            canvas.drawArc(oval, this.startAngle + bit * (float)i + space * (float)i, bit, false, this.paint);
        }
        if (startProgress < progress) {
            this.paint.setColor(this.meterColor);
            int loopStart = (int)startProgress;
            float diff = startProgress - (float)loopStart;
            if (diff > 0.0f) {
                if (diff < weight) {
                    float balance = progress - startProgress;
                    float start = this.startAngle + startProgress * (bit + space);
                    float angle = balance < weight ? bit * balance : bit * (weight - diff);
                    canvas.drawArc(oval, start, angle, false, this.paint);
                }
                startProgress = loopStart + 1;
            }
            int i = (int)startProgress;
            while ((float)i < progress) {
                float balance = progress - (float)i;
                canvas.drawArc(oval, this.startAngle + bit * (float)i + space * (float)i, balance < weight ? bit * balance : bit, false, this.paint);
                ++i;
            }
        }
        if (this.showText) {
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setTextAlign(Paint.Align.CENTER);
            this.paint.setColor(this.meterColor);
            this.paint.setTextSize(this.textSize);
            String text = String.format(Locale.getDefault(), "%.0f", Float.valueOf(this.value * 100.0f / this.maxValue));
            if (this.unit.length() <= 1) {
                text = text.concat(this.unit);
            }
            if (this.showNeedle) {
                canvas.drawText(text, center_x, center_y + radius + (float)(this.gapBottom / 3), this.paint);
                if (this.unit.length() > 1) {
                    this.paint.setTextSize(this.textSize / 4.0f);
                    canvas.drawText(this.unit, center_x, center_y + radius + (float)(this.gapBottom / 3) + this.textSize / 3.5f, this.paint);
                }
            } else {
                canvas.drawText(text, center_x, center_y + this.textSize / 2.0f, this.paint);
                if (this.unit.length() > 1) {
                    this.paint.setTextSize(this.textSize / 4.0f);
                    canvas.drawText(this.unit, center_x, center_y + this.textSize / 2.0f + this.textSize / 3.5f, this.paint);
                }
            }
        }
    }

    @RequiresApi(api=11)
    private void rotateNeedle() {
        if (this.view != null) {
            float progress = this.value * this.sweepAngle / this.maxValue;
            progress = progress > this.sweepAngle ? this.sweepAngle : progress;
            this.view.setRotation(-90.0f + (this.startAngle - 90.0f) + progress);
        }
    }

    @RequiresApi(api=11)
    public void setValue(float value) {
        this.value = value;
        if (value > this.maxValue) {
            this.maxValue = value;
        }
        this.invalidate();
        this.rotateNeedle();
    }

    public void setMeterColor(int meterColor) {
        this.meterColor = meterColor;
        this.needle1View.getBackground().setColorFilter(meterColor, PorterDuff.Mode.SRC_ATOP);
        this.needle2View.getBackground().setColorFilter(meterColor, PorterDuff.Mode.SRC_ATOP);
        this.invalidate();
    }

    @RequiresApi(api=11)
    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.invalidate();
        this.rotateNeedle();
    }

    public float getValue() {
        return this.value;
    }

    public int getMeterColor() {
        return this.meterColor;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setTextStyle(int textStyle) {
        this.textStyle = textStyle;
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public void setPadding(@Px int left, @Px int top, @Px int right, @Px int bottom) {
        super.setPadding(left + this.gapBottom, top + this.gapBottom, right + this.gapBottom, bottom + this.gapBottom);
    }

    public int getPaddingBottom() {
        return super.getPaddingBottom() - this.gapBottom;
    }

    public int getPaddingTop() {
        return super.getPaddingTop() - this.gapBottom;
    }

    public int getPaddingLeft() {
        return super.getPaddingLeft() - this.gapBottom;
    }

    public int getPaddingRight() {
        return super.getPaddingRight() - this.gapBottom;
    }

    public void setShowText(boolean showText) {
        this.showText = showText;
        this.invalidate();
    }

    public boolean isShowText() {
        return this.showText;
    }

    public void setNumberOfLine(int numberOfLine) {
        this.numberOfLine = numberOfLine;
        this.invalidate();
    }

    public int getNumberOfLine() {
        return this.numberOfLine;
    }

    @RequiresApi(api=11)
    public void setStartValue(float startValue) {
        this.startValue = startValue;
        this.invalidate();
    }

    public float getStartValue() {
        return this.startValue;
    }

    public void setShowNeedle(boolean showNeedle) {
        this.showNeedle = showNeedle;
        this.view.setVisibility(showNeedle ? 0 : 8);
    }

    public boolean isShowNeedle() {
        return this.showNeedle;
    }

    public void setLineStrokeSize(float lineStrokeSize) {
        this.lineStrokeSize = lineStrokeSize;
        this.needle1View.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)lineStrokeSize, (int)Utils.convertDpToPixel(10.0f)));
        this.invalidate();
    }

    public float getLineStrokeSize() {
        return this.lineStrokeSize;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? "" : unit.trim();
        this.invalidate();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        this.invalidate();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }
}

