/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.subscription.callback;

import com.apollographql.subscription.exception.CallbackExtensionNotSpecifiedException;
import com.apollographql.subscription.exception.InvalidCallbackExtensionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Mono;

public record SubscriptionCallback(@NotNull String callback_url, @NotNull String subscription_id, @NotNull String verifier, int heartbeatIntervalMs, @NotNull Map<String, List<String>> context) {
    public static String SUBSCRIPTION_EXTENSION = "subscription";
    public static String CALLBACK_URL = "callbackUrl";
    public static String SUBSCRIPTION_ID = "subscriptionId";
    public static String VERIFIER = "verifier";
    public static String HEARTBEAT_INTERVAL_MS = "heartbeatIntervalMs";
    @Deprecated
    private static int DEFAULT_HEARTBEAT_INTERVAL_MS = 5000;
    @Deprecated
    private static String DEPRECATED_CALLBACK_URL = "callback_url";
    @Deprecated
    private static String DEPRECATED_SUBSCRIPTION_ID = "subscription_id";
    @Deprecated
    private static String DEPRECATED_HEARTBEAT_INTERVAL_MS = "heartbeat_interval_ms";

    public SubscriptionCallback(@NotNull String callback_url, @NotNull String subscription_id, @NotNull String verifier, int heartbeatIntervalMs) {
        this(callback_url, subscription_id, verifier, heartbeatIntervalMs, new HashMap<String, List<String>>());
    }

    @NotNull
    public SubscriptionCallback withContext(@NotNull Map<String, List<String>> context) {
        return new SubscriptionCallback(this.callback_url, this.subscription_id, this.verifier, this.heartbeatIntervalMs, context);
    }

    @NotNull
    public static Mono<SubscriptionCallback> parseSubscriptionCallbackExtension(@NotNull Map<String, Object> extensions) {
        Object subscription_extension = extensions.get(SUBSCRIPTION_EXTENSION);
        if (subscription_extension instanceof Map) {
            Object subscription_id;
            Map subscription = (Map)subscription_extension;
            Object callback_url = subscription.get(CALLBACK_URL);
            if (callback_url == null) {
                callback_url = subscription.get(DEPRECATED_CALLBACK_URL);
            }
            if ((subscription_id = subscription.get(SUBSCRIPTION_ID)) == null) {
                subscription_id = subscription.get(DEPRECATED_SUBSCRIPTION_ID);
            }
            Object verifier = subscription.get(VERIFIER);
            Object rawHeartbeatMs = subscription.get(HEARTBEAT_INTERVAL_MS);
            if (rawHeartbeatMs == null) {
                rawHeartbeatMs = subscription.get(DEPRECATED_HEARTBEAT_INTERVAL_MS);
            }
            int heartbeatMs = SubscriptionCallback.parseHeartbeats(rawHeartbeatMs);
            if (callback_url != null && subscription_id != null && verifier != null && heartbeatMs >= 0) {
                return Mono.just((Object)new SubscriptionCallback((String)callback_url, (String)subscription_id, (String)verifier, heartbeatMs));
            }
            return Mono.error((Throwable)new InvalidCallbackExtensionException(subscription));
        }
        return Mono.error((Throwable)new CallbackExtensionNotSpecifiedException());
    }

    private static int parseHeartbeats(Object heartbeatMs) {
        if (heartbeatMs != null) {
            try {
                return (Integer)heartbeatMs;
            }
            catch (ClassCastException e) {
                return -1;
            }
        }
        return DEFAULT_HEARTBEAT_INTERVAL_MS;
    }
}

