/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.federation.graphqljava;

import com.apollographql.federation.graphqljava._FieldSet;
import graphql.PublicApi;
import graphql.introspection.Introspection;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@PublicApi
public final class FederationDirectives {
    private static final DirectiveLocation DL_OBJECT = DirectiveLocation.newDirectiveLocation().name("OBJECT").build();
    private static final DirectiveLocation DL_INTERFACE = DirectiveLocation.newDirectiveLocation().name("INTERFACE").build();
    private static final DirectiveLocation DL_FIELD_DEFINITION = DirectiveLocation.newDirectiveLocation().name("FIELD_DEFINITION").build();
    private static final DirectiveLocation DL_SCHEMA = DirectiveLocation.newDirectiveLocation().name("SCHEMA").build();
    private static final DirectiveLocation DL_UNION = DirectiveLocation.newDirectiveLocation().name("UNION").build();
    private static final GraphQLArgument fieldsArgument = GraphQLArgument.newArgument().name("fields").type((GraphQLInputType)new GraphQLNonNull((GraphQLType)_FieldSet.type)).build();
    private static final InputValueDefinition fieldsDefinition = InputValueDefinition.newInputValueDefinition().name("fields").type((Type)new NonNullType((Type)new TypeName("_FieldSet"))).build();
    public static final String keyName = "key";
    public static final GraphQLDirective key = GraphQLDirective.newDirective().name("key").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE}).argument(fieldsArgument).repeatable(true).build();
    public static final DirectiveDefinition keyDefinition = DirectiveDefinition.newDirectiveDefinition().name("key").directiveLocations(Arrays.asList(DL_OBJECT, DL_INTERFACE)).inputValueDefinition(fieldsDefinition).repeatable(true).build();
    public static final String externalName = "external";
    public static final GraphQLDirective external = GraphQLDirective.newDirective().name("external").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION}).build();
    public static final DirectiveDefinition externalDefinition = DirectiveDefinition.newDirectiveDefinition().name("external").directiveLocations(Collections.singletonList(DL_FIELD_DEFINITION)).build();
    public static final String requiresName = "requires";
    public static final GraphQLDirective requires = GraphQLDirective.newDirective().name("requires").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION}).argument(fieldsArgument).build();
    public static final DirectiveDefinition requiresDefinition = DirectiveDefinition.newDirectiveDefinition().name("requires").directiveLocations(Collections.singletonList(DL_FIELD_DEFINITION)).inputValueDefinition(fieldsDefinition).build();
    public static final String providesName = "provides";
    public static final GraphQLDirective provides = GraphQLDirective.newDirective().name("provides").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.FIELD_DEFINITION}).argument(fieldsArgument).build();
    public static final DirectiveDefinition providesDefinition = DirectiveDefinition.newDirectiveDefinition().name("provides").directiveLocations(Collections.singletonList(DL_FIELD_DEFINITION)).inputValueDefinition(fieldsDefinition).build();
    public static final String extendsName = "extends";
    public static final GraphQLDirective extends_ = GraphQLDirective.newDirective().name("extends").validLocations(new Introspection.DirectiveLocation[]{Introspection.DirectiveLocation.OBJECT, Introspection.DirectiveLocation.INTERFACE}).build();
    public static final DirectiveDefinition extendsDefinition = DirectiveDefinition.newDirectiveDefinition().name("extends").directiveLocations(Arrays.asList(DL_OBJECT, DL_INTERFACE)).build();
    public static final String shareableName = "shareable";
    public static final DirectiveDefinition shareableDefinition = DirectiveDefinition.newDirectiveDefinition().name("shareable").directiveLocations(Arrays.asList(DL_FIELD_DEFINITION, DL_OBJECT)).build();
    public static final String linkName = "link";
    public static final DirectiveDefinition linkDefinition = DirectiveDefinition.newDirectiveDefinition().name("link").directiveLocations(Collections.singletonList(DL_SCHEMA)).inputValueDefinition(InputValueDefinition.newInputValueDefinition().name("url").type((Type)new NonNullType((Type)new TypeName("String"))).build()).inputValueDefinition(InputValueDefinition.newInputValueDefinition().name("import").type((Type)new ListType((Type)new TypeName("link__Import"))).build()).repeatable(true).build();
    public static final String tagName = "tag";
    public static final DirectiveDefinition tagDefinition = DirectiveDefinition.newDirectiveDefinition().name("tag").directiveLocations(Arrays.asList(DL_FIELD_DEFINITION, DL_INTERFACE, DL_OBJECT, DL_UNION)).repeatable(true).build();
    public static final Set<String> allNames;
    public static final Set<GraphQLDirective> allDirectives;
    public static final Set<DirectiveDefinition> allDefinitions;
    public static final Set<DirectiveDefinition> federation2Definitions;

    private static GraphQLArgument fieldsArgument(String value) {
        return GraphQLArgument.newArgument((GraphQLArgument)fieldsArgument).value((Object)value).build();
    }

    public static GraphQLDirective key(String fields) {
        return GraphQLDirective.newDirective((GraphQLDirective)key).argument(FederationDirectives.fieldsArgument(fields)).build();
    }

    public static GraphQLDirective requires(String fields) {
        return GraphQLDirective.newDirective((GraphQLDirective)requires).argument(FederationDirectives.fieldsArgument(fields)).build();
    }

    public static GraphQLDirective provides(String fields) {
        return GraphQLDirective.newDirective((GraphQLDirective)provides).argument(FederationDirectives.fieldsArgument(fields)).build();
    }

    private FederationDirectives() {
    }

    static {
        allDirectives = Stream.of(key, external, requires, provides, extends_).sorted(Comparator.comparing(GraphQLDirective::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        allDefinitions = Stream.of(keyDefinition, externalDefinition, requiresDefinition, providesDefinition, extendsDefinition).sorted(Comparator.comparing(DirectiveDefinition::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        federation2Definitions = Stream.of(shareableDefinition, linkDefinition, tagDefinition).sorted(Comparator.comparing(DirectiveDefinition::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        allNames = allDefinitions.stream().map(DirectiveDefinition::getName).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

