/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.tooling;

import com.apollographql.apollo3.annotations.ApolloExperimental;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Optional;
import com.apollographql.apollo3.tooling.CannotModifyOperationBody;
import com.apollographql.apollo3.tooling.GraphNotFound;
import com.apollographql.apollo3.tooling.GraphosKt;
import com.apollographql.apollo3.tooling.PermissionError;
import com.apollographql.apollo3.tooling.PersistedQuery;
import com.apollographql.apollo3.tooling.PublishOperationsResult;
import com.apollographql.apollo3.tooling.PublishOperationsSuccess;
import com.apollographql.apollo3.tooling.platformapi.public.PublishOperationsMutation;
import com.apollographql.apollo3.tooling.platformapi.public.type.OperationType;
import com.apollographql.apollo3.tooling.platformapi.public.type.PersistedQueryInput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0007\u00a8\u0006\t"}, d2={"publishOperations", "Lcom/apollographql/apollo3/tooling/PublishOperationsResult;", "listId", "", "persistedQueries", "", "Lcom/apollographql/apollo3/tooling/PersistedQuery;", "apolloKey", "graph", "apollo-tooling"})
public final class PersistedQueriesUploaderKt {
    @ApolloExperimental
    @NotNull
    public static final PublishOperationsResult publishOperations(@NotNull String listId, @NotNull List<PersistedQuery> persistedQueries, @NotNull String apolloKey, @Nullable String graph) {
        PublishOperationsResult publishOperationsResult;
        Intrinsics.checkNotNullParameter((Object)listId, (String)"listId");
        Intrinsics.checkNotNullParameter(persistedQueries, (String)"persistedQueries");
        Intrinsics.checkNotNullParameter((Object)apolloKey, (String)"apolloKey");
        String string = graph;
        if (string == null && (string = GraphosKt.getGraph(apolloKey)) == null) {
            throw new IllegalStateException("graph not found".toString());
        }
        String graphID = string;
        ApolloResponse response2 = (ApolloResponse)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ApolloResponse<PublishOperationsMutation.Data>>, Object>(graphID, listId, persistedQueries, apolloKey, null){
            int label;
            final /* synthetic */ String $graphID;
            final /* synthetic */ String $listId;
            final /* synthetic */ List<PersistedQuery> $persistedQueries;
            final /* synthetic */ String $apolloKey;
            {
                this.$graphID = $graphID;
                this.$listId = $listId;
                this.$persistedQueries = $persistedQueries;
                this.$apolloKey = $apolloKey;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Collection<PersistedQueryInput> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable iterable = this.$persistedQueries;
                        Optional.Companion companion = Optional.Companion;
                        String string = this.$listId;
                        String string2 = this.$graphID;
                        boolean $i$f$map = false;
                        void var5_8 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PersistedQuery persistedQuery = (PersistedQuery)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            String string3 = it.getBody();
                            String string4 = it.getId();
                            String string5 = it.getName();
                            String string6 = it.getOperationType().toUpperCase(Locale.ROOT);
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
                            collection.add(new PersistedQueryInput(string3, string4, string5, OperationType.Companion.safeValueOf(string6)));
                        }
                        collection = (List)destination$iv$iv;
                        Optional optional = companion.present((Object)collection);
                        String string7 = string;
                        String string8 = string2;
                        PublishOperationsMutation mutation = new PublishOperationsMutation(string8, string7, (Optional<? extends List<PersistedQueryInput>>)optional);
                        this.label = 1;
                        Object object3 = GraphosKt.getApolloClient().mutation((Mutation)mutation).addHttpHeader("x-api-key", this.$apolloKey).execute((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ApolloResponse<PublishOperationsMutation.Data>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        PublishOperationsMutation.Graph graph1 = ((PublishOperationsMutation.Data)response2.dataOrThrow()).getGraph();
        if (graph1 == null) {
            return GraphNotFound.INSTANCE;
        }
        PublishOperationsMutation.PublishOperations ops = graph1.getPersistedQueryList().getPublishOperations();
        if (ops.getOnPublishOperationsResult() != null) {
            PublishOperationsMutation.OperationCounts counts = ops.getOnPublishOperationsResult().getBuild().getPublish().getOperationCounts();
            publishOperationsResult = new PublishOperationsSuccess(counts.getAdded(), counts.getRemoved(), counts.getIdentical(), counts.getUpdated(), counts.getUnaffected(), ops.getOnPublishOperationsResult().getBuild().getList().getName(), ops.getOnPublishOperationsResult().getBuild().getRevision());
        } else if (ops.getOnPermissionError() != null) {
            publishOperationsResult = new PermissionError(ops.getOnPermissionError().getMessage());
        } else if (ops.getOnCannotModifyOperationBodyError() != null) {
            publishOperationsResult = new CannotModifyOperationBody(ops.getOnCannotModifyOperationBodyError().getMessage());
        } else {
            throw new IllegalStateException("".toString());
        }
        return publishOperationsResult;
    }
}

