/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.rx2;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloPrefetch;
import com.apollographql.apollo3.ApolloQueryWatcher;
import com.apollographql.apollo3.ApolloSubscriptionCall;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.exception.ApolloException;
import com.apollographql.apollo3.api.internal.Utils;
import com.apollographql.apollo3.internal.subscription.ApolloSubscriptionTerminatedException;
import com.apollographql.apollo3.internal.util.Cancelable;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import org.jetbrains.annotations.NotNull;

public class Rx2Apollo {
    private Rx2Apollo() {
        throw new AssertionError((Object)"This class cannot be instantiated");
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Observable<ApolloResponse<D>> from(final @NotNull ApolloQueryWatcher<D> watcher) {
        Utils.checkNotNull(watcher, (Object)"watcher == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ApolloResponse<D>>(){

            public void subscribe(final ObservableEmitter<ApolloResponse<D>> emitter) throws Exception {
                ApolloQueryWatcher clone = watcher.clone();
                Rx2Apollo.cancelOnObservableDisposed(emitter, (Cancelable)clone);
                clone.enqueueAndWatch(new ApolloCall.Callback<D>(){

                    public void onResponse(@NotNull ApolloResponse<? extends D> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Observable<ApolloResponse<D>> from(final @NotNull ApolloCall<D> call) {
        Utils.checkNotNull(call, (Object)"call == null");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<ApolloResponse<D>>(){

            public void subscribe(final ObservableEmitter<ApolloResponse<D>> emitter) throws Exception {
                ApolloCall clone = call.clone();
                Rx2Apollo.cancelOnObservableDisposed(emitter, (Cancelable)clone);
                clone.enqueue(new ApolloCall.Callback<D>(){

                    public void onResponse(@NotNull ApolloResponse<? extends D> response) {
                        if (!emitter.isDisposed()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onStatusEvent(@NotNull ApolloCall.StatusEvent event) {
                        if (event == ApolloCall.StatusEvent.COMPLETED && !emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static Completable from(final @NotNull ApolloPrefetch prefetch) {
        Utils.checkNotNull((Object)prefetch, (Object)"prefetch == null");
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(final CompletableEmitter emitter) {
                ApolloPrefetch clone = prefetch.clone();
                Rx2Apollo.cancelOnCompletableDisposed(emitter, (Cancelable)clone);
                clone.enqueue(new ApolloPrefetch.Callback(){

                    public void onSuccess() {
                        if (!emitter.isDisposed()) {
                            emitter.onComplete();
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isDisposed()) {
                            emitter.onError((Throwable)e);
                        }
                    }
                });
            }
        });
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Flowable<ApolloResponse<D>> from(@NotNull ApolloSubscriptionCall<D> call) {
        return Rx2Apollo.from(call, BackpressureStrategy.LATEST);
    }

    @CheckReturnValue
    @NotNull
    public static <D extends Operation.Data> Flowable<ApolloResponse<D>> from(final @NotNull ApolloSubscriptionCall<D> call, @NotNull BackpressureStrategy backpressureStrategy) {
        Utils.checkNotNull(call, (Object)"originalCall == null");
        Utils.checkNotNull((Object)backpressureStrategy, (Object)"backpressureStrategy == null");
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<ApolloResponse<D>>(){

            public void subscribe(final FlowableEmitter<ApolloResponse<D>> emitter) throws Exception {
                ApolloSubscriptionCall clone = call.clone();
                Rx2Apollo.cancelOnFlowableDisposed(emitter, (Cancelable)clone);
                clone.execute(new ApolloSubscriptionCall.Callback<D>(){

                    public void onResponse(@NotNull ApolloResponse<? extends D> response) {
                        if (!emitter.isCancelled()) {
                            emitter.onNext(response);
                        }
                    }

                    public void onFailure(@NotNull ApolloException e) {
                        Exceptions.throwIfFatal((Throwable)e);
                        if (!emitter.isCancelled()) {
                            emitter.onError((Throwable)e);
                        }
                    }

                    public void onCompleted() {
                        if (!emitter.isCancelled()) {
                            emitter.onComplete();
                        }
                    }

                    public void onTerminated() {
                        this.onFailure((ApolloException)new ApolloSubscriptionTerminatedException("Subscription server unexpectedly terminated connection"));
                    }

                    public void onConnected() {
                    }
                });
            }
        }, (BackpressureStrategy)backpressureStrategy);
    }

    private static void cancelOnCompletableDisposed(CompletableEmitter emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static <T> void cancelOnObservableDisposed(ObservableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static <T> void cancelOnFlowableDisposed(FlowableEmitter<T> emitter, Cancelable cancelable) {
        emitter.setDisposable(Rx2Apollo.getRx2Disposable(cancelable));
    }

    private static Disposable getRx2Disposable(final Cancelable cancelable) {
        return new Disposable(){

            public void dispose() {
                cancelable.cancel();
            }

            public boolean isDisposed() {
                return cancelable.isCanceled();
            }
        };
    }
}

