/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo3.internal.fetcher;

import com.apollographql.apollo3.api.internal.ApolloLogger;
import com.apollographql.apollo3.api.internal.Optional;
import com.apollographql.apollo3.exception.ApolloException;
import com.apollographql.apollo3.fetcher.ResponseFetcher;
import com.apollographql.apollo3.interceptor.ApolloInterceptor;
import com.apollographql.apollo3.interceptor.ApolloInterceptorChain;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo3/internal/fetcher/CacheAndNetworkFetcher;", "Lcom/apollographql/apollo3/fetcher/ResponseFetcher;", "()V", "provideInterceptor", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "apolloLogger", "Lcom/apollographql/apollo3/api/internal/ApolloLogger;", "CacheAndNetworkInterceptor", "apollo-runtime"})
public final class CacheAndNetworkFetcher
implements ResponseFetcher {
    @Override
    @NotNull
    public ApolloInterceptor provideInterceptor(@Nullable ApolloLogger apolloLogger) {
        return new CacheAndNetworkInterceptor();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0007J(\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/apollographql/apollo3/internal/fetcher/CacheAndNetworkFetcher$CacheAndNetworkInterceptor;", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor;", "()V", "cacheException", "Lcom/apollographql/apollo3/api/internal/Optional;", "Lcom/apollographql/apollo3/exception/ApolloException;", "cacheResponse", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorResponse;", "dispatchedCacheResult", "", "disposed", "networkException", "networkResponse", "originalCallback", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$CallBack;", "dispatch", "", "dispose", "handleCacheError", "exception", "handleCacheResponse", "response", "handleNetworkError", "handleNetworkResponse", "interceptAsync", "request", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptor$InterceptorRequest;", "chain", "Lcom/apollographql/apollo3/interceptor/ApolloInterceptorChain;", "dispatcher", "Ljava/util/concurrent/Executor;", "callBack", "apollo-runtime"})
    private static final class CacheAndNetworkInterceptor
    implements ApolloInterceptor {
        private Optional<ApolloInterceptor.InterceptorResponse> cacheResponse = Optional.Companion.absent();
        private Optional<ApolloInterceptor.InterceptorResponse> networkResponse = Optional.Companion.absent();
        private Optional<ApolloException> cacheException = Optional.Companion.absent();
        private Optional<ApolloException> networkException = Optional.Companion.absent();
        private boolean dispatchedCacheResult;
        private ApolloInterceptor.CallBack originalCallback;
        private volatile boolean disposed;

        @Override
        public void interceptAsync(@NotNull ApolloInterceptor.InterceptorRequest request, @NotNull ApolloInterceptorChain chain, @NotNull Executor dispatcher, @NotNull ApolloInterceptor.CallBack callBack) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
            Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
            Intrinsics.checkParameterIsNotNull((Object)callBack, (String)"callBack");
            if (this.disposed) {
                return;
            }
            this.originalCallback = callBack;
            ApolloInterceptor.InterceptorRequest cacheRequest = request.toBuilder().fetchFromCache(true).build();
            chain.proceedAsync(cacheRequest, dispatcher, new ApolloInterceptor.CallBack(this, callBack){
                final /* synthetic */ CacheAndNetworkInterceptor this$0;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    this.this$0.handleCacheResponse(response);
                }

                public void onFailure(@NotNull ApolloException e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.this$0.handleCacheError(e);
                }

                public void onCompleted() {
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)sourceType), (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }
                {
                    this.this$0 = this$0;
                    this.$callBack = $captured_local_variable$1;
                }
            });
            ApolloInterceptor.InterceptorRequest networkRequest = request.toBuilder().fetchFromCache(false).build();
            chain.proceedAsync(networkRequest, dispatcher, new ApolloInterceptor.CallBack(this, callBack){
                final /* synthetic */ CacheAndNetworkInterceptor this$0;
                final /* synthetic */ ApolloInterceptor.CallBack $callBack;

                public void onResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    this.this$0.handleNetworkResponse(response);
                }

                public void onFailure(@NotNull ApolloException e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.this$0.handleNetworkError(e);
                }

                public void onCompleted() {
                }

                public void onFetch(@NotNull ApolloInterceptor.FetchSourceType sourceType) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)sourceType), (String)"sourceType");
                    this.$callBack.onFetch(sourceType);
                }
                {
                    this.this$0 = this$0;
                    this.$callBack = $captured_local_variable$1;
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }

        public final synchronized void handleNetworkResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            this.networkResponse = Optional.Companion.of(response);
            this.dispatch();
        }

        public final synchronized void handleNetworkError(@NotNull ApolloException exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            this.networkException = Optional.Companion.of(exception);
            this.dispatch();
        }

        public final synchronized void handleCacheResponse(@NotNull ApolloInterceptor.InterceptorResponse response) {
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            this.cacheResponse = Optional.Companion.of(response);
            this.dispatch();
        }

        public final synchronized void handleCacheError(@NotNull ApolloException exception) {
            Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
            this.cacheException = Optional.Companion.of(exception);
            this.dispatch();
        }

        private final synchronized void dispatch() {
            if (this.disposed) {
                return;
            }
            if (!this.dispatchedCacheResult) {
                if (this.cacheResponse.isPresent()) {
                    ApolloInterceptor.CallBack callBack = this.originalCallback;
                    if (callBack == null) {
                        Intrinsics.throwNpe();
                    }
                    callBack.onResponse(this.cacheResponse.get());
                    this.dispatchedCacheResult = true;
                } else if (this.cacheException.isPresent()) {
                    this.dispatchedCacheResult = true;
                }
            }
            if (this.dispatchedCacheResult) {
                if (this.networkResponse.isPresent()) {
                    ApolloInterceptor.CallBack callBack = this.originalCallback;
                    if (callBack == null) {
                        Intrinsics.throwNpe();
                    }
                    callBack.onResponse(this.networkResponse.get());
                    ApolloInterceptor.CallBack callBack2 = this.originalCallback;
                    if (callBack2 == null) {
                        Intrinsics.throwNpe();
                    }
                    callBack2.onCompleted();
                } else if (this.networkException.isPresent()) {
                    ApolloInterceptor.CallBack callBack = this.originalCallback;
                    if (callBack == null) {
                        Intrinsics.throwNpe();
                    }
                    callBack.onFailure(this.networkException.get());
                }
            }
        }
    }
}

